# Perioperative Nursing Data Set - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Perioperative Nursing Data Set**

## NamingSystem: Perioperative Nursing Data Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/pnds | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*AORN | *Computable Name*:Pnds |

 
The PNDS provides standardized terms and codes for patient problems/nursing diagnoses, nursing interventions including actual or expected (goal) outcomes. The PNDS provides standardized terms and codes for nursing diagnoses (a subset of NANDA), nursing interventions and outcomes. The outcomes and interventions are in a relational database. The PNDS intervention and outcome statements are attached in an Access Database. The NANDA diagnoses in the PNDS have already been registered by HL7. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/pnds |
| Version | 2.1.0 |
| Name | Pnds |
| Title | Perioperative Nursing Data Set |
| Status | retired |
| Definition | The PNDS provides standardized terms and codes for patient problems/nursing diagnoses, nursing interventions including actual or expected (goal) outcomes. The PNDS provides standardized terms and codes for nursing diagnoses (a subset of NANDA), nursing interventions and outcomes. The outcomes and interventions are in a relational database. The PNDS intervention and outcome statements are attached in an Access Database. The NANDA diagnoses in the PNDS have already been registered by HL7. |
| Publisher | AORN |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.22
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/pnds
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "pnds",
  "url" : "http://terminology.hl7.org/NamingSystem/pnds",
  "version" : "2.1.0",
  "name" : "Pnds",
  "title" : "Perioperative Nursing Data Set",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "AORN",
  "contact" : [
    {
      "name" : "Suzanne C. Beyea, PhD, RN - AORN"
    }
  ],
  "responsible" : "AORN",
  "description" : "The PNDS provides standardized terms and codes for patient problems/nursing diagnoses, nursing interventions including actual or expected (goal) outcomes. The PNDS provides standardized terms and codes for nursing diagnoses (a subset of NANDA), nursing interventions and outcomes. The outcomes and interventions are in a relational database. The PNDS intervention and outcome statements are attached in an Access Database. The NANDA diagnoses in the PNDS have already been registered by HL7.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.22",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/pnds",
      "preferred" : true
    }
  ]
}

```
