# Passport Numbers Namespace for INDIA - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for INDIA**

## NamingSystem: Passport Numbers Namespace for INDIA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-IND | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_IND |

 
Identifier of the namespace for Passport Numbers issued by the country of INDIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-IND |
| Version | 1.0.0 |
| Name | PassportNumNS_IND |
| Title | Passport Numbers Namespace for INDIA |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of INDIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.356
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-IND
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-IND",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-IND",
  "version" : "1.0.0",
  "name" : "PassportNumNS_IND",
  "title" : "Passport Numbers Namespace for INDIA",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of INDIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.356",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-IND",
      "preferred" : true
    }
  ]
}

```
