# NCI Version of NDF-RT - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NCI Version of NDF-RT**

## NamingSystem: NCI Version of NDF-RT 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/nciVersionOfNDF-RT | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*NCI | *Computable Name*:NciVersionOfNDFRT |

 
The National Drug File RT (NDF-RT) is published by the US Veterans' Administration (VA). NDF-RT covers clinical drugs used at the VA. The NCI version of NDF-RT is used by NCI to provide automated terminology access to the Food and Drug Administration (FDA) Structured Product Label (SPL) initiative. NCI makes its version of NDF-RT available publicly thru the Web, download via FTP and via open APIs for Java, SOAP and HTTP. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/nciVersionOfNDF-RT |
| Version | 2.1.0 |
| Name | NciVersionOfNDFRT |
| Title | NCI Version of NDF-RT |
| Status | retired |
| Definition | The National Drug File RT (NDF-RT) is published by the US Veterans' Administration (VA). NDF-RT covers clinical drugs used at the VA. The NCI version of NDF-RT is used by NCI to provide automated terminology access to the Food and Drug Administration (FDA) Structured Product Label (SPL) initiative. NCI makes its version of NDF-RT available publicly thru the Web, download via FTP and via open APIs for Java, SOAP and HTTP. |
| Publisher | NCI |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.3.26.1.5
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/nciVersionOfNDF-RT
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "nciVersionOfNDF-RT",
  "url" : "http://terminology.hl7.org/NamingSystem/nciVersionOfNDF-RT",
  "version" : "2.1.0",
  "name" : "NciVersionOfNDFRT",
  "title" : "NCI Version of NDF-RT",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "NCI",
  "contact" : [
    {
      "name" : "National Cancer Institute"
    }
  ],
  "responsible" : "NCI",
  "description" : "The National Drug File RT (NDF-RT) is published by the US Veterans' Administration (VA). NDF-RT covers clinical drugs used at the VA. The NCI version of NDF-RT is used by NCI to provide automated terminology access to the Food and Drug Administration (FDA) Structured Product Label (SPL) initiative. NCI makes its version of NDF-RT available publicly thru the Web, download via FTP and via open APIs for Java, SOAP and HTTP.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.3.26.1.5",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/nciVersionOfNDF-RT",
      "preferred" : true
    }
  ]
}

```
