# Ethernet MAC Address as a device identifier - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ethernet MAC Address as a device identifier**

## NamingSystem: Ethernet MAC Address as a device identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ethernet-address-identifier | *Version*:2.1.0 | |
| Active as of 2021-06-14 | *Responsible:*IHE Patient Care Devices (PCD) | *Computable Name*:Ethernet_Address_Identifier |

 
The Ethernet MAC (media access control) address is a unique identifier assigned to a network interface controller (NIC) for use as a network address in communications within a network segment. This use is common in most IEEE 802 networking technologies. The address typically includes a manufacturer's organizationally unique identifier (OUI). MAC addresses are formed according to the principles of two numbering spaces based on Extended Unique Identifiers (EUI) managed by the Institute of Electrical and Electronics Engineers (IEEE): EUI-48. A device that has an Ethernet MAC address can also have it own Bluetooth MAC address. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ethernet-address-identifier |
| Version | 2.1.0 |
| Name | Ethernet_Address_Identifier |
| Title | Ethernet MAC Address as a device identifier |
| Status | active |
| Definition | The Ethernet MAC (media access control) address is a unique identifier assigned to a network interface controller (NIC) for use as a network address in communications within a network segment. This use is common in most IEEE 802 networking technologies. The address typically includes a manufacturer's organizationally unique identifier (OUI). MAC addresses are formed according to the principles of two numbering spaces based on Extended Unique Identifiers (EUI) managed by the Institute of Electrical and Electronics Engineers (IEEE): EUI-48. A device that has an Ethernet MAC address can also have it own Bluetooth MAC address. |
| Publisher | IHE Patient Care Devices (PCD) |

### Identifiers

* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/eui-48/ethernet
  * **Preferred**: true
  * **Comment**: Ethernet EUI-48 MAC address

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ethernet-address-identifier",
  "url" : "http://terminology.hl7.org/NamingSystem/ethernet-address-identifier",
  "version" : "2.1.0",
  "name" : "Ethernet_Address_Identifier",
  "title" : "Ethernet MAC Address as a device identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2021-06-14T00:00:00-00:00",
  "publisher" : "IHE Patient Care Devices (PCD)",
  "contact" : [
    {
      "name" : "Devices on FHIR working group; IHE Patient Care Devices"
    }
  ],
  "responsible" : "IHE Patient Care Devices",
  "description" : "The Ethernet MAC (media access control) address is a unique identifier assigned to a network interface controller (NIC) for use as a network address in communications within a network segment. This use is common in most IEEE 802 networking technologies.  The address typically includes a manufacturer's organizationally unique identifier (OUI). MAC addresses are formed according to the principles of two numbering spaces based on Extended Unique Identifiers (EUI) managed by the Institute of Electrical and Electronics Engineers (IEEE): EUI-48. A device that has an Ethernet MAC address can also have it own Bluetooth MAC address.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/eui-48/ethernet",
      "preferred" : true,
      "comment" : "Ethernet EUI-48 MAC address"
    }
  ]
}

```
