# United States Employer Identification Number - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **United States Employer Identification Number**

## NamingSystem: United States Employer Identification Number 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/USEIN | *Version*:1.0.0 |
| Active as of 2022-06-13 | *Computable Name*:USEIN |

 
An Employer Identification Number (EIN) is also known as a Federal Tax Identification Number, and is used to identify a business entity. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/USEIN |
| Version | 1.0.0 |
| Name | USEIN |
| Title | United States Employer Identification Number |
| Status | active |
| Definition | An Employer Identification Number (EIN) is also known as a Federal Tax Identification Number, and is used to identify a business entity. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.4
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: urn:oid:2.16.840.1.113883.4.4
  * **Preferred**: true
  * **Period**: 2022-06-02 --> (ongoing)
  * **Comment**: This is the URL endorsed by the HTA and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "USEIN",
  "url" : "http://terminology.hl7.org/NamingSystem/USEIN",
  "version" : "1.0.0",
  "name" : "USEIN",
  "title" : "United States Employer Identification Number",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-06-13T00:00:00-00:00",
  "contact" : [
    {
      "name" : "U.S. Internal Revenue Service",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.irs.gov/businesses/small-businesses-self-employed/employer-id-numbers"
        }
      ]
    }
  ],
  "description" : "An Employer Identification Number (EIN) is also known as a Federal Tax Identification Number, and is used to identify a business entity.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.4",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "urn:oid:2.16.840.1.113883.4.4",
      "preferred" : true,
      "comment" : "This is the URL endorsed by the HTA and is considered authoritative.",
      "period" : {
        "start" : "2022-06-02"
      }
    }
  ]
}

```
