# Source of Payment Typology - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Source of Payment Typology**

## NamingSystem: Source of Payment Typology 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/SOPT | *Version*:1.0.1 | |
| Active as of 2022-06-07 | *Responsible:*National Association of Health Data Organizations (NAHDO) | *Computable Name*:SOPT |

 
The Source of Payment Typology is a standardized Payer Type classification system. It is a mechanism for consistent reporting of payer data to state health data organizations and supports data comparisons by payer type across states, various provider types, and to national benchmarks. Developed by the Public Health Data Standards Consortium (PHDSC) Payer Typology Subcommittee, the typology includes broad hierarchial payer type categories with more specific subcategories. 
The audience for Source of Payment Typology includes researchers, public health advocates, and healthcare analysts. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/SOPT |
| Version | 1.0.1 |
| Name | SOPT |
| Title | Source of Payment Typology |
| Status | active |
| Definition | The Source of Payment Typology is a standardized Payer Type classification system. It is a mechanism for consistent reporting of payer data to state health data organizations and supports data comparisons by payer type across states, various provider types, and to national benchmarks. Developed by the Public Health Data Standards Consortium (PHDSC) Payer Typology Subcommittee, the typology includes broad hierarchial payer type categories with more specific subcategories.The audience for Source of Payment Typology includes researchers, public health advocates, and healthcare analysts. |
| Publisher | National Association of Health Data Organizations (NAHDO) |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.3.221.5
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: https://nahdo.org/sopt
  * **Preferred**: true
  * **Period**: 2020-05-20 00:00:00+0000 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "SOPT",
  "url" : "http://terminology.hl7.org/NamingSystem/SOPT",
  "version" : "1.0.1",
  "name" : "SOPT",
  "title" : "Source of Payment Typology",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-06-07T00:00:00-00:00",
  "publisher" : "National Association of Health Data Organizations (NAHDO)",
  "contact" : [
    {
      "name" : "National Association of Health Data Organizations (NAHDO); 124 South 400 East, Suite 220, Salt Lake City, Utah 84111-5312",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "801-532-2299"
        },
        {
          "system" : "email",
          "value" : "info@nahdo.org"
        }
      ]
    }
  ],
  "description" : "The Source of Payment Typology is a standardized Payer Type classification system. It is a mechanism for consistent reporting of payer data to state health data organizations and supports data comparisons by payer type across states, various provider types, and to national benchmarks.  Developed by the Public Health Data Standards Consortium (PHDSC) Payer Typology Subcommittee, the typology includes broad hierarchial payer type categories with more specific subcategories. \r\n\r\nThe audience for Source of Payment Typology includes researchers, public health advocates, and healthcare analysts.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.3.221.5",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://nahdo.org/sopt",
      "preferred" : true,
      "period" : {
        "start" : "2020-05-20T00:00:00-00:00"
      }
    }
  ]
}

```
