# OHDSI Standardized Vocabularies - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **OHDSI Standardized Vocabularies**

## NamingSystem: OHDSI Standardized Vocabularies 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/OMOP | *Version*:1.1.0 | |
| Active as of 2025-06-16 | *Responsible:*[Echidna Systems](https://echidna.systems) | *Computable Name*:OMOP |
| **Copyright/Legal**: (c) The OMOP Standardized Vocabularies Copyright Observational Health Data Sciences and Informatics, Columbia University, New York, NY. Licensed under Apache 2.0Copyright pertains to the OHDSI Standardized Vocabularies content, excluding source vocabulary codes, descriptions and related content originating from content developers other than OHDSI.The OMOP Vocabulary is a key component of the Observational Medical Outcomes Partnership (OMOP) Common Data Model (CDM) and the OHDSI Community mission. As such the OMOP Vocabulary content is managed under Open Science Principles, freely available under the terms of Apache 2.0 License, described below. The OMOP CDM format forces a different representation of each source vocabulary when compared to its native form. Therefore, the OHDSI Standardized Vocabularies are explicitly meant to be used for building an OMOP CDM and in some cases (such as for SNOMED) specific license restrictions limit its use within an OMOP CDM. The Vocabularies purpose are to support analytics and should not be used for purposes of individual patient healthcare.Unless otherwise specified for a few commercial vocabularies, vocabularies and their concepts are Open Source.[Apache License V2.0](https://www.apache.org/licenses/LICENSE-2.0)is followed for open source terms and conditions for use. Contributors provide an express grant of patent rights. Licensed works, modifications, and larger works may be distributed under different terms and without source code. A number of license restricted vocabularies that have been derived from commercially available content can only be accessed after requesting access and providing proof that the requesting user does hold a license for the vocabulary in question. Users of Commercial and other proprietary Source Vocabularies are required to provide EULA documentation or proof of licensure to OHDSI to access target OMOP Vocabulary components, including (OMOP Vocabulary short name in parentheses):* Current Procedural Terminology version 4 (CPT4)
* Medi-Span Generic Product Identifier (GPI)
* Medical Dictionary for Regulatory Activities (MedDR)
* First Data Bank Indications and Contraindications (Indication)
* First Data Bank Enhanced Therapeutic Classification (ETC)
* First Data Bank Multilex (Multilex)
* Resip Gemscript (Gemscript)
* IQVIA Disease Analyzer France (DA_France)
* IQVIA Longitudinal Patient Data Australia (LPD_Austrailia)
* IQVIA Global Reference Repository (GRR)
* ADA Current Dental Terminology (CDT)
* ICCBBA Information Standard for Blood and Transplant 128 Product (ISBT)
* ICCBBA Information Standard for Blood and Transplant 128 Product Attribute (ISBT Attribute)
* Brazilian Unified Health System Table of Procedures, Drugs, Orthoses, Protheses and Special Materials (SUS)
* CAP electronic Cancer Checklists (CAP)
* IQVIA CO-CONNECT (CO-CONNECT)
* IQVIA CO-CONNECT MIABIS (CO-CONNECT MIABIS)
* IQVIA CO-CONNECT TWINS (CO-CONNECT TWINS)
The license request process is manual. When registering for Athena, acknowledgment is required for individual vocabularies requiring a license to access. The requester will receive an email follow-up acknowledgement and instructions for accessing licensed OMOP Vocabulary content. | | |

 
Standardized Vocabularies are an integral part of the OMOP CDM. The Standardized Vocabularies contain all of the code sets, terminologies, vocabularies, nomenclatures, lexicons, thesauri, ontologies, taxonomies, classifications, abstractions, and other such data that are needed for: 
* Generation of the transformed (i.e., standardized) data from the raw source dataset into the OMOP CDM,
* Searching, querying and extraction of the transformed data, and browsing and navigating the hierarchies of classes and abstractions inherent in the transformed data, and
* Interpreting the meanings of the data.
 
This asset is available for free to anyone and can be[downloaded](https://athena.ohdsi.org/vocabulary/list)from the Atena download page in a delimited file format. 
To manage the change of content, but to allow users to use and refer to a defined set of vocabularies, the whole resource is issued in releases. Major changes to the OMOP Vocabulary is released twice yearly in February and August. Instead of a major / minor version scheme, the releases of the Standardized Vocabularies component of the OMOP Vocabulary are tagged with the release date. Version label is based on the version of the CDM its aligned-to, plus a suffix appended incremented based on release date, for example: “v5.0 31-MAY-23.” At this time prior versions of the OMOP Vocabulary are not publicly available. Each release is accompanied by a[standard release note](https://github.com/OHDSI/Vocabulary-v5.0/releases), containing information about: 
* Domain changes
* Newly added concepts grouped by vocabulary_id and domain
* Standard concept changes
* Newly added concepts and their standard concept status
* Changes of concept mapping status grouped by target domain
 
Additional details about the OMOP Vocabulary release notes can be found[here](https://github.com/OHDSI/Vocabulary-v5.0/wiki/Releases) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/OMOP |
| Version | 1.1.0 |
| Name | OMOP |
| Title | OHDSI Standardized Vocabularies |
| Status | active |
| Definition | Standardized Vocabularies are an integral part of the OMOP CDM. The Standardized Vocabularies contain all of the code sets, terminologies, vocabularies, nomenclatures, lexicons, thesauri, ontologies, taxonomies, classifications, abstractions, and other such data that are needed for:* Generation of the transformed (i.e., standardized) data from the raw source dataset into the OMOP CDM,
* Searching, querying and extraction of the transformed data, and browsing and navigating the hierarchies of classes and abstractions inherent in the transformed data, and
* Interpreting the meanings of the data.
This asset is available for free to anyone and can be [downloaded](https://athena.ohdsi.org/vocabulary/list) from the Atena download page in a delimited file format.To manage the change of content, but to allow users to use and refer to a defined set of vocabularies, the whole resource is issued in releases. Major changes to the OMOP Vocabulary is released twice yearly in February and August. Instead of a major / minor version scheme, the releases of the Standardized Vocabularies component of the OMOP Vocabulary are tagged with the release date. Version label is based on the version of the CDM its aligned-to, plus a suffix appended incremented based on release date, for example: “v5.0 31-MAY-23.” At this time prior versions of the OMOP Vocabulary are not publicly available. Each release is accompanied by a [standard release note](https://github.com/OHDSI/Vocabulary-v5.0/releases), containing information about:* Domain changes
* Newly added concepts grouped by vocabulary_id and domain
* Standard concept changes
* Newly added concepts and their standard concept status
* Changes of concept mapping status grouped by target domain
Additional details about the OMOP Vocabulary release notes can be found [here](https://github.com/OHDSI/Vocabulary-v5.0/wiki/Releases) |
| Publisher | Echidna Systems |
| Copyright | (c) The OMOP Standardized Vocabularies Copyright Observational Health Data Sciences and Informatics, Columbia University, New York, NY. Licensed under Apache 2.0Copyright pertains to the OHDSI Standardized Vocabularies content, excluding source vocabulary codes, descriptions and related content originating from content developers other than OHDSI.The OMOP Vocabulary is a key component of the Observational Medical Outcomes Partnership (OMOP) Common Data Model (CDM) and the OHDSI Community mission. As such the OMOP Vocabulary content is managed under Open Science Principles, freely available under the terms of Apache 2.0 License, described below. The OMOP CDM format forces a different representation of each source vocabulary when compared to its native form. Therefore, the OHDSI Standardized Vocabularies are explicitly meant to be used for building an OMOP CDM and in some cases (such as for SNOMED) specific license restrictions limit its use within an OMOP CDM. The Vocabularies purpose are to support analytics and should not be used for purposes of individual patient healthcare.Unless otherwise specified for a few commercial vocabularies, vocabularies and their concepts are Open Source. [Apache License V2.0](https://www.apache.org/licenses/LICENSE-2.0) is followed for open source terms and conditions for use. Contributors provide an express grant of patent rights. Licensed works, modifications, and larger works may be distributed under different terms and without source code. A number of license restricted vocabularies that have been derived from commercially available content can only be accessed after requesting access and providing proof that the requesting user does hold a license for the vocabulary in question. Users of Commercial and other proprietary Source Vocabularies are required to provide EULA documentation or proof of licensure to OHDSI to access target OMOP Vocabulary components, including (OMOP Vocabulary short name in parentheses):* Current Procedural Terminology version 4 (CPT4)
* Medi-Span Generic Product Identifier (GPI)
* Medical Dictionary for Regulatory Activities (MedDR)
* First Data Bank Indications and Contraindications (Indication)
* First Data Bank Enhanced Therapeutic Classification (ETC)
* First Data Bank Multilex (Multilex)
* Resip Gemscript (Gemscript)
* IQVIA Disease Analyzer France (DA_France)
* IQVIA Longitudinal Patient Data Australia (LPD_Austrailia)
* IQVIA Global Reference Repository (GRR)
* ADA Current Dental Terminology (CDT)
* ICCBBA Information Standard for Blood and Transplant 128 Product (ISBT)
* ICCBBA Information Standard for Blood and Transplant 128 Product Attribute (ISBT Attribute)
* Brazilian Unified Health System Table of Procedures, Drugs, Orthoses, Protheses and Special Materials (SUS)
* CAP electronic Cancer Checklists (CAP)
* IQVIA CO-CONNECT (CO-CONNECT)
* IQVIA CO-CONNECT MIABIS (CO-CONNECT MIABIS)
* IQVIA CO-CONNECT TWINS (CO-CONNECT TWINS)
The license request process is manual. When registering for Athena, acknowledgment is required for individual vocabularies requiring a license to access. The requester will receive an email follow-up acknowledgement and instructions for accessing licensed OMOP Vocabulary content. |

### Identifiers

* **Type**: URI
  * **Value**: https://fhir-terminology.ohdsi.org
  * **Preferred**: true
  * **Period**: 2023-11-30 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "OMOP",
  "url" : "http://terminology.hl7.org/NamingSystem/OMOP",
  "version" : "1.1.0",
  "name" : "OMOP",
  "title" : "OHDSI Standardized Vocabularies",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-06-16T00:00:00-00:00",
  "publisher" : "Echidna Systems",
  "contact" : [
    {
      "name" : "Guy Tsafnat c/o Wotso North Sydney, 50 Miller Street, North Sydney NSW, 2060",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://echidna.systems"
        },
        {
          "system" : "email",
          "value" : "info@echidna.systems"
        }
      ]
    }
  ],
  "responsible" : "Odysseus Data Services, Inc",
  "description" : "Standardized Vocabularies are an integral part of the OMOP CDM. The Standardized Vocabularies contain all of the code sets, terminologies, vocabularies, nomenclatures, lexicons, thesauri, ontologies, taxonomies, classifications, abstractions, and other such data that are needed for:\r\n\r\n* Generation of the transformed (i.e., standardized) data from the raw source dataset into the OMOP CDM,\r\n\r\n* Searching, querying and extraction of the transformed data, and browsing and navigating the hierarchies of classes and abstractions inherent in the transformed data, and\r\n\r\n* Interpreting the meanings of the data.\r\n\r\nThis asset is available for free to anyone and can be [downloaded](https://athena.ohdsi.org/vocabulary/list) from the Atena download page in a delimited file format.\r\n\r\nTo manage the change of content, but to allow users to use and refer to a defined set of vocabularies, the whole resource is issued in releases. Major changes to the OMOP Vocabulary is released twice yearly in February and August. Instead of a major / minor version scheme, the releases of the Standardized Vocabularies component of the OMOP Vocabulary are tagged with the release date. Version label is based on the version of the CDM its aligned-to, plus a suffix appended incremented based on release date, for example: “v5.0 31-MAY-23.” At this time prior versions of the OMOP Vocabulary are not publicly available. Each release is accompanied by a [standard release note](https://github.com/OHDSI/Vocabulary-v5.0/releases), containing information about:\r\n\r\n* Domain changes\r\n\r\n* Newly added concepts grouped by vocabulary_id and domain\r\n\r\n* Standard concept changes\r\n\r\n* Newly added concepts and their standard concept status\r\n\r\n* Changes of concept mapping status grouped by target domain\r\n\r\nAdditional details about the OMOP Vocabulary release notes can be found [here](https://github.com/OHDSI/Vocabulary-v5.0/wiki/Releases)",
  "copyright" : "(c) The OMOP Standardized Vocabularies Copyright Observational Health Data Sciences and Informatics, Columbia University, New York, NY. Licensed under Apache 2.0\r\n\r\nCopyright pertains to the OHDSI Standardized Vocabularies content, excluding source vocabulary codes, descriptions and related content originating from content developers other than OHDSI.\r\n\r\nThe OMOP Vocabulary is a key component of the Observational Medical Outcomes Partnership (OMOP) Common Data Model (CDM) and the OHDSI Community mission. As such the OMOP Vocabulary content is managed under Open Science Principles, freely available under the terms of Apache 2.0 License, described below. The OMOP CDM format forces a different representation of each source vocabulary when compared to its native form. Therefore, the OHDSI Standardized Vocabularies are explicitly meant to be used for building an OMOP CDM and in some cases (such as for SNOMED) specific license restrictions limit its use within an OMOP CDM. The Vocabularies purpose are to support analytics and should not be used for purposes of individual patient healthcare.\r\n\r\nUnless otherwise specified for a few commercial vocabularies, vocabularies and their concepts are Open Source. [Apache License V2.0](https://www.apache.org/licenses/LICENSE-2.0) is followed for open source terms and conditions for use. Contributors provide an express grant of patent rights. Licensed works, modifications, and larger works may be distributed under different terms and without source code. A number of license restricted vocabularies that have been derived from commercially available content can only be accessed after requesting access and providing proof that the requesting user does hold a license for the vocabulary in question. Users of Commercial and other proprietary Source Vocabularies are required to provide EULA documentation or proof of licensure to OHDSI to access target OMOP Vocabulary components, including (OMOP Vocabulary short name in parentheses):\r\n\r\n* Current Procedural Terminology version 4 (CPT4)\r\n\r\n* Medi-Span Generic Product Identifier (GPI)\r\n\r\n* Medical Dictionary for Regulatory Activities (MedDR)\r\n\r\n* First Data Bank Indications and Contraindications (Indication)\r\n\r\n* First Data Bank Enhanced Therapeutic Classification (ETC)\r\n\r\n* First Data Bank Multilex (Multilex)\r\n\r\n* Resip Gemscript (Gemscript)\r\n\r\n* IQVIA Disease Analyzer France (DA_France)\r\n\r\n* IQVIA Longitudinal Patient Data Australia (LPD_Austrailia)\r\n\r\n* IQVIA Global Reference Repository (GRR)\r\n\r\n* ADA Current Dental Terminology (CDT)\r\n\r\n* ICCBBA Information Standard for Blood and Transplant 128 Product (ISBT)\r\n\r\n* ICCBBA Information Standard for Blood and Transplant 128 Product Attribute (ISBT Attribute)\r\n\r\n* Brazilian Unified Health System Table of Procedures, Drugs, Orthoses, Protheses and Special Materials (SUS)\r\n\r\n* CAP electronic Cancer Checklists (CAP)\r\n\r\n* IQVIA CO-CONNECT (CO-CONNECT)\r\n\r\n* IQVIA CO-CONNECT MIABIS (CO-CONNECT MIABIS)\r\n\r\n* IQVIA CO-CONNECT TWINS (CO-CONNECT TWINS)\r\n\r\nThe license request process is manual. When registering for Athena, acknowledgment is required for individual vocabularies requiring a license to access. The requester will receive an email follow-up acknowledgement and instructions for accessing licensed OMOP Vocabulary content.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://fhir-terminology.ohdsi.org",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2023-11-30"
      }
    }
  ]
}

```
