# NCPDP Provider Identification Number - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NCPDP Provider Identification Number**

## NamingSystem: NCPDP Provider Identification Number 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NCPDPProviderIdentificationNumber | *Version*:1.0.1 | |
| Active as of 2021-03-10 | *Responsible:*National Council for Prescription Drug Programs | *Computable Name*:NCPDPProviderIdentificationNumber |

 
A NCPDP assigned number that provides pharmacies with a unique, 7-digit national identifying number that assists pharmacies in their interactions with federal agencies and third party providers. The NCPDP Provider Identification Number was formerly known as the NABP (National Board of Pharmacy) number. NCPDP also enumerates licensed dispensing sites in the United States as part of its Alternate Site Enumeration Program Numbering System (ASEP). The purpose of this system is to enable a site to identify itself to all third party processors by one standard number, in order to adjudicate claims and receive reimbursement from prescription card programs. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/NCPDPProviderIdentificationNumber |
| Version | 1.0.1 |
| Name | NCPDPProviderIdentificationNumber |
| Title | NCPDP Provider Identification Number |
| Status | active |
| Definition | A NCPDP assigned number that provides pharmacies with a unique, 7-digit national identifying number that assists pharmacies in their interactions with federal agencies and third party providers. The NCPDP Provider Identification Number was formerly known as the NABP (National Board of Pharmacy) number. NCPDP also enumerates licensed dispensing sites in the United States as part of its Alternate Site Enumeration Program Numbering System (ASEP). The purpose of this system is to enable a site to identify itself to all third party processors by one standard number, in order to adjudicate claims and receive reimbursement from prescription card programs. |
| Publisher | National Council for Prescription Drug Programs |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/NCPDPProviderIdentificationNumber
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NCPDPProviderIdentificationNumber",
  "url" : "http://terminology.hl7.org/NamingSystem/NCPDPProviderIdentificationNumber",
  "version" : "1.0.1",
  "name" : "NCPDPProviderIdentificationNumber",
  "title" : "NCPDP Provider Identification Number",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-10T00:00:00-04:00",
  "publisher" : "National Council for Prescription Drug Programs",
  "contact" : [
    {
      "name" : "National Council for Prescription Drug Programs",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "480.477.1000"
        },
        {
          "system" : "email",
          "value" : "info@ncpdp.org"
        }
      ]
    }
  ],
  "responsible" : "National Council for Prescription Drug Programs",
  "description" : "A NCPDP assigned number that provides pharmacies with a unique, 7-digit national identifying number that assists pharmacies in their interactions with federal agencies and third party providers. The NCPDP Provider Identification Number was formerly known as the NABP (National Board of Pharmacy) number. NCPDP also enumerates licensed dispensing sites in the United States as part of its Alternate Site Enumeration Program Numbering System (ASEP). The purpose of this system is to enable a site to identify itself to all third party processors by one standard number, in order to adjudicate claims and receive reimbursement from prescription card programs.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/NCPDPProviderIdentificationNumber",
      "preferred" : true
    }
  ]
}

```
