# GCRT - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GCRT**

## NamingSystem: GCRT 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/GCRT | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*HL7 | *Computable Name*:GCRT |

 
GCRT 
Route of Administration Code (1-character) 
a one-character alphanumeric column that provides the normal site or method by which a drug is administered, such as oral, injection, or topical. A GCRT is associated to each GCN_SEQNO to identify that component of the generic drug formulation. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/GCRT |
| Version | 2.1.0 |
| Name | GCRT |
| Title | GCRT |
| Status | retired |
| Definition | GCRTRoute of Administration Code (1-character)a one-character alphanumeric column that provides the normal site or method by which a drug is administered, such as oral, injection, or topical. A GCRT is associated to each GCN_SEQNO to identify that component of the generic drug formulation. |
| Publisher | HL7 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.80
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/GCRT
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "GCRT",
  "url" : "http://terminology.hl7.org/NamingSystem/GCRT",
  "version" : "2.1.0",
  "name" : "GCRT",
  "title" : "GCRT",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "First DataBank, Inc,First DataBank, Inc,First DataBank, Inc,First DataBank, Inc,First DataBank, Inc,"
    }
  ],
  "responsible" : "HL7",
  "description" : "GCRT\r\n\r\nRoute of Administration Code (1-character)\r\n\r\na one-character alphanumeric column that provides the normal site or method by which a drug is administered, such as oral, injection, or topical. A GCRT is associated to each GCN\\_SEQNO to identify that component of the generic drug formulation.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.80",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/GCRT",
      "preferred" : true
    }
  ]
}

```
