# Data Universal Numbering System (DUNS) Number - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Data Universal Numbering System (DUNS) Number**

## NamingSystem: Data Universal Numbering System (DUNS) Number 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/DUNSNumber | *Version*:1.0.0 |
| Active as of 2024-10-21 | *Responsible:*[Dun & Bradstreet/a>*Computable Name*:DUNSNumber**Copyright/Legal**: Dun & Bradstreet DUNS® Numbers are proprietary to and controlled by Dun & Bradstreet. Dun & Bradstreet grants you a non-exclusive, perpetual, limited license to use DUNS® Numbers (excluding linkage DUNS® Numbers) solely for identification purposes and only for your internal business use. Where practicable, you will refer to the number as a “DUNS® Number” and state that DUNS® is a registered trademark of Dun & Bradstreet. For more information, see[https://www.dnb.com/utility-pages/terms-of-use.html](https://www.dnb.com/utility-pages/terms-of-use.html)"The Dun & Bradstreet D-U-N-S® Number (short for Data Universal Numbering System) is a nine-digit unique identifier for businesses. Hundreds of millions of D-U-N-S Numbers exist for companies across the globe.A D-U-N-S Number is assigned through our patented identity resolution process, (part of our DUNSRight™ data governance, which includes thousands of separate automated checks.) The D-U-N-S Number identifies a company as being unique from any other in the[Dun & Bradstreet Data Cloud](https://www.dnb.com/about-us/data-cloud.html). It is used as the starting point for any company's[Live Business Identity](https://www.dnb.com/about-us/data-cloud/live-business-identity.html), which helps ensure you have the most accurate and up-to-date view of organizations."For more information, see[https://www.dnb.com/duns.html](https://www.dnb.com/duns.html).### Summary
| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/DUNSNumber |
| Version | 1.0.0 |
| Name | DUNSNumber |
| Title | Data Universal Numbering System (DUNS) Number |
| Status | active |
| Definition | "The Dun & Bradstreet D-U-N-S® Number (short for Data Universal Numbering System) is a nine-digit unique identifier for businesses. Hundreds of millions of D-U-N-S Numbers exist for companies across the globe.A D-U-N-S Number is assigned through our patented identity resolution process, (part of our DUNSRight™ data governance, which includes thousands of separate automated checks.) The D-U-N-S Number identifies a company as being unique from any other in the [Dun & Bradstreet Data Cloud](https://www.dnb.com/about-us/data-cloud.html). It is used as the starting point for any company's [Live Business Identity](https://www.dnb.com/about-us/data-cloud/live-business-identity.html), which helps ensure you have the most accurate and up-to-date view of organizations."For more information, see [https://www.dnb.com/duns.html](https://www.dnb.com/duns.html). |
| Publisher | Dun & Bradstreet |
| Copyright | Dun & Bradstreet DUNS® Numbers are proprietary to and controlled by Dun & Bradstreet. Dun & Bradstreet grants you a non-exclusive, perpetual, limited license to use DUNS® Numbers (excluding linkage DUNS® Numbers) solely for identification purposes and only for your internal business use. Where practicable, you will refer to the number as a “DUNS® Number” and state that DUNS® is a registered trademark of Dun & Bradstreet. For more information, see [https://www.dnb.com/utility-pages/terms-of-use.html](https://www.dnb.com/utility-pages/terms-of-use.html) |
### Identifiers
* **Type**: OID
  * **Value**: 1.3.6.1.4.1.519.1
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/NamingSystem/DUNSNumber
  * **Preferred**: true
  * **Period**: 2024-10-21 --> (ongoing)

-------
**History**](https://www.dnb.com/) |



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "DUNSNumber",
  "url" : "http://terminology.hl7.org/NamingSystem/DUNSNumber",
  "version" : "1.0.0",
  "name" : "DUNSNumber",
  "title" : "Data Universal Numbering System (DUNS) Number",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2024-10-21T00:00:00-00:00",
  "publisher" : "Dun & Bradstreet",
  "contact" : [
    {
      "name" : "Dun & Bradstreet; 5335 Gate Parkway, Jacksonville, FL 32256",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.dnb.com/"
        },
        {
          "system" : "phone",
          "value" : "(904)-648-6350"
        }
      ]
    }
  ],
  "responsible" : "Dun & Bradstreet",
  "description" : "\"The Dun & Bradstreet D-U-N-S® Number (short for Data Universal Numbering System) is a nine-digit unique identifier for businesses. Hundreds of millions of D-U-N-S Numbers exist for companies across the globe.\r\n\r\nA D-U-N-S Number is assigned through our patented identity resolution process, (part of our DUNSRight™ data governance, which includes thousands of separate automated checks.) The D-U-N-S Number identifies a company as being unique from any other in the [Dun & Bradstreet Data Cloud](https://www.dnb.com/about-us/data-cloud.html).  It is used as the starting point for any company's [Live Business Identity](https://www.dnb.com/about-us/data-cloud/live-business-identity.html), which helps ensure you have the most accurate and up-to-date view of organizations.\"\r\n\r\nFor more information, see [https://www.dnb.com/duns.html](https://www.dnb.com/duns.html).",
  "copyright" : "Dun & Bradstreet DUNS® Numbers are proprietary to and controlled by Dun & Bradstreet. Dun & Bradstreet grants you a non-exclusive, perpetual, limited license to use DUNS® Numbers (excluding linkage DUNS® Numbers) solely for identification purposes and only for your internal business use. Where practicable, you will refer to the number as a “DUNS® Number” and state that DUNS® is a registered trademark of Dun & Bradstreet. For more information, see [https://www.dnb.com/utility-pages/terms-of-use.html](https://www.dnb.com/utility-pages/terms-of-use.html)",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.3.6.1.4.1.519.1",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/NamingSystem/DUNSNumber",
      "preferred" : true,
      "period" : {
        "start" : "2024-10-21"
      }
    }
  ]
}

```
