# CDC Local Coding System - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CDC Local Coding System**

## NamingSystem: CDC Local Coding System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CDCLocal | *Version*:1.0.0 | |
| Active as of 2023-06-13 | *Responsible:*[U.S. Centers for Disease Control and Prevention (CDC)](https://www.cdc.gov/phin/tools/phinvads/index.html) | *Computable Name*:CDCLocal |
| **Copyright/Legal**: "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission."For information and exceptions regarding use of CDC material please see[here](https://www.cdc.gov/other/agencymaterials.html) | | |

 
"CDC Public Health Information Network local coding system used for creating the concepts that are not available in the Standard Development Organization (SDO) Vocabulary like SNOMED CT, LOINC, ICD-9, etc." 
Versioning numbered according to PHIN VADS convention. 
For more information, see[https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CDCLocal |
| Version | 1.0.0 |
| Name | CDCLocal |
| Title | CDC Local Coding System |
| Status | active |
| Definition | "CDC Public Health Information Network local coding system used for creating the concepts that are not available in the Standard Development Organization (SDO) Vocabulary like SNOMED CT, LOINC, ICD-9, etc."Versioning numbered according to PHIN VADS convention.For more information, see [https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274). |
| Publisher | U.S. Centers for Disease Control and Prevention (CDC) |
| Copyright | "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission."For information and exceptions regarding use of CDC material please see [here](https://www.cdc.gov/other/agencymaterials.html) |

### Identifiers

* **Type**: URI
  * **Value**: https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274
  * **Preferred**: true
  * **Period**: 2022-06-15 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.
* **Type**: OID
  * **Value**: 2.16.840.1.114222.4.5.274
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CDCLocal",
  "url" : "http://terminology.hl7.org/NamingSystem/CDCLocal",
  "version" : "1.0.0",
  "name" : "CDCLocal",
  "title" : "CDC Local Coding System",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-06-13T00:00:00-00:00",
  "publisher" : "U.S. Centers for Disease Control and Prevention (CDC)",
  "contact" : [
    {
      "name" : "U.S. Centers for Disease Control and Prevention (CDC)",
      "telecom" : [
        {
          "system" : "email",
          "value" : "phinvs@cdc.gov"
        },
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/phin/tools/phinvads/index.html"
        }
      ]
    }
  ],
  "description" : "\"CDC Public Health Information Network local coding system used for creating the concepts that are not available in the Standard Development Organization (SDO) Vocabulary like SNOMED CT, LOINC, ICD-9, etc.\"\r\n\r\nVersioning numbered according to PHIN VADS convention.\r\n\r\nFor more information, see [https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274).",
  "copyright" : "\"Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.\"\r\n\r\nFor information and exceptions regarding use of CDC material please see [here](https://www.cdc.gov/other/agencymaterials.html)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-06-15"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.114222.4.5.274",
      "preferred" : true
    }
  ]
}

```
