# AHA NUBC Priority (Type) of Admission or Visit - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AHA NUBC Priority (Type) of Admission or Visit**

## NamingSystem: AHA NUBC Priority (Type) of Admission or Visit 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/AHANUBCPriorityTypeOfAdmitOrVisit | *Version*:1.0.0 | |
| Active as of 2022-05-18 | *Responsible:*American Hospital Association (AHA) | *Computable Name*:AHA_NUBC_PriorityTypeOfAdmitOrVisit |
| **Copyright/Legal**: Licensing information can be found[here](https://www.nubc.org/license)These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA's licensing manager at 312-422-3366 or[ub04@aha.org](mailto:ub04@aha.org). | | |

 
"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." 
This code system consists of the following: 
* FL 14 - Priority (Type) of Admission or Visit 
These codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association. 
To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information) 
Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. 
"The UB-04 Manual has a 12-month subscription period from June 30 through July 1." 
For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/AHANUBCPriorityTypeOfAdmitOrVisit |
| Version | 1.0.0 |
| Name | AHA_NUBC_PriorityTypeOfAdmitOrVisit |
| Title | AHA NUBC Priority (Type) of Admission or Visit |
| Status | active |
| Definition | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified."This code system consists of the following:* FL 14 - Priority (Type) of Admission or VisitThese codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association.To obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2."The UB-04 Manual has a 12-month subscription period from June 30 through July 1."For frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs) |
| Publisher | American Hospital Association (AHA) |
| Copyright | Licensing information can be found [here](https://www.nubc.org/license)These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA's licensing manager at 312-422-3366 or [ub04@aha.org](mailto:ub04@aha.org). |

### Identifiers

* **Type**: URI
  * **Value**: https://www.nubc.org/CodeSystem/PriorityTypeOfAdmitOrVisit
  * **Preferred**: true
  * **Period**: 2020-10-20 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "AHANUBCPriorityTypeOfAdmitOrVisit",
  "url" : "http://terminology.hl7.org/NamingSystem/AHANUBCPriorityTypeOfAdmitOrVisit",
  "version" : "1.0.0",
  "name" : "AHA_NUBC_PriorityTypeOfAdmitOrVisit",
  "title" : "AHA NUBC Priority (Type) of Admission or Visit",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-05-18T00:00:00-00:00",
  "publisher" : "American Hospital Association (AHA)",
  "contact" : [
    {
      "name" : "American Hospital Association (AHA); 155 North Wacker Drive, Suite 400, Chicago, IL 60606",
      "telecom" : [
        {
          "system" : "fax",
          "value" : "312-422-4500"
        },
        {
          "system" : "phone",
          "value" : "312-422-3366"
        }
      ]
    }
  ],
  "responsible" : "American Hospital Association (AHA)",
  "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 14 - Priority (Type) of Admission or Visit\r\n\r\nThese codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)",
  "copyright" : "Licensing information can be found [here](https://www.nubc.org/license)\r\n\r\nThese codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA's licensing manager at 312-422-3366 or [ub04@aha.org](mailto:ub04@aha.org).",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.nubc.org/CodeSystem/PriorityTypeOfAdmitOrVisit",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2020-10-20"
      }
    }
  ]
}

```
