# Validation-status - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Validation-status**

## CodeSystem: Validation-status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/validation-status | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Validation_status |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.895 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Status of the validation of the target against the primary source 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Validation_status](ValueSet-verificationresult-validation-status.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "validation-status",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/validation-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.895"
    }
  ],
  "version" : "1.0.1",
  "name" : "Validation_status",
  "title" : "Validation-status",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Status of the validation of the target against the primary source",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/verificationresult-validation-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "successful",
      "display" : "Successful"
    },
    {
      "code" : "failed",
      "display" : "Failed"
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "The validations status has not been determined yet"
    }
  ]
}

```
