# HL7ApprovalStatus - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7ApprovalStatus**

## CodeSystem: HL7ApprovalStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-hl7ApprovalStatus | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Hl7ApprovalStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1130 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**Codes for concepts describing the approval level of HL7 artifacts. This code system reflects the concepts expressed in HL7's Governance & Operations Manual (GOM) past and present. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-hl7ApprovalStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-hl7ApprovalStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1130"
    }
  ],
  "version" : "3.0.0",
  "name" : "Hl7ApprovalStatus",
  "title" : "HL7ApprovalStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** Codes for concepts describing the approval level of HL7 artifacts. This code system reflects the concepts expressed in HL7's Governance & Operations Manual (GOM) past and present.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "affd",
      "display" : "affiliate ballot - DSTU",
      "definition" : "**Description:** Content that is being presented to an international affiliate for consideration as a realm-specific draft standard for trial use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23125"
        }
      ]
    },
    {
      "code" : "affi",
      "display" : "affiliate ballot - informative",
      "definition" : "**Description:** Content that is being presented to an international affiliate for consideration as a realm-specific informative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23126"
        }
      ]
    },
    {
      "code" : "affn",
      "display" : "affiliate ballot - normative",
      "definition" : "**Description:** Content that is being presented to an international affiliate for consideration as a realm-specific normative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23124"
        }
      ]
    },
    {
      "code" : "appad",
      "display" : "approved affiliate DSTU",
      "definition" : "**Description:** Content that has passed ballot as a realm-specific draft standard for trial use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23129"
        }
      ]
    },
    {
      "code" : "appai",
      "display" : "approved affiliate informative",
      "definition" : "**Description:** Content that has passed ballot as a realm-specific informative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23128"
        }
      ]
    },
    {
      "code" : "appan",
      "display" : "approved affiliate normative",
      "definition" : "**Description:** Content that has passed ballot as a realm-specific normative standard",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23127"
        }
      ]
    },
    {
      "code" : "appd",
      "display" : "approved DSTU",
      "definition" : "**Description:** Content that has passed ballot as a draft standard for trial use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23123"
        }
      ]
    },
    {
      "code" : "appi",
      "display" : "approved informative",
      "definition" : "**Description:** Content that has passed ballot as a normative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23122"
        }
      ]
    },
    {
      "code" : "appn",
      "display" : "approved normative",
      "definition" : "**Description:** Content that has passed ballot as a normative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23121"
        }
      ]
    },
    {
      "code" : "comi",
      "display" : "committee ballot - informative",
      "definition" : "**Description:** Content prepared by a committee and submitted for internal consideration as an informative standard.\r\n\r\n***Deprecation Comment*** No longer supported as ballot statuses within the HL7 Governance and Operations Manual. Use normative or informative variants instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2010-11-23"
        },
        {
          "code" : "internalId",
          "valueCode" : "23117"
        }
      ]
    },
    {
      "code" : "comn",
      "display" : "committee ballot - normative",
      "definition" : "**Description:** Content prepared by a committee and submitted for internal consideration as an informative standard.\r\n\r\n***Deprecation Comment*** No longer supported as ballot statuses within the HL7 Governance and Operations Manual. Use normative or informative variants instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2010-11-23"
        },
        {
          "code" : "internalId",
          "valueCode" : "23116"
        }
      ]
    },
    {
      "code" : "draft",
      "display" : "draft",
      "definition" : "**Description:** Content that is under development and is not intended to be used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23113"
        }
      ]
    },
    {
      "code" : "loc",
      "display" : "localized adaptation",
      "definition" : "**Description:** Content that represents an adaption of a implementable balloted material to represent the needs or capabilities of a particular installation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23130"
        }
      ]
    },
    {
      "code" : "memd",
      "display" : "membership ballot - DSTU",
      "definition" : "**Description:** Content prepared by a committee and submitted for membership consideration as a draft standard for trial use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23120"
        }
      ]
    },
    {
      "code" : "memi",
      "display" : "membership ballot - informative",
      "definition" : "**Description:** Content prepared by a committee and submitted for membership consideration as an informative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23119"
        }
      ]
    },
    {
      "code" : "memn",
      "display" : "membership ballot - normative",
      "definition" : "**Description:** Content prepared by a committee and submitted for membership consideration as a normative standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23118"
        }
      ]
    },
    {
      "code" : "ns",
      "display" : "non-standard - available for use",
      "definition" : "**Description:** Content developed independently by an organization or individual that is declared to be 'usable' but for which there is no present intention to submit through the standards submission and review process.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23114"
        }
      ]
    },
    {
      "code" : "prop",
      "display" : "proposal",
      "definition" : "**Description:** Content submitted to a committee for consideration for future inclusion in the standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23115"
        }
      ]
    },
    {
      "code" : "ref",
      "display" : "reference",
      "definition" : "**Description:** Content intended to support other content that is subject to approval, but which is not itself subject to formal approval.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23251"
        }
      ]
    },
    {
      "code" : "wd",
      "display" : "withdrawn",
      "definition" : "**Description:** Content that represents an item that was at one point a normative or informative standard, but was subsequently withdrawn.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23131"
        }
      ]
    }
  ]
}

```
