# RoleLinkType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleLinkType**

## CodeSystem: RoleLinkType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-RoleLinkType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleLinkType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.107 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies specific constraints to what kinds of Role objects can be related and in which way. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RoleLinkHasContact](ValueSet-v3-RoleLinkHasContact.md)
* [RoleLinkHasDirectAuthorityOver](ValueSet-v3-RoleLinkHasDirectAuthorityOver.md)
* [RoleLinkHasIndirectAuthorityOver](ValueSet-v3-RoleLinkHasIndirectAuthorityOver.md)
* [RoleLinkHasPart](ValueSet-v3-RoleLinkHasPart.md)
* [RoleLinkIdentification](ValueSet-v3-RoleLinkIdentification.md)
* [RoleLinkIsBackupFor](ValueSet-v3-RoleLinkIsBackupFor.md)
* [RoleLinkRelated](ValueSet-v3-RoleLinkRelated.md)
* [RoleLinkReplaces](ValueSet-v3-RoleLinkReplaces.md)
* [RoleLinkType](ValueSet-v3-RoleLinkType.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-RoleLinkType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-RoleLinkType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.107"
    }
  ],
  "version" : "3.0.0",
  "name" : "RoleLinkType",
  "title" : "RoleLinkType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies specific constraints to what kinds of Role objects can be related and in which way.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "Name:Role:inboundLink:RoleLink",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-inbound",
      "description" : "Name of inboundLink relationship from Role to RoleLink",
      "type" : "code"
    },
    {
      "code" : "Name:Role:outboundLink:RoleLink",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-outbound",
      "description" : "Name of outboundLink relationship from Role to RoleLink",
      "type" : "code"
    },
    {
      "code" : "Sort:Role:inboundLink:RoleLink",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-inbound-sort",
      "description" : "Sort key for inboundLink relationship from Role to RoleLink",
      "type" : "code"
    },
    {
      "code" : "Sort:Role:outboundLink:RoleLink",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-outbound-sort",
      "description" : "Sort key for outboundLink relationship from Role to RoleLink",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "REL",
      "display" : "related",
      "definition" : "An action taken with respect to a subject Entity by a regulatory or authoritative body with supervisory capacity over that entity. The action is taken in response to behavior by the subject Entity that body finds to be undesirable.\r\n\r\nSuspension, license restrictions, monetary fine, letter of reprimand, mandated training, mandated supervision, etc.*Examples:*",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21429"
        },
        {
          "code" : "Name:Role:inboundLink:RoleLink",
          "valueCode" : "related"
        },
        {
          "code" : "Name:Role:outboundLink:RoleLink",
          "valueCode" : "relatedTo"
        },
        {
          "code" : "Sort:Role:inboundLink:RoleLink",
          "valueCode" : "A________"
        },
        {
          "code" : "Sort:Role:outboundLink:RoleLink",
          "valueCode" : "A________"
        }
      ],
      "concept" : [
        {
          "code" : "BACKUP",
          "display" : "is backup for",
          "definition" : "This relationship indicates the source Role is available to the target Role as a backup. An entity in a backup role will be available as a substitute or replacement in the event that the entity assigned the role is unavailable. In medical roles where it is critical that the function be performed and there is a possibility that the individual assigned may be ill or otherwise indisposed, another individual is assigned to cover for the individual originally assigned the role. A backup may be required to be identified, but unless the backup is actually used, he/she would not assume the assigned entity role.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21302"
            },
            {
              "code" : "Name:Role:inboundLink:RoleLink",
              "valueCode" : "backup"
            },
            {
              "code" : "Name:Role:outboundLink:RoleLink",
              "valueCode" : "backupFor"
            },
            {
              "code" : "Sort:Role:inboundLink:RoleLink",
              "valueCode" : "AE_______"
            },
            {
              "code" : "Sort:Role:outboundLink:RoleLink",
              "valueCode" : "AE_______"
            }
          ]
        },
        {
          "code" : "CONT",
          "display" : "has contact",
          "definition" : "This relationship indicates the target Role provides or receives information regarding the target role. For example, AssignedEntity is a contact for a ServiceDeliveryLocation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23100"
            },
            {
              "code" : "Name:Role:inboundLink:RoleLink",
              "valueCode" : "contactFor"
            },
            {
              "code" : "Name:Role:outboundLink:RoleLink",
              "valueCode" : "contact"
            },
            {
              "code" : "Sort:Role:inboundLink:RoleLink",
              "valueCode" : "AF_______"
            },
            {
              "code" : "Sort:Role:outboundLink:RoleLink",
              "valueCode" : "AF_______"
            }
          ]
        },
        {
          "code" : "DIRAUTH",
          "display" : "has direct authority over",
          "definition" : "The source Role has direct authority over the target role in a chain of authority.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11605"
            },
            {
              "code" : "Name:Role:inboundLink:RoleLink",
              "valueCode" : "directAuthority"
            },
            {
              "code" : "Name:Role:outboundLink:RoleLink",
              "valueCode" : "directAuthorityOver"
            },
            {
              "code" : "Sort:Role:inboundLink:RoleLink",
              "valueCode" : "AA_______"
            },
            {
              "code" : "Sort:Role:outboundLink:RoleLink",
              "valueCode" : "AA_______"
            }
          ]
        },
        {
          "code" : "IDENT",
          "display" : "Identification",
          "definition" : "**Description:** The source role provides identification for the target role. The source role must be IDENT. The player entity of the source role is constrained to be the same as (i.e. the equivalent of, or equal to) the player of the target role if present. If the player is absent from the source role, then it is assumed to be the same as the player of the target role.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22184"
            }
          ]
        },
        {
          "code" : "INDAUTH",
          "display" : "has indirect authority over",
          "definition" : "The source Role has indirect authority over the target role in a chain of authority.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11606"
            },
            {
              "code" : "Name:Role:inboundLink:RoleLink",
              "valueCode" : "indirectAuthority"
            },
            {
              "code" : "Name:Role:outboundLink:RoleLink",
              "valueCode" : "indirectAuthorithyOver"
            },
            {
              "code" : "Sort:Role:inboundLink:RoleLink",
              "valueCode" : "AB_______"
            },
            {
              "code" : "Sort:Role:outboundLink:RoleLink",
              "valueCode" : "AB_______"
            }
          ]
        },
        {
          "code" : "PART",
          "display" : "has part",
          "definition" : "The target Role is part of the Source Role.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11604"
            },
            {
              "code" : "Name:Role:inboundLink:RoleLink",
              "valueCode" : "partOf"
            },
            {
              "code" : "Name:Role:outboundLink:RoleLink",
              "valueCode" : "part"
            },
            {
              "code" : "Sort:Role:inboundLink:RoleLink",
              "valueCode" : "AC_______"
            },
            {
              "code" : "Sort:Role:outboundLink:RoleLink",
              "valueCode" : "AC_______"
            }
          ]
        },
        {
          "code" : "REPL",
          "display" : "replaces",
          "definition" : "This relationship indicates that the source Role replaces (or subsumes) the target Role. Allows for new identifiers and/or new effective time for a registry entry or a certification, etc.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15952"
            },
            {
              "code" : "Name:Role:inboundLink:RoleLink",
              "valueCode" : "replacedBy"
            },
            {
              "code" : "Name:Role:outboundLink:RoleLink",
              "valueCode" : "replacementOf"
            },
            {
              "code" : "Sort:Role:inboundLink:RoleLink",
              "valueCode" : "AD_______"
            },
            {
              "code" : "Sort:Role:outboundLink:RoleLink",
              "valueCode" : "AD_______"
            }
          ]
        }
      ]
    }
  ]
}

```
