# RoleClass - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleClass**

## CodeSystem: RoleClass 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-RoleClass | *Version*:4.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleClass |
| *Other Identifiers:*OID:2.16.840.1.113883.5.110 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role. 
The role hierarchy stems from three core concepts, or abstract domains: 
* **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity.
* **RoleClassPartitive** collects roles in which the playing entity is in some sense a "part" of the scoping entity.
* **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between:
 
The hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the "Personal relationship" which is a leaf concept. 
**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RoleClass](ValueSet-v3-RoleClass.md)
* [RoleClassAccess](ValueSet-v3-RoleClassAccess.md)
* [RoleClassActiveIngredient](ValueSet-v3-RoleClassActiveIngredient.md)
* [RoleClassActiveIngredientBasis](ValueSet-v3-RoleClassActiveIngredientBasis.md)
* [RoleClassActiveIngredientMoietyBasis](ValueSet-v3-RoleClassActiveIngredientMoietyBasis.md)
* [RoleClassActiveIngredientReferenceBasis](ValueSet-v3-RoleClassActiveIngredientReferenceBasis.md)
* [RoleClassActiveMoiety](ValueSet-v3-RoleClassActiveMoiety.md)
* [RoleClassAdditive](ValueSet-v3-RoleClassAdditive.md)
* [RoleClassAdjacency](ValueSet-v3-RoleClassAdjacency.md)
* [RoleClassAdjuvant](ValueSet-v3-RoleClassAdjuvant.md)
* [RoleClassAdministerableMaterial](ValueSet-v3-RoleClassAdministerableMaterial.md)
* [RoleClassAffiliate](ValueSet-v3-RoleClassAffiliate.md)
* [RoleClassAgent](ValueSet-v3-RoleClassAgent.md)
* [RoleClassAliquot](ValueSet-v3-RoleClassAliquot.md)
* [RoleClassAssignedEntity](ValueSet-v3-RoleClassAssignedEntity.md)
* [RoleClassAssociative](ValueSet-v3-RoleClassAssociative.md)
* [RoleClassBase](ValueSet-v3-RoleClassBase.md)
* [RoleClassBirthplace](ValueSet-v3-RoleClassBirthplace.md)
* [RoleClassCaregiver](ValueSet-v3-RoleClassCaregiver.md)
* [RoleClassCaseSubject](ValueSet-v3-RoleClassCaseSubject.md)
* [RoleClassChild](ValueSet-v3-RoleClassChild.md)
* [RoleClassCitizen](ValueSet-v3-RoleClassCitizen.md)
* [RoleClassClaimant](ValueSet-v3-RoleClassClaimant.md)
* [RoleClassClinicalResearchInvestigator](ValueSet-v3-RoleClassClinicalResearchInvestigator.md)
* [RoleClassClinicalResearchSponsor](ValueSet-v3-RoleClassClinicalResearchSponsor.md)
* [RoleClassColorAdditive](ValueSet-v3-RoleClassColorAdditive.md)
* [RoleClassCommissioningParty](ValueSet-v3-RoleClassCommissioningParty.md)
* [RoleClassConnection](ValueSet-v3-RoleClassConnection.md)
* [RoleClassContact](ValueSet-v3-RoleClassContact.md)
* [RoleClassContactCode](ValueSet-v3-RoleClassContactCode.md)
* [RoleClassContaminantIngredient](ValueSet-v3-RoleClassContaminantIngredient.md)
* [RoleClassContent](ValueSet-v3-RoleClassContent.md)
* [RoleClassContinuity](ValueSet-v3-RoleClassContinuity.md)
* [RoleClassCoverageSponsor](ValueSet-v3-RoleClassCoverageSponsor.md)
* [RoleClassCoveredParty](ValueSet-v3-RoleClassCoveredParty.md)
* [RoleClassCredentialedEntity](ValueSet-v3-RoleClassCredentialedEntity.md)
* [RoleClassDedicatedServiceDeliveryLocation](ValueSet-v3-RoleClassDedicatedServiceDeliveryLocation.md)
* [RoleClassDependent](ValueSet-v3-RoleClassDependent.md)
* [RoleClassDistributedMaterial](ValueSet-v3-RoleClassDistributedMaterial.md)
* [RoleClassEmergencyContact](ValueSet-v3-RoleClassEmergencyContact.md)
* [RoleClassEmployee](ValueSet-v3-RoleClassEmployee.md)
* [RoleClassEquivalentEntity](ValueSet-v3-RoleClassEquivalentEntity.md)
* [RoleClassEventLocation](ValueSet-v3-RoleClassEventLocation.md)
* [RoleClassExposedEntity](ValueSet-v3-RoleClassExposedEntity.md)
* [RoleClassExposureAgentCarrier](ValueSet-v3-RoleClassExposureAgentCarrier.md)
* [RoleClassExposureVector](ValueSet-v3-RoleClassExposureVector.md)
* [RoleClassFlavorAdditive](ValueSet-v3-RoleClassFlavorAdditive.md)
* [RoleClassFomite](ValueSet-v3-RoleClassFomite.md)
* [RoleClassGuarantor](ValueSet-v3-RoleClassGuarantor.md)
* [RoleClassGuardian](ValueSet-v3-RoleClassGuardian.md)
* [RoleClassHasGeneric](ValueSet-v3-RoleClassHasGeneric.md)
* [RoleClassHealthChart](ValueSet-v3-RoleClassHealthChart.md)
* [RoleClassHealthcareProvider](ValueSet-v3-RoleClassHealthcareProvider.md)
* [RoleClassHeldEntity](ValueSet-v3-RoleClassHeldEntity.md)
* [RoleClassICSRInvestigationSubject](ValueSet-v3-RoleClassICSRInvestigationSubject.md)
* [RoleClassIdentifiedEntity](ValueSet-v3-RoleClassIdentifiedEntity.md)
* [RoleClassInactiveIngredient](ValueSet-v3-RoleClassInactiveIngredient.md)
* [RoleClassIncidentalServiceDeliveryLocation](ValueSet-v3-RoleClassIncidentalServiceDeliveryLocation.md)
* [RoleClassIndividual](ValueSet-v3-RoleClassIndividual.md)
* [RoleClassIngredientEntity](ValueSet-v3-RoleClassIngredientEntity.md)
* [RoleClassInstance](ValueSet-v3-RoleClassInstance.md)
* [RoleClassInvestigationSubject](ValueSet-v3-RoleClassInvestigationSubject.md)
* [RoleClassInvoicePayor](ValueSet-v3-RoleClassInvoicePayor.md)
* [RoleClassIsSpeciesEntity](ValueSet-v3-RoleClassIsSpeciesEntity.md)
* [RoleClassIsolate](ValueSet-v3-RoleClassIsolate.md)
* [RoleClassLicensedEntity](ValueSet-v3-RoleClassLicensedEntity.md)
* [RoleClassLocatedEntity](ValueSet-v3-RoleClassLocatedEntity.md)
* [RoleClassMaintainedEntity](ValueSet-v3-RoleClassMaintainedEntity.md)
* [RoleClassManagedEntity](ValueSet-v3-RoleClassManagedEntity.md)
* [RoleClassManufacturedProduct](ValueSet-v3-RoleClassManufacturedProduct.md)
* [RoleClassMechanicalIngredient](ValueSet-v3-RoleClassMechanicalIngredient.md)
* [RoleClassMember](ValueSet-v3-RoleClassMember.md)
* [RoleClassMilitaryPerson](ValueSet-v3-RoleClassMilitaryPerson.md)
* [RoleClassMolecularBond](ValueSet-v3-RoleClassMolecularBond.md)
* [RoleClassMolecularFeatures](ValueSet-v3-RoleClassMolecularFeatures.md)
* [RoleClassMolecularPart](ValueSet-v3-RoleClassMolecularPart.md)
* [RoleClassMutualRelationship](ValueSet-v3-RoleClassMutualRelationship.md)
* [RoleClassNamedInsured](ValueSet-v3-RoleClassNamedInsured.md)
* [RoleClassNextOfKin](ValueSet-v3-RoleClassNextOfKin.md)
* [RoleClassNotaryPublic](ValueSet-v3-RoleClassNotaryPublic.md)
* [RoleClassNurse](ValueSet-v3-RoleClassNurse.md)
* [RoleClassNursePractitioner](ValueSet-v3-RoleClassNursePractitioner.md)
* [RoleClassOntological](ValueSet-v3-RoleClassOntological.md)
* [RoleClassOwnedEntity](ValueSet-v3-RoleClassOwnedEntity.md)
* [RoleClassPart](ValueSet-v3-RoleClassPart.md)
* [RoleClassPartitive](ValueSet-v3-RoleClassPartitive.md)
* [RoleClassPassive](ValueSet-v3-RoleClassPassive.md)
* [RoleClassPatient](ValueSet-v3-RoleClassPatient.md)
* [RoleClassPayee](ValueSet-v3-RoleClassPayee.md)
* [RoleClassPersonalRelationship](ValueSet-v3-RoleClassPersonalRelationship.md)
* [RoleClassPhysician](ValueSet-v3-RoleClassPhysician.md)
* [RoleClassPhysicianAssistant](ValueSet-v3-RoleClassPhysicianAssistant.md)
* [RoleClassPlaceOfDeath](ValueSet-v3-RoleClassPlaceOfDeath.md)
* [RoleClassPolicyHolder](ValueSet-v3-RoleClassPolicyHolder.md)
* [RoleClassPreservative](ValueSet-v3-RoleClassPreservative.md)
* [RoleClassProductRelated](ValueSet-v3-RoleClassProductRelated.md)
* [RoleClassProgramEligible](ValueSet-v3-RoleClassProgramEligible.md)
* [RoleClassQualifiedEntity](ValueSet-v3-RoleClassQualifiedEntity.md)
* [RoleClassRegulatedProduct](ValueSet-v3-RoleClassRegulatedProduct.md)
* [RoleClassRelationshipFormal](ValueSet-v3-RoleClassRelationshipFormal.md)
* [RoleClassResearchSubject](ValueSet-v3-RoleClassResearchSubject.md)
* [RoleClassRetailedMaterial](ValueSet-v3-RoleClassRetailedMaterial.md)
* [RoleClassRoot](ValueSet-v3-RoleClassRoot.md)
* [RoleClassSame](ValueSet-v3-RoleClassSame.md)
* [RoleClassServiceDeliveryLocation](ValueSet-v3-RoleClassServiceDeliveryLocation.md)
* [RoleClassSigningAuthorityOrOfficer](ValueSet-v3-RoleClassSigningAuthorityOrOfficer.md)
* [RoleClassSpecimen](ValueSet-v3-RoleClassSpecimen.md)
* [RoleClassStabilizer](ValueSet-v3-RoleClassStabilizer.md)
* [RoleClassStoredEntity](ValueSet-v3-RoleClassStoredEntity.md)
* [RoleClassStudent](ValueSet-v3-RoleClassStudent.md)
* [RoleClassSubscriber](ValueSet-v3-RoleClassSubscriber.md)
* [RoleClassSubstancePresence](ValueSet-v3-RoleClassSubstancePresence.md)
* [RoleClassSubsumedBy](ValueSet-v3-RoleClassSubsumedBy.md)
* [RoleClassSubsumer](ValueSet-v3-RoleClassSubsumer.md)
* [RoleClassTerritoryOfAuthority](ValueSet-v3-RoleClassTerritoryOfAuthority.md)
* [RoleClassTherapeuticAgent](ValueSet-v3-RoleClassTherapeuticAgent.md)
* [RoleClassUnderwriter](ValueSet-v3-RoleClassUnderwriter.md)
* [RoleClassUsedEntity](ValueSet-v3-RoleClassUsedEntity.md)
* [RoleClassWarrantedProduct](ValueSet-v3-RoleClassWarrantedProduct.md)
* [XAccommodationRequestorRole](ValueSet-v3-xAccommodationRequestorRole.md)
* [XDocumentEntrySubject](ValueSet-v3-xDocumentEntrySubject.md)
* [XDocumentSubject](ValueSet-v3-xDocumentSubject.md)
* [XInformationRecipientRole](ValueSet-v3-xInformationRecipientRole.md)
* [XRoleClassAccommodationRequestor](ValueSet-v3-xRoleClassAccommodationRequestor.md)
* [XRoleClassCoverage](ValueSet-v3-xRoleClassCoverage.md)
* [XRoleClassCoverageInvoice](ValueSet-v3-xRoleClassCoverageInvoice.md)
* [XRoleClassCredentialedEntity](ValueSet-v3-xRoleClassCredentialedEntity.md)
* [XRoleClassPayeePolicyRelationship](ValueSet-v3-xRoleClassPayeePolicyRelationship.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-RoleClass",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.110"
    }
  ],
  "version" : "4.0.0",
  "name" : "RoleClass",
  "title" : "RoleClass",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role.\r\n\r\nThe role hierarchy stems from three core concepts, or abstract domains:\r\n\r\n *  **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity.\r\n *  **RoleClassPartitive** collects roles in which the playing entity is in some sense a \"part\" of the scoping entity.\r\n *  **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between:\r\n    \r\n     *  **RoleClassPassive** which are roles in which the playing entity is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping entity. The playing entity is passive in these roles in that the role exists without an agreement from the playing entity.\r\n     *  **RoleClassMutualRelationship** which are relationships based on mutual behavior of the two entities. The basis of these relationship may be formal agreements or they may be *de facto* behavior. Thus, this sub-domain is further divided into:\r\n        \r\n         *  **RoleClassRelationshipFormal** in which the relationship is formally defined, frequently by a contract or agreement.\r\n         *  **Personal relationship** which inks two people in a personal relationship.\r\n\r\nThe hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the \"Personal relationship\" which is a leaf concept.\r\n\r\n*OpenIssue:* Description copied from Concept Domain of same name. Must be verified.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "Name:Class",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Class",
      "description" : "The formal name for the class clone under this code",
      "type" : "code"
    },
    {
      "code" : "Name:Role:player:Entity",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-player",
      "description" : "The name of the relationship from Role to the payer Entity",
      "type" : "code"
    },
    {
      "code" : "Name:Role:scoper:Entity",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-scoper",
      "description" : "The name of the relationship from Role to the scoper Entity",
      "type" : "code"
    },
    {
      "code" : "Sort:Entity:playedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-played-sort",
      "description" : "Sort key for the relationship from the Entity to the playedRole",
      "type" : "code"
    },
    {
      "code" : "Sort:Entity:scopedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-scoped-sort",
      "description" : "The sort key for the relationship from the Entity to the scopedRole",
      "type" : "code"
    },
    {
      "code" : "Name:Entity:playedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-played",
      "description" : "The name of the relationship from the Entity to the playedRole",
      "type" : "string"
    },
    {
      "code" : "Name:Entity:scopedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-scoped",
      "description" : "The name of the relationship from the Entity to the scopedRole",
      "type" : "string"
    },
    {
      "code" : "Name:Participation:role:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Participation-role",
      "description" : "The name of the relationship from Participation to Role",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "ROL",
      "display" : "role",
      "definition" : "Corresponds to the Role class",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13940"
        },
        {
          "code" : "Name:Class",
          "valueCode" : "role"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Role:player:Entity",
          "valueCode" : "(playing&)|player"
        },
        {
          "code" : "Name:Role:scoper:Entity",
          "valueCode" : "(scoping&)|scoper"
        },
        {
          "code" : "Sort:Entity:playedRole:Role",
          "valueCode" : "A________"
        },
        {
          "code" : "Sort:Entity:scopedRole:Role",
          "valueCode" : "A________"
        }
      ],
      "concept" : [
        {
          "code" : "_RoleClassAssociative",
          "display" : "RoleClassAssociative",
          "definition" : "A general association between two entities that is neither partitive nor ontological.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21113"
            },
            {
              "code" : "Name:Class",
              "valueCode" : "associatedEntity"
            },
            {
              "code" : "Name:Role:player:Entity",
              "valueCode" : "associated&"
            },
            {
              "code" : "Name:Role:scoper:Entity",
              "valueCode" : "scoping&"
            },
            {
              "code" : "Sort:Entity:playedRole:Role",
              "valueCode" : "AA_______"
            },
            {
              "code" : "Sort:Entity:scopedRole:Role",
              "valueCode" : "AA_______"
            },
            {
              "code" : "Name:Entity:playedRole:Role",
              "valueString" : "as&"
            },
            {
              "code" : "Name:Entity:scopedRole:Role",
              "valueString" : "&"
            },
            {
              "code" : "Name:Participation:role:Role",
              "valueString" : "&"
            }
          ],
          "concept" : [
            {
              "code" : "_RoleClassMutualRelationship",
              "display" : "RoleClassMutualRelationship",
              "definition" : "A relationship that is based on mutual behavior of the two Entities as being related. The basis of such relationship may be agreements (e.g., spouses, contract parties) or they may be *de facto* behavior (e.g. friends) or may be an incidental involvement with each other (e.g. parties over a dispute, siblings, children).",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21114"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "relatedEntity"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "related&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "scoping&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "AAA______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "AAA______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "_RoleClassRelationshipFormal",
                  "display" : "RoleClassRelationshipFormal",
                  "definition" : "A relationship between two entities that is formally recognized, frequently by a contract or similar agreement.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21118"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "formalRelation"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "related&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "related&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AAAA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AAAA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "AFFL",
                      "display" : "affiliate",
                      "definition" : "Player of the Affiliate role has a business/professional relationship with scoper. Player and scoper may be persons or organization. The Affiliate relationship does not imply membership in a group, nor does it exist for resource scheduling purposes.\r\n\r\n*Example:* A healthcare provider is affiliated with another provider as a business associate.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21438"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "affiliate"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "affiliate&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "affiliated&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAR____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAR____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "AGNT",
                      "display" : "agent",
                      "definition" : "An entity (player) that acts or is authorized to act on behalf of another entity (scoper).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14006"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "agent"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "agent&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "(represented&)|representee"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAD____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAD____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ASSIGNED",
                          "display" : "assigned entity",
                          "definition" : "An agent role in which the agent is an Entity acting in the employ of an organization. The focus is on functional role on behalf of the organization, unlike the Employee role where the focus is on the 'Human Resources' relationship between the employee and the organization.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11595"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "assignedEntity"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "(assigned&)|assignee"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "(represented&)|representee"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAADA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAADA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "COMPAR",
                              "display" : "commissioning party",
                              "definition" : "An Entity that is authorized to issue or instantiate permissions, privileges, credentials or other formal/legal authorizations.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21303"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "commissioningParty"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueCode" : "commissioning&"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueCode" : "commissioningScoper"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueCode" : "AAAADAC__"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueCode" : "AAAADAC__"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "SGNOFF",
                              "display" : "signing authority or officer",
                              "definition" : "The role of a person (player) who is the officer or signature authority for of a scoping entity, usually an organization (scoper).",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "14007"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "signatureAuthority"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueCode" : "signing(&|Authority)"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueCode" : "(represented&)|representee"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueCode" : "AAAADAB__"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueCode" : "AAAADAB__"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "CON",
                          "display" : "contact",
                          "definition" : "A person or an organization (player) which provides or receives information regarding another entity (scoper). Examples; patient NOK and emergency contacts; guarantor contact; employer contact.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "12205"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "contactParty"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "contact(&|Party)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "(represented&)|representee"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAADAA__"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAADAA__"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "ECON",
                              "display" : "emergency contact",
                              "definition" : "An entity to be contacted in the event of an emergency.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "19140"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "emergencyContact"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueCode" : "emergencyContact(&|Party)"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueCode" : "(represented&)|representee"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueCode" : "AAAADAAB_"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueCode" : "AAAADAAB_"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "NOK",
                              "display" : "next of kin",
                              "definition" : "An individual designated for notification as the next of kin for a given entity.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "19141"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "nextOfKin"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueCode" : "nextOfKinContact&"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueCode" : "(represented&)|representee"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueCode" : "AAAADAAA_"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueCode" : "AAAADAAA_"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "GUARD",
                          "display" : "guardian",
                          "definition" : "Guardian of a ward",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "16324"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "guardian"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "guardian&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "ward&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAADB___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAADB___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "CIT",
                      "display" : "citizen",
                      "definition" : "Citizen of apolitical entity",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11568"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "citizen"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "citizen&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "political(&|Entity)"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAF____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAF____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "COVPTY",
                      "display" : "covered party",
                      "definition" : "A role class played by a person who receives benefit coverage under the terms of a particular insurance policy. The underwriter of that policy is the scoping entity. The covered party receives coverage because of some contractual or other relationship with the holder of that policy.\r\n\r\n*Discussion:*This reason for coverage is captured in 'Role.code' and a relationship link with type code of indirect authority should be included using the policy holder role as the source, and the covered party role as the target.\r\n\r\nNote that a particular policy may cover several individuals one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14011"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "coveredParty"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "covered(&|Party)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAI____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAI____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "CLAIM",
                          "display" : "claimant",
                          "definition" : "**Description:** A role played by a party making a claim for coverage under a policy or program. A claimant must be either a person or organization, or a group of persons or organizations. A claimant is not a named insured or a program eligible.\r\n\r\n**Discussion:** With respect to liability insurance such as property and casualty insurance, a claimant must file a claim requesting indemnification for a loss that the claimant considers covered under the policy of a named insured. The claims adjuster for the policy underwriter will review the claim to determine whether the loss meets the benefit coverage criteria under a policy, and base any indemnification or coverage payment on that review. If a third party is liable in whole or part for the loss, the underwriter may pursue third party liability recovery. A claimant may be involved in civil or criminal legal proceedings involving claims against a defendant party that is indemnified by an insurance policy or to protest the finding of a claims adjustor. With respect to life insurance, a beneficiary designated by a named insured becomes a claimant of the proceeds of coverage, as in the case of a life insurance policy. However, a claimant for coverage under life insurance is not necessarily a designated beneficiary.\r\n\r\n**Note:** A claimant is not a named insured. However, a named insured may make a claim under a policy, e.g., an insured driver may make a claim for an injury under his or her comprehensive automobile insurance policy. Similarly, a program eligible may make a claim under program, e.g., an unemployed worker may claim benefits under an unemployment insurance program, but parties playing these covered party role classes are not, for purposes of this vocabulary and in an effort to clearly distinguish role classes, considered claimants.\r\n\r\nIn the case of a named insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that either a named insured or an individual insured has filed a claim for a loss. In the case of a program eligible, a role type code INJWKR (injured worker) subtypes the class to indicate that the covered party in a workers compensation program is an injured worker, and as such, has filed a \"claim\" under the program for benefits. Likewise, a covered role type code UNEMP (unemployed worker) subtypes the program eligible class to indicate that the covered party in an unemployment insurance program has filed a claim for unemployment benefits.\r\n\r\n**Example:** A claimant under automobile policy that is not the named insured.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21955"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "claimant"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "NAMED",
                          "display" : "named insured",
                          "definition" : "**Description:** A role played by a party to an insurance policy to which the insurer agrees to indemnify for losses, provides benefits for, or renders services. A named insured may be either a person, non-person living subject, or an organization, or a group of persons, non-person living subjects, or organizations.\r\n\r\n**Discussion:** The coded concept NAMED should not be used where a more specific child concept in this Specializable value set applies. In some cases, the named insured may not be the policy holder, e.g., where a policy holder purchases life insurance policy in which another party is the named insured and the policy holder is the beneficiary of the policy.\r\n\r\n**Note:** The party playing the role of a named insured is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a named insured may make a claim under a policy, e.g., e.g., a party that is the named insured and policy holder under a comprehensive automobile insurance policy may become the claimant for coverage under that policy e.g., if injured in an automobile accident and there is no liable third party. In the case of a named insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that a named insured has filed a claim for a loss.\r\n\r\n**Example:** The named insured under a comprehensive automobile, disability, or property and casualty policy that is the named insured and may or may not be the policy holder.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21957"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "namedInsured"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "DEPEN",
                              "display" : "dependent",
                              "definition" : "**Description:** A role played by a person covered under a policy or program based on an association with a subscriber, which is recognized by the policy holder.\r\n\r\n**Note:** The party playing the role of a dependent is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a dependent may make a claim under a policy, e.g., a dependent under a health insurance policy may become the claimant for coverage under that policy for wellness examines or if injured and there is no liable third party. In the case of a dependent making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that the dependent has filed a claim for services covered under the health insurance policy.\r\n\r\n**Example:** The dependent has an association with the subscriber such as a financial dependency or personal relationship such as that of a spouse, or a natural or adopted child. The policy holder may be required by law to recognize certain associations or may have discretion about the associations. For example, a policy holder may dictate the criteria for the dependent status of adult children who are students, such as requiring full time enrollment, or may recognize domestic partners as dependents. Under certain circumstances, the dependent may be under the indirect authority of a responsible party acting as a surrogate for the subscriber, for example, if the subscriber is differently abled or deceased, a guardian ad Lidem or estate executor may be appointed to assume the subscriberaTMs legal standing in the relationship with the dependent.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21960"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "dependent"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "INDIV",
                              "display" : "individual",
                              "definition" : "**Description:** A role played by a party covered under a policy as the policy holder. An individual may be either a person or an organization.\r\n\r\n**Note:** The party playing the role of an individual insured is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a named insured may make a claim under a policy, e.g., a party that is the named insured and policy holder under a comprehensive automobile insurance policy may become the claimant for coverage under that policy if injured in an automobile accident and there is no liable third party. In the case of an individual insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that an individual insured has filed a claim for a loss.\r\n\r\n**Example:** The individual insured under a comprehensive automobile, disability, or property and casualty policy that is the policy holder.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21958"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "individual"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "SUBSCR",
                              "display" : "subscriber",
                              "definition" : "**Description:** A role played by a person covered under a policy based on association with a sponsor who is the policy holder, and whose association may provide for the eligibility of dependents for coverage.\r\n\r\n**Discussion:** The policy holder holds the contract with the policy or program underwriter. The subscriber holds a certificate of coverage under the contract. In legal proceedings concerning the policy or program, the terms of the contract takes precedence over the terms of the certificate of coverage if there are any inconsistencies.\r\n\r\n**Note:** The party playing the role of a subscriber is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a subscriber may make a claim under a policy, e.g., a subscriber under a health insurance policy may become the claimant for coverage under that policy for wellness examines or if injured and there is no liable third party. In the case of a subscriber making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that the subscriber has filed a claim for services covered under the health insurance policy.\r\n\r\n**Example:** An employee or a member of an association.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21959"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueCode" : "subscriber"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "PROG",
                          "display" : "program eligible",
                          "definition" : "**Description:** A role played by a party that meets the eligibility criteria for coverage under a program. A program eligible may be either a person, non-person living subject, or an organization, or a group of persons, non-person living subjects, or organizations.\r\n\r\n**Discussion:** A program as typically government administered coverage for parties determined eligible under the terms of the program.\r\n\r\n**Note:** The party playing a program eligible is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However a program eligible may make a claim under program, e.g., an unemployed worker may claim benefits under an unemployment insurance program, but parties playing these covered party role classes are not, for purposes of this vocabulary and in an effort to clearly distinguish role classes, considered claimants.\r\n\r\nIn the case of a program eligible, a role type code INJWKR (injured worker) subtypes the class to indicate that the covered party in a workers compensation program is an injured worker, and as such, has filed a \"claim\" under the program for benefits. Likewise, a covered role type code UNEMP (unemployed worker) subtypes the program eligible class to indicate that the covered party in an unemployment insurance program has filed a claim for unemployment benefits.\r\n\r\n**Example:** A party meeting eligibility criteria related to health or financial status, e.g., in the U.S., persons meeting health, demographic, or financial criteria established by state and federal law are eligible for Medicaid.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21956"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "programEligible"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "CRINV",
                      "display" : "clinical research investigator",
                      "definition" : "A role played by a provider, always a person, who has agency authority from a Clinical Research Sponsor to direct the conduct of a clinical research trial or study on behalf of the sponsor.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "19164"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "clinicalResearchInvestigator"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "investigator&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "sponsoring&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAH____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAH____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "CRSPNSR",
                      "display" : "clinical research sponsor",
                      "definition" : "A role played by an entity, usually an organization, that is the sponsor of a clinical research trial or study. The sponsor commissions the study, bears the expenses, is responsible for satisfying all legal requirements concerning subject safety and privacy, and is generally responsible for collection, storage and analysis of the data generated during the trial. No scoper is necessary, as a clinical research sponsor undertakes the role on its own authority and declaration. Clinical research sponsors are usually educational or other research organizations, government agencies or biopharmaceutical companies.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "19165"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "clinicalResearchSponsor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "sponsor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "sponsorshipAuthorizing&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAG____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAG____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "EMP",
                      "display" : "employee",
                      "definition" : "A relationship between a person or organization and a person or organization formed for the purpose of exchanging work for compensation. The purpose of the role is to identify the type of relationship the employee has to the employer, rather than the nature of the work actually performed. (Contrast with AssignedEntity.)",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11569"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "employment"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "employee&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "employer&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAE____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAE____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "MIL",
                          "display" : "military person",
                          "definition" : "A role played by a member of a military service. Scoper is the military service (e.g. Army, Navy, Air Force, etc.) or, more specifically, the unit (e.g. Company C, 3rd Battalion, 4th Division, etc.)",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11570"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "militaryPerson"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "military&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "militaryService(&-ORG)"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAAEA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAAEA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "GUAR",
                      "display" : "guarantor",
                      "definition" : "A person or organization (player) that serves as a financial guarantor for another person or organization (scoper).",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "GuarantorRole"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "13941"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "guarantor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "guarantor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "promisor&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAJ____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAJ____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "INVSBJ",
                      "display" : "Investigation Subject",
                      "definition" : "An entity that is the subject of an investigation. This role is scoped by the party responsible for the investigation.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21464"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "investigativeSubject"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "subject&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "investigationSponsor"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAB____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAB____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "CASEBJ",
                          "display" : "Case Subject",
                          "definition" : "A person, non-person living subject, or place that is the subject of an investigation related to a notifiable condition (health circumstance that is reportable within the applicable public health jurisdiction)",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21465"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "caseSubject"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "subject&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "caseMonitor"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAABA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAABA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "RESBJ",
                          "display" : "research subject",
                          "definition" : "**Definition:**Specifies the administrative functionality within a formal experimental design for which the ResearchSubject role was established.\r\n\r\n**Examples:** Screening - role is used for pre-enrollment evaluation portion of the design; enrolled - role is used for subjects admitted to the experimental portion of the design.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "19166"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "researchSubject"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "subject&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "researchSponsor"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAABB___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAABB___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "LIC",
                      "display" : "licensed entity",
                      "definition" : "A relationship in which the scoper certifies the player ( e. g. a medical care giver, a medical device or a provider organization) to perform certain activities that fall under the jurisdiction of the scoper (e.g., a health authority licensing healthcare providers, a medical quality authority certifying healthcare professionals).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "16773"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "licensedEntity"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "subject&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "(issuing&)|issuer"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAC____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAC____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "NOT",
                          "display" : "notary public",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11576"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "notaryPublic"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "notaryPublic&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "political(&|Entity)"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAACB___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAACB___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "PROV",
                          "display" : "healthcare provider",
                          "definition" : "An Entity (player) that is authorized to provide health care services by some authorizing agency (scoper).",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11599"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "healthCareProvider"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "healthCare(&|Provider)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "(issuing&)|issuer"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAAACA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAAACA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "PAT",
                      "display" : "patient",
                      "definition" : "A Role of a LivingSubject (player) as an actual or potential recipient of health care services from a healthcare provider organization (scoper).\r\n\r\n*Usage Note:* Communication about relationships between patients and specific healthcare practitioners (people) is not done via scoper. Instead this is generally done using the CareProvision act. This allows linkage between patient and a particular healthcare practitioner role and also allows description of the type of care involved in the relationship.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11577"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "patient"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "patient&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "provider&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "PAYEE",
                      "display" : "payee",
                      "definition" : "The role of an organization or individual designated to receive payment for a claim against a particular coverage. The scoping entity is the organization that is the submitter of the invoice in question.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14015"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "payee"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "payee&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "invoicing&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAK____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAK____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "PAYOR",
                      "display" : "invoice payor",
                      "definition" : "The role of an organization that undertakes to accept claims invoices, assess the coverage or payments due for those invoices and pay to the designated payees for those invoices. This role may be either the underwriter or a third-party organization authorized by the underwriter. The scoping entity is the organization that underwrites the claimed coverage.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14014"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "payor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "invoicePayor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAL____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAL____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "POLHOLD",
                      "display" : "policy holder",
                      "definition" : "A role played by a person or organization that holds an insurance policy. The underwriter of that policy is the scoping entity.\r\n\r\n*Discussion:*The identifier of the policy is captured in 'Role.id' when the Role is a policy holder.\r\n\r\nA particular policy may cover several individuals one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14010"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "policyHolder"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "policyHolder&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAM____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAM____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "QUAL",
                      "display" : "qualified entity",
                      "definition" : "An entity (player) that has been recognized as having certain training/experience or other characteristics that would make said entity an appropriate performer for a certain activity. The scoper is an organization that educates or qualifies entities.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11619"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "qualifiedEntity"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "qualified(&|Entity)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "qualificationGranting(&|Entity)"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAP____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAP____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "SPNSR",
                      "display" : "coverage sponsor",
                      "definition" : "A role played by an entity, usually an organization that is the sponsor of an insurance plan or a health program. A sponsor is the party that is ultimately accountable for the coverage by employment contract or by law. A sponsor can be an employer, union, government agency, or association. Fully insured sponsors establish the terms of the plan and contract with health insurance plans to assume the risk and to administer the plan. Self-insured sponsors delegate coverage administration, but not risk, to third-party administrators. Program sponsors designate services to be covered in accordance with statute. Program sponsors may administer the coverage themselves, delegate coverage administration, but not risk to third-party administrators, or contract with health insurance plans to assume the risk and administrator a program. Sponsors qualify individuals who may become\r\n\r\n1.  a policy holder of the plan;\r\n2.  where the sponsor is the policy holder, who may become a subscriber or a dependent to a policy under the plan; or\r\n3.  where the sponsor is a government agency, who may become program eligibles under a program.\r\n\r\nThe sponsor role may be further qualified by the SponsorRole.code. Entities playing the sponsor role may also play the role of a Coverage Administrator.\r\n\r\n*Example:* An employer, union, government agency, or association.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14012"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "sponsor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "sponsor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAN____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAN____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "STD",
                      "display" : "student",
                      "definition" : "A role played by an individual who is a student of a school, which is the scoping entity.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "12248"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "student"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "student"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "school(&|Entity)"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAQ____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAQ____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "UNDWRT",
                      "display" : "underwriter",
                      "definition" : "A role played by a person or an organization. It is the party that\r\n\r\n1.  accepts fiscal responsibility for insurance plans and the policies created under those plans;\r\n2.  administers and accepts fiscal responsibility for a program that provides coverage for services to eligible individuals; and/or\r\n3.  has the responsibility to assess the merits of each risk and decide a suitable premium for accepting all or part of the risk. If played by an organization, this role may be further specified by an appropriate RoleCode.\r\n\r\n*Example:*\r\n\r\n1.  A health insurer;\r\n2.  Medicaid Program;\r\n3.  Lloyd's of London",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14009"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "underwriter"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "scoper&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAAAO____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAAAO____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "CAREGIVER",
                  "display" : "caregiver",
                  "definition" : "A person responsible for the primary care of a patient at home.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21355"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "careGiver"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "careGiver&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "careGiverScoper"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AAAC_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AAAC_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "PRS",
                  "display" : "personal relationship",
                  "definition" : "Links two entities with classCode PSN (person) in a personal relationship. The character of the relationship must be defined by a PersonalRelationshipRoleType code. The player and scoper are determined by PersonalRelationshipRoleType code as well.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19167"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "personalRelationship"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "relationshipHolder"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "personalRelationshipWith"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AAAB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AAAB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "SELF",
                  "display" : "self",
                  "definition" : "The \"same\" roleclass asserts an identity between playing and scoping entities: that they are in fact instances of the same entity and, in the case of discrepancies (e.g different DOB, gender), that one or both are in error.\r\n\r\n*Usage:*\r\n\r\nplaying and scoping entities must have same classcode, but need not have identical attributes or values.\r\n\r\n*Example:* \r\n\r\na provider registry maintains sets of conflicting demographic data for what is reported to be the same individual.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "retired"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21437"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_RoleClassPassive",
              "display" : "RoleClassPassive",
              "definition" : "An association for a playing Entity that is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping Entity. The playing Entity is passive in these roles (even though it may be active in other roles), in the sense that the kinds of things done to it in this role happen without an agreement from the playing Entity.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21117"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "passiveRelation"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "playing&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "scoping&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "AAB______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "AAB______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ACCESS",
                  "display" : "access",
                  "definition" : "A role in which the playing entity (material) provides access to another entity. The principal use case is intravenous (or other bodily) access lines that preexist and need to be referred to for medication routing instructions.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11592"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "access"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "access&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "accessed&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABM_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABM_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "ADJY",
                  "display" : "adjacency",
                  "definition" : "A physical association whereby two Entities are in some (even lose) spatial relationship with each other such that they touch each other in some way.\r\n\r\n*Examples:* the colon is connected (and therefore adjacent) to the jejunum; the colon is adjacent to the liver (even if not actually connected.)\r\n\r\n*UsageConstraints:* Adjacency is in principle a symmetrical connection, but scoper and player of the role should, where applicable, be assigned to have scoper be the larger, more central Entity and player the smaller, more distant, appendage.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23095"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "adjacency"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "distal&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "proximal&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AAB______"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AAB______"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "CONC",
                      "display" : "connection",
                      "definition" : "An adjacency of two Entities held together by a bond which attaches to each of the two entities.\r\n\r\n*Examples:* biceps brachii muscle connected to the radius bone, port 3 on a network switch connected to port 5 on a patch panel.\r\n\r\n*UsageConstraints:* See Adjacency for the assignment of scoper (larger, more central) and player (smaller, more distant).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23096"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "connection"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "distal&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "proximal&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AAB______"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AAB______"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "BOND",
                          "display" : "molecular bond",
                          "definition" : "A connection between two atoms of a molecule.\r\n\r\n*Examples:* double bond between first and second C in ethane, peptide bond between two amino-acid, disulfide bridge between two proteins, chelate and ion associations, even the much weaker van-der-Waals bonds can be considered molecular bonds.\r\n\r\n*UsageConstraints:* See connection and adjacency for the assignment of player and scoper.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "23098"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "bond"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "distal&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "proximal&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAB______"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAB______"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "CONY",
                          "display" : "continuity",
                          "definition" : "A connection between two regional parts.\r\n\r\n*Examples:*  the connection between ascending aorta and the aortic arc, connection between descending colon and sigmoid.\r\n\r\n*UsageConstraints:* See connection and adjacency for the assignment of player and scoper.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "23097"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "continuity"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "distal&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "proximal&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AAB______"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AAB______"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "ADMM",
                  "display" : "Administerable Material",
                  "definition" : "A material (player) that can be administered to an Entity (scoper).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21435"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "administrableMaterial"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "administrable(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "(scoping&)|scoper"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABO_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABO_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "BIRTHPL",
                  "display" : "birthplace",
                  "definition" : "Relates a place (playing Entity) as the location where a living subject (scoping Entity) was born.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11589"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "birthplace"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "birthplace"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "birthplaceFor&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABL_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABL_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "DEATHPLC",
                  "display" : "place of death",
                  "definition" : "Definition: Relates a place (playing Entity) as the location where a living subject (scoping Entity) died.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21640"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "placeOfDeath"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "DST",
                  "display" : "distributed material",
                  "definition" : "A material (player) distributed by a distributor (scoper) who functions between a manufacturer and a buyer or retailer.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10418"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "distributedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "distributed(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "(distributing&)|distributor"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "RET",
                      "display" : "retailed material",
                      "definition" : "Material (player) sold by a retailer (scoper), who also give advice to prospective buyers.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10419"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "retailedProduct"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "retailed(&|Product)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "retailer&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AABBA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AABBA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "EXLOC",
                  "display" : "event location",
                  "definition" : "A role played by a place at which the location of an event may be recorded.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23368"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "eventLocation"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "EventLocation(&-PLC)"
                    },
                    {
                      "code" : "Name:role:scoper:Entity",
                      "valueCode" : "initiator&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABI_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABI_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "SDLOC",
                      "display" : "service delivery location",
                      "definition" : "A role played by a place at which services may be provided.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "16927"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "serviceDeliveryLocation"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "location(&-PLC)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "serviceProvider&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AABJ_____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AABJ_____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "DSDLOC",
                          "display" : "dedicated service delivery location",
                          "definition" : "A role of a place (player) that is intended to house the provision of services. Scoper is the Entity (typically Organization) that provides these services. This is not synonymous with \"ownership.\"",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "health care facility"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11600"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "dedicatedServiceDeliveryLocation"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "location(&-PLC)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "recognizing&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AABJB____"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AABJB____"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "ISDLOC",
                          "display" : "incidental service delivery location",
                          "definition" : "A role played by a place at which health care services may be provided without prior designation or authorization.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "16929"
                            },
                            {
                              "code" : "Name:Class",
                              "valueCode" : "incidentalServiceDeliveryLocation"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueCode" : "location(&-PLC)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueCode" : "recognizing&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueCode" : "AABJA____"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueCode" : "AABJA____"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "EXPR",
                  "display" : "exposed entity",
                  "definition" : "A role played by an entity that has been exposed to a person or animal suffering a contagious disease, or with a location from which a toxin has been distributed. The player of the role is normally a person or animal, but it is possible that other entity types could become exposed. The role is scoped by the source of the exposure, and it is quite possible for a person playing the role of exposed party to also become the scoper a role played by another person. That is to say, once a person has become infected, it is possible, perhaps likely, for that person to infect others.\r\n\r\nManagement of exposures and tracking exposed parties is a key function within public health, and within most public health contexts - exposed parties are known as \"contacts.\"",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19131"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "exposedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "exposed&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "exposing&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABN_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABN_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "HLD",
                  "display" : "held entity",
                  "definition" : "Entity that is currently in the possession of a holder (scoper), who holds, or uses it, usually based on some agreement with the owner.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10422"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "heldEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "held(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "(holding&)|holder"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABC_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABC_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "HLTHCHRT",
                  "display" : "health chart",
                  "definition" : "The role of a material (player) that is the physical health chart belonging to an organization (scoper).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11618"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "healthChart"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "healthChart&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "subject&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABI_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABI_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "IDENT",
                  "display" : "identified entity",
                  "definition" : "A role in which the scoping entity designates an identifier for a playing entity.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16721"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "identifiedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "identified(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "assigning(&|Authority)"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "MANU",
                  "display" : "manufactured product",
                  "definition" : "Scoped by the manufacturer",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11580"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "manufacturedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "manufactured(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "manufacturer&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABD_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABD_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "THER",
                      "display" : "therapeutic agent",
                      "definition" : "A manufactured material (player) that is used for its therapeutic properties. The manufacturer is the scoper.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11581"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "manufacturedProduct"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "manufactured(&|Product)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "manufacturer&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "AABDA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "AABDA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "MNT",
                  "display" : "maintained entity",
                  "definition" : "An entity (player) that is maintained by another entity (scoper). This is typical role held by durable equipment. The scoper assumes responsibility for proper operation, quality, and safety.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10427"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "maintainedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "maintained(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "(maintaining&)|maintainer"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABE_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABE_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "OWN",
                  "display" : "owned entity",
                  "definition" : "An Entity (player) for which someone (scoper) is granted by law the right to call the material (player) his own. This entitles the scoper to make decisions about the disposition of that material.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10421"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "ownedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "owned(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "(owning&)|owner"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABF_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABF_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "RGPR",
                  "display" : "regulated product",
                  "definition" : "A product regulated by some governmentatl orgnization. The role is played by Material and scoped by Organization.\r\n\r\nRationale: To support an entity clone used to identify the NDC number for a drug product.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19132"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "regulatedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "regulated(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "regulator&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABH_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABH_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "TERR",
                  "display" : "territory of authority",
                  "definition" : "Relates a place entity (player) as the region over which the scoper (typically an Organization) has certain authority (jurisdiction). For example, the Calgary Regional Health Authority (scoper) has authority over the territory \"Region 4 of Alberta\" (player) in matters of health.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11583"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "territorialAuthority"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "territory(&-PLC)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "governing&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABK_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABK_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "USED",
                  "display" : "used entity",
                  "definition" : "**Description:**An entity (player) that is used by another entity (scoper)",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22755"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "usedEntity"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "WRTE",
                  "display" : "warranted product",
                  "definition" : "A role a product plays when a guarantee is given to the purchaser by the seller (scoping entity) stating that the product is reliable and free from known defects and that the seller will repair or replace defective parts within a given time limit and under certain conditions.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16300"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "warrantedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "warranted(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "(warranting&)|warranter"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "AABG_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "AABG_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_RoleClassOntological",
          "display" : "RoleClassOntological",
          "definition" : "A relationship in which the scoping Entity defines or specifies what the playing Entity is. Thus, the player's \"being\" (Greek: ontos) is specified.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21115"
            },
            {
              "code" : "Name:Class",
              "valueCode" : "definedEntity"
            },
            {
              "code" : "Name:Role:player:Entity",
              "valueCode" : "defined&"
            },
            {
              "code" : "Name:Role:scoper:Entity",
              "valueCode" : "defining&"
            },
            {
              "code" : "Sort:Entity:playedRole:Role",
              "valueCode" : "AC_______"
            },
            {
              "code" : "Sort:Entity:scopedRole:Role",
              "valueCode" : "AC_______"
            },
            {
              "code" : "Name:Entity:playedRole:Role",
              "valueString" : "as&"
            },
            {
              "code" : "Name:Entity:scopedRole:Role",
              "valueString" : "&"
            },
            {
              "code" : "Name:Participation:role:Role",
              "valueString" : "&"
            }
          ],
          "concept" : [
            {
              "code" : "EQUIV",
              "display" : "equivalent entity",
              "definition" : "**Description:** Specifies the player Entity (the equivalent Entity) as an Entity that is considered to be equivalent to a reference Entity (scoper). The equivalence is in principle a symmetric relationship, however, it is expected that the scoper is a reference entity which serves as reference entity for multiple different equivalent entities.\r\n\r\n**Examples:** An innovator's medicine formulation is the reference for \"generics\", i.e., formulations manufactured differently but having been proven to be biologically equivalent to the reference medicine. Another example is a reference ingredient that serves as basis for quantity specifications (basis of strength, e.g., metoprolol succinate specified in terms of metoprolol tartrate.)",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22399"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "equivalentEntity"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "SAME",
                  "display" : "same",
                  "definition" : "The \"same\" role asserts an identity between playing and scoping entities, i.e., that they are in fact two records of the same entity instance, and, in the case of discrepancies (e.g different DOB, gender), that one or both are in error.\r\n\r\n*Usage:*\r\n\r\nplaying and scoping entities must have same classCode, but need not have identical attributes or values.\r\n\r\n*Example:* \r\n\r\na provider registry maintains sets of conflicting demographic data for what is reported to be the same individual.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21488"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "same"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "same&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "same&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ACE______"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ACE______"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "SUBY",
                  "display" : "subsumed by",
                  "definition" : "Relates a prevailing record of an Entity (scoper) with another record (player) that it subsumes.\r\n\r\n*Examples:* Show a correct new Person object (scoper) that subsumes one or more duplicate Person objects that had accidentally been created for the same physical person.\r\n\r\n*Constraints:* Both the player and scoper must have the same classCode.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20070"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "subsumedBy"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "subsuming&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "subsumed&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ACD______"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ACD______"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "GEN",
              "display" : "has generalization",
              "definition" : "Relates a specialized material concept (player) to its generalization (scoper).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10441"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "specializedKind"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "specialized(&|Kind)"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "generalized(&|Kind)"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ACA______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ACA______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "GRIC",
                  "display" : "has generic",
                  "definition" : "A special link between pharmaceuticals indicating that the target (scoper) is a generic for the source (player).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10442"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "entityWithGeneric"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "specialized(&|Kind)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "generic(&|Kind)"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ACAA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ACAA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "INST",
              "display" : "instance",
              "definition" : "An individual piece of material (player) instantiating a class of material (scoper).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10443"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "instanceOfKind"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "&Instance"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "kindOf&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ACB______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ACB______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            },
            {
              "code" : "SUBS",
              "display" : "subsumer",
              "definition" : "An entity that subsumes the identity of another. Used in the context of merging documented entity instances. Both the player and scoper must have the same classCode.\r\n\r\nThe use of this code is **deprecated** in favor of the term SUBY which is its inverse and is more ontologically correct.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "deprecated"
                },
                {
                  "code" : "deprecationDate",
                  "valueDateTime" : "2011-12-01"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16241"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            }
          ]
        },
        {
          "code" : "_RoleClassPartitive",
          "display" : "RoleClassPartitive",
          "definition" : "An association between two Entities where the playing Entity is considered in some way \"part\" of the scoping Entity, e.g., as a member, component, ingredient, or content. Being \"part\" in the broadest sense of the word can mean anything from being an integral structural component to a mere incidental temporary association of a playing Entity with a (generally larger) scoping Entity.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21116"
            },
            {
              "code" : "Name:Class",
              "valueCode" : "partOfWhole"
            },
            {
              "code" : "Name:Role:player:Entity",
              "valueCode" : "part&"
            },
            {
              "code" : "Name:Role:scoper:Entity",
              "valueCode" : "whole&"
            },
            {
              "code" : "Sort:Entity:playedRole:Role",
              "valueCode" : "AB_______"
            },
            {
              "code" : "Sort:Entity:scopedRole:Role",
              "valueCode" : "AB_______"
            },
            {
              "code" : "Name:Entity:playedRole:Role",
              "valueString" : "as&"
            },
            {
              "code" : "Name:Entity:scopedRole:Role",
              "valueString" : "&"
            },
            {
              "code" : "Name:Participation:role:Role",
              "valueString" : "&"
            }
          ],
          "concept" : [
            {
              "code" : "CONT",
              "display" : "content",
              "definition" : "Relates a material as the content (player) to a container (scoper). Unlike ingredients, the content and a container remain separate (not mixed) and the content can be removed from the container. A content is not part of an empty container.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10438"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "content"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "(contained(&-MAT))|content"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "container&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ABB______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ABB______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            },
            {
              "code" : "EXPAGTCAR",
              "display" : "exposure agent carrier",
              "definition" : "An exposure agent carrier is an entity that is capable of conveying an exposure agent from one entity to another. The scoper of the role must be the exposure agent (e.g., pathogen).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22350"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "exposureAgentCarrier"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "EXPVECTOR",
                  "display" : "exposure vector",
                  "definition" : "**Description:** A vector is a living subject that carries an exposure agent. The vector does not cause the disease itself, but exposes targets to the exposure agent. A mosquito carrying malaria is an example of a vector. The scoper of the role must be the exposure agent (e.g., pathogen).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22351"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "exposureVector"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "FOMITE",
                  "display" : "fomite",
                  "definition" : "**Description:** A fomite is a non-living entity that is capable of conveying exposure agent from one entity to another. A doorknob contaminated with a Norovirus is an example of a fomite. Anyone touching the doorknob would be exposed to the virus. The scoper of the role must be the exposure agent (e.g., pathogen).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22352"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "fomite"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "INGR",
              "display" : "ingredient",
              "definition" : "Relates a component (player) to a mixture (scoper). E.g., Glucose and Water are ingredients of D5W, latex may be an ingredient in a tracheal tube.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10430"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "ingredient"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "ingredient&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "ingredientOf&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ABD______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ABD______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ACTI",
                  "display" : "active ingredient",
                  "definition" : "**Definition:** a therapeutically active ingredient (player) in a mixture (scoper), where the mixture is typically a manufactured pharmaceutical. It is unknown if the quantity of such an ingredient is expressed precisely in terms of the playing ingredient substance, or, if it is specified in terms of a closely related substance (active moiety or reference substance).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10433"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "activeIngredient"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "activeIngredient&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "ingredientOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABDA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABDA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ACTIB",
                      "display" : "active ingredient - basis of strength",
                      "definition" : "**Description:**  Active ingredient, where the ingredient substance (player) is itself the \"basis of strength\", i.e., where the Role.quantity specifies exactly the quantity of the player substance in the medicine formulation.\r\n\r\n**Examples:** Lopressor 50 mg actually contains 50 mg of metoprolol succinate, even though the active moiety is metoprolol, but also: Tenormin 50 mg contain 50 mg of atenolol, as free base, i.e., where the active ingredient atenolol is also the active moiety.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "22396"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "activeIngredientBasisOfStrength"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "ACTIM",
                      "display" : "active ingredient - moiety is basis of strength",
                      "definition" : "**Description:** Active ingredient, where not the ingredient substance (player), but itaTMs active moiety is the \"basis of strength\", i.e., where the Role.quantity specifies the quantity of the player substance's active moiety in the medicine formulation.\r\n\r\n**Examples:** 1 mL of Betopic 5mg/mL eye drops contains 5.6 mg betaxolol hydrochloride equivalent to betaxolol base 5 mg.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "22397"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "activeIngredientMoietyIsBasisOfStrength"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "ACTIR",
                      "display" : "active ingredient - reference substance is basis of strength",
                      "definition" : "**Description:** Active ingredient, where not the ingredient substance (player) but another reference substance with the same active moiety, is the \"basis of strength\", i.e., where the Role.quantity specifies the quantity of a reference substance, similar but different from the player substance's in the medicine formulation.\r\n\r\n**Examples:** Toprol-XL 50 mg contains 47.5 mg of metoprolol succinate equivalent to 50 mg of metoprolol tartrate.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "22398"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "activeIngredientReferenceSubstanceIsBasisOfStrength"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "ADJV",
                  "display" : "adjuvant",
                  "definition" : "A component (player) added to enhance the action of an active ingredient (scoper) (in the manner of a catalyst) but which has no active effect in and of itself. Such ingredients are significant in defining equivalence of products in a way that inactive ingredients are not.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23059"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "adjuvant"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "ADTV",
                  "display" : "additive",
                  "definition" : "An ingredient (player) that is added to a base (scoper), that amounts to a minor part of the overall mixture.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10432"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "additive"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "additive&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "additiveOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABDE_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABDE_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "BASE",
                  "display" : "base",
                  "definition" : "A base ingredient (player) is what comprises the major part of a mixture (scoper). E.g., Water in most i.v. solutions, or Vaseline in salves. Among all ingredients of a material, there should be only one base. A base substance can, in turn, be a mixture.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10431"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "base"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "base&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "baseOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABDC_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABDC_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "CNTM",
                  "display" : "contaminant ingredient",
                  "definition" : "An ingredient whose presence is not intended but may not be reasonably avoided given the circumstances of the mixture's nature or origin.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23369"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "contaminant"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "contaminant&"
                    },
                    {
                      "code" : "Name:role:scoper:Entity",
                      "valueCode" : "contaminantOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABDF_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABDF_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "IACT",
                  "display" : "inactive ingredient",
                  "definition" : "An ingredient which is not considered therapeutically active, e.g., colors, flavors, stabilizers, or preservatives, fillers, or structural components added to an active ingredient in order to facilitate administration of the active ingredient but without being considered therapeutically active. An inactive ingredient need not be biologically inert, e.g., might be active as an allergen or might have a pleasant taste, but is not an essential constituent delivering the therapeutic effect.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19089"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "inactiveIngredient"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "inactiveIngredient&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "ingredientOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABDD_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABDD_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "COLR",
                      "display" : "color additive",
                      "definition" : "A substance (player) influencing the optical aspect of material (scoper).",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "color"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10437"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "colorAdditive"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "color&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "additiveOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "ABDDC____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "ABDDC____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "FLVR",
                      "display" : "flavor additive",
                      "definition" : "A substance (player) added to a mixture (scoper) to make it taste a certain way. In food the use is obvious, in pharmaceuticals flavors can hide disgusting taste of the active ingredient (important in pediatric treatments).",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "flavor"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10436"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "flavorAdditive"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "flavor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "additiveOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "ABDDD____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "ABDDD____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "PRSV",
                      "display" : "preservative",
                      "definition" : "A substance (player) added to a mixture (scoper) to prevent microorganisms (fungi, bacteria) to spoil the mixture.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10435"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "preservative"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "preservative&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "preservativeOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "ABDDA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "ABDDA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "STBL",
                      "display" : "stabilizer",
                      "definition" : "A stabilizer (player) added to a mixture (scoper) in order to prevent the molecular disintegration of the main substance.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10434"
                        },
                        {
                          "code" : "Name:Class",
                          "valueCode" : "stabilizer"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueCode" : "stabilizer&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueCode" : "stabilizerOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueCode" : "ABDDB____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueCode" : "ABDDB____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "MECH",
                  "display" : "mechanical ingredient",
                  "definition" : "An ingredient (player) of a medication (scoper) that is inseparable from the active ingredients, but has no intended chemical or pharmaceutical effect itself, but which may have some systemic effect on the patient.\r\n\r\nAn example is a collagen matrix used as a base for transplanting skin cells. The collagen matrix can be left permanently in the graft site. Because it is of bovine origin, the patient may exhibit allergies or may have cultural objections to its use.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23060"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "mechanicalIngredient"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "LOCE",
              "display" : "located entity",
              "definition" : "Relates an entity (player) to a location (scoper) at which it is present in some way. This presence may be limited in time.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16815"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "locatedEntity"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "located(&|Entity)"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "location(&-PLC)"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ABE______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ABE______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "STOR",
                  "display" : "stored entity",
                  "definition" : "Relates an entity (player) (e.g. a device) to a location (scoper) at which it is normally found or stored when not used.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16817"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "storedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "stored(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "storageLocation(&-PLC)"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABEA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABEA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "MBR",
              "display" : "member",
              "definition" : "A role played by an entity that is a member of a group. The group provides the scope for this role.\r\n\r\nAmong other uses, groups as used in insurance (groups of covered individuals) and in scheduling where resources may be grouped for scheduling and logistical purposes.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "12204"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "member"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "member&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "group&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ABF______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ABF______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            },
            {
              "code" : "PART",
              "display" : "part",
              "definition" : "**Definition:**  an association between two Entities where the playing Entity (the part) is a component of the whole (scoper) in the sense of an integral structural component, that is distinct from other parts in the same whole, has a distinct function in the whole, and, as an effect, the full integrity of the whole depends (to some degree) on the presence of this part, even though the part may often be separable from the whole.\r\n\r\n**Discussion:** Part is defined in opposition to (a) ingredient (not separable), (b) content (not a functional component), and (c) member (not functionally distinct from other members).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19102"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "partOfWhole"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "part&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "whole&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ABC______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ABC______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ACTM",
                  "display" : "active moiety",
                  "definition" : "The molecule or ion that is responsible for the intended pharmacological action of the drug substance, excluding those appended or associated parts of the molecule that make the molecule an ester, salt (including a salt with hydrogen or coordination bonds), or other noncovalent derivative (such as a complex, chelate, or clathrate).\r\n\r\nExamples: heparin-sodium and heparin-potassium have the same active moiety, heparin; the active moiety of morphine-hydrochloride is morphine.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19088"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "activeMoiety"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "activeMoiety"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "moietyOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABDB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABDB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SPEC",
              "display" : "specimen",
              "definition" : "A role played by a material entity that is a specimen for an act. It is scoped by the source of the specimen.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "11591"
                },
                {
                  "code" : "Name:Class",
                  "valueCode" : "specimen"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueCode" : "specimen&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueCode" : "source&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueCode" : "ABA______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueCode" : "ABA______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ALQT",
                  "display" : "aliquot",
                  "definition" : "A portion (player) of an original or source specimen (scoper) used for testing or transportation.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14026"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "aliquot"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "aliquot&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "source&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABAA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABAA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "ISLT",
                  "display" : "isolate",
                  "definition" : "A microorganism that has been isolated from other microorganisms or a source matrix.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16302"
                    },
                    {
                      "code" : "Name:Class",
                      "valueCode" : "isolate"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueCode" : "isolate&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueCode" : "source&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueCode" : "ABAB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueCode" : "ABAB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "CHILD",
      "display" : "child",
      "definition" : "The player of the role is a child of the scoping entity, in a generic sense.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11560"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CRED",
      "display" : "credentialed entity",
      "definition" : "A role played by an entity that receives credentials from the scoping entity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "16930"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "NURPRAC",
      "display" : "nurse practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11574"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "NURS",
      "display" : "nurse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11573"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "physician assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11575"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PHYS",
      "display" : "physician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11572"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    }
  ]
}

```
