# ObservationValue - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ObservationValue**

## CodeSystem: ObservationValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ObservationValue | *Version*:4.0.0 | |
| Active as of 2024-02-28 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationValue |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1063 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This code system covers all concepts of HL7-defined values for the Observation value element, when it has a coded datatype. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActCoverageAssessmentObservationValue](ValueSet-v3-ActCoverageAssessmentObservationValue.md)
* [ActFinancialStatusObservationValue](ValueSet-v3-ActFinancialStatusObservationValue.md)
* [AllergyTestValue](ValueSet-v3-AllergyTestValue.md)
* [CompositeMeasureScoring](ValueSet-v3-CompositeMeasureScoring.md)
* [CoverageLevelObservationValue](ValueSet-v3-CoverageLevelObservationValue.md)
* [CoverageLimitObservationValue](ValueSet-v3-CoverageLimitObservationValue.md)
* [CriticalityObservationValue](ValueSet-v3-CriticalityObservationValue.md)
* [GeneticObservationValue](ValueSet-v3-GeneticObservationValue.md)
* [ObservationAssetValue](ValueSet-v3-ObservationAssetValue.md)
* [ObservationEligibilityIndicatorValue](ValueSet-v3-ObservationEligibilityIndicatorValue.md)
* [ObservationHealthStatusValue](ValueSet-v3-ObservationHealthStatusValue.md)
* [ObservationIncomeValue](ValueSet-v3-ObservationIncomeValue.md)
* [ObservationLivingDependencyValue](ValueSet-v3-ObservationLivingDependencyValue.md)
* [ObservationLivingExpenseValue](ValueSet-v3-ObservationLivingExpenseValue.md)
* [ObservationLivingSituationValue](ValueSet-v3-ObservationLivingSituationValue.md)
* [ObservationMeasureScoring](ValueSet-v3-ObservationMeasureScoring.md)
* [ObservationMeasureType](ValueSet-v3-ObservationMeasureType.md)
* [ObservationPopulationInclusion](ValueSet-v3-ObservationPopulationInclusion.md)
* [ObservationSocioEconomicStatusValue](ValueSet-v3-ObservationSocioEconomicStatusValue.md)
* [PartialCompletionScale](ValueSet-v3-PartialCompletionScale.md)
* [SecurityAlterationIntegrityObservationValue](ValueSet-v3-SecurityAlterationIntegrityObservationValue.md)
* [SecurityCategoryObservationValue](ValueSet-v3-SecurityCategoryObservationValue.md)
* [SecurityControlObservationValue](ValueSet-v3-SecurityControlObservationValue.md)
* [SecurityDataIntegrityObservationValue](ValueSet-v3-SecurityDataIntegrityObservationValue.md)
* [SecurityIntegrityConfidenceObservationValue](ValueSet-v3-SecurityIntegrityConfidenceObservationValue.md)
* [SecurityIntegrityObservationValue](ValueSet-v3-SecurityIntegrityObservationValue.md)
* [SecurityIntegrityProvenanceAssertedByObservationValue](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationValue.md)
* [SecurityIntegrityProvenanceObservationValue](ValueSet-v3-SecurityIntegrityProvenanceObservationValue.md)
* [SecurityIntegrityProvenanceReportedByObservationValue](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationValue.md)
* [SecurityObservationValue](ValueSet-v3-SecurityObservationValue.md)
* [SecurityTrustAccreditationObservationValue](ValueSet-v3-SecurityTrustAccreditationObservationValue.md)
* [SecurityTrustAgreementObservationValue](ValueSet-v3-SecurityTrustAgreementObservationValue.md)
* [SecurityTrustAssuranceObservationValue](ValueSet-v3-SecurityTrustAssuranceObservationValue.md)
* [SecurityTrustCertificateObservationValue](ValueSet-v3-SecurityTrustCertificateObservationValue.md)
* [SecurityTrustFrameworkObservationValue](ValueSet-v3-SecurityTrustFrameworkObservationValue.md)
* [SecurityTrustMechanismObservationValue](ValueSet-v3-SecurityTrustMechanismObservationValue.md)
* [SecurityTrustObservationValue](ValueSet-v3-SecurityTrustObservationValue.md)
* [SeverityObservation](ValueSet-v3-SeverityObservation.md)
* [VerificationOutcomeValue](ValueSet-v3-VerificationOutcomeValue.md)
* [WorkScheduleODH](ValueSet-v3-WorkScheduleODH.md)
* [EmploymentStatusODH](ValueSet-v3-employmentStatusODH.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ObservationValue",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ObservationValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1063"
    }
  ],
  "version" : "4.0.0",
  "name" : "ObservationValue",
  "title" : "ObservationValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-28T00:00:00.000-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system covers all concepts of HL7-defined values for the Observation value element, when it has a coded datatype.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : false,
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "_ActCoverageAssessmentObservationValue",
      "display" : "ActCoverageAssessmentObservationValue",
      "definition" : "Codes specify the category of observation, evidence, or document used to assess for services, e.g., discharge planning, or to establish eligibility for coverage under a policy or program. The type of evidence is coded as observation values.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22268"
        }
      ],
      "concept" : [
        {
          "code" : "_ActFinancialStatusObservationValue",
          "display" : "ActFinancialStatusObservationValue",
          "definition" : "Code specifying financial indicators used to assess or establish eligibility for coverage under a policy or program; e.g., pay stub; tax or income document; asset document; living expenses.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22306"
            }
          ],
          "concept" : [
            {
              "code" : "ASSET",
              "display" : "asset",
              "definition" : "Codes specifying asset indicators used to assess or establish eligibility for coverage under a policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22316"
                }
              ],
              "concept" : [
                {
                  "code" : "ANNUITY",
                  "display" : "annuity",
                  "definition" : "Indicator of annuity ownership or status as beneficiary.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22320"
                    }
                  ]
                },
                {
                  "code" : "PROP",
                  "display" : "real property",
                  "definition" : "Indicator of real property ownership, e.g., deed or real estate contract.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22317"
                    }
                  ]
                },
                {
                  "code" : "RETACCT",
                  "display" : "retirement investment account",
                  "definition" : "Indicator of retirement investment account ownership.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22318"
                    }
                  ]
                },
                {
                  "code" : "TRUST",
                  "display" : "trust",
                  "definition" : "Indicator of status as trust beneficiary.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22319"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "INCOME",
              "display" : "income",
              "definition" : "Code specifying income indicators used to assess or establish eligibility for coverage under a policy or program; e.g., pay or pension check, child support payments received or provided, and taxes paid.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22307"
                }
              ],
              "concept" : [
                {
                  "code" : "CHILD",
                  "display" : "child support",
                  "definition" : "Indicator of child support payments received or provided.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22311"
                    }
                  ]
                },
                {
                  "code" : "DISABL",
                  "display" : "disability pay",
                  "definition" : "Indicator of disability income replacement payment.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22314"
                    }
                  ]
                },
                {
                  "code" : "INVEST",
                  "display" : "investment income",
                  "definition" : "Indicator of investment income, e.g., dividend check, annuity payment; real estate rent, investment divestiture proceeds; trust or endowment check.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22310"
                    }
                  ]
                },
                {
                  "code" : "PAY",
                  "display" : "paid employment",
                  "definition" : "Indicator of paid employment, e.g., letter of hire, contract, employer letter; copy of pay check or pay stub.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22308"
                    }
                  ]
                },
                {
                  "code" : "RETIRE",
                  "display" : "retirement pay",
                  "definition" : "Indicator of retirement payment, e.g., pension check.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22309"
                    }
                  ]
                },
                {
                  "code" : "SPOUSAL",
                  "display" : "spousal or partner support",
                  "definition" : "Indicator of spousal or partner support payments received or provided; e.g., alimony payment; support stipulations in a divorce settlement.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22312"
                    }
                  ]
                },
                {
                  "code" : "SUPPLE",
                  "display" : "income supplement",
                  "definition" : "Indicator of income supplement, e.g., gifting, parental income support; stipend, or grant.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22313"
                    }
                  ]
                },
                {
                  "code" : "TAX",
                  "display" : "tax obligation",
                  "definition" : "Indicator of tax obligation or payment, e.g., statement of taxable income.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22315"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "LIVEXP",
              "display" : "living expense",
              "definition" : "Codes specifying living expense indicators used to assess or establish eligibility for coverage under a policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22321"
                }
              ],
              "concept" : [
                {
                  "code" : "CLOTH",
                  "display" : "clothing expense",
                  "definition" : "Indicator of clothing expenses.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22327"
                    }
                  ]
                },
                {
                  "code" : "FOOD",
                  "display" : "food expense",
                  "definition" : "Indicator of transportation expenses.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22329"
                    }
                  ]
                },
                {
                  "code" : "HEALTH",
                  "display" : "health expense",
                  "definition" : "Indicator of health expenses; including medication costs, health service costs, financial participations, and health coverage premiums.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22326"
                    }
                  ]
                },
                {
                  "code" : "HOUSE",
                  "display" : "household expense",
                  "definition" : "Indicator of housing expense, e.g., household appliances, fixtures, furnishings, and maintenance and repairs.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22324"
                    }
                  ]
                },
                {
                  "code" : "LEGAL",
                  "display" : "legal expense",
                  "definition" : "Indicator of legal expenses.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22328"
                    }
                  ]
                },
                {
                  "code" : "MORTG",
                  "display" : "mortgage",
                  "definition" : "Indicator of mortgage amount, interest, and payments.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22323"
                    }
                  ]
                },
                {
                  "code" : "RENT",
                  "display" : "rent",
                  "definition" : "Indicator of rental or lease payments.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22322"
                    }
                  ]
                },
                {
                  "code" : "SUNDRY",
                  "display" : "sundry expense",
                  "definition" : "Indicator of transportation expenses.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22330"
                    }
                  ]
                },
                {
                  "code" : "TRANS",
                  "display" : "transportation expense",
                  "definition" : "Indicator of transportation expenses, e.g., vehicle payments, vehicle insurance, vehicle fuel, and vehicle maintenance and repairs.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22325"
                    }
                  ]
                },
                {
                  "code" : "UTIL",
                  "display" : "utility expense",
                  "definition" : "Indicator of transportation expenses.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22331"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "ELSTAT",
          "display" : "eligibility indicator",
          "definition" : "Code specifying eligibility indicators used to assess or establish eligibility for coverage under a policy or program eligibility status, e.g., certificates of creditable coverage; student enrollment; adoption, marriage or birth certificate.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22295"
            }
          ],
          "concept" : [
            {
              "code" : "ADOPT",
              "display" : "adoption document",
              "definition" : "Indicator of adoption.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22304"
                }
              ]
            },
            {
              "code" : "BTHCERT",
              "display" : "birth certificate",
              "definition" : "Indicator of birth.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22303"
                }
              ]
            },
            {
              "code" : "CCOC",
              "display" : "creditable coverage document",
              "definition" : "Indicator of creditable coverage.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22299"
                }
              ]
            },
            {
              "code" : "DRLIC",
              "display" : "driver license",
              "definition" : "Indicator of driving status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22301"
                }
              ]
            },
            {
              "code" : "FOSTER",
              "display" : "foster child document",
              "definition" : "Indicator of foster child status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22305"
                }
              ]
            },
            {
              "code" : "MEMBER",
              "display" : "program or policy member",
              "definition" : "Indicator of status as covered member under a policy or program, e.g., member id card or coverage document.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22296"
                }
              ]
            },
            {
              "code" : "MIL",
              "display" : "military identification",
              "definition" : "Indicator of military status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22302"
                }
              ]
            },
            {
              "code" : "MRGCERT",
              "display" : "marriage certificate",
              "definition" : "Indicator of marriage status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22300"
                }
              ]
            },
            {
              "code" : "PASSPORT",
              "display" : "passport",
              "definition" : "Indicator of citizenship.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22297"
                }
              ]
            },
            {
              "code" : "STUDENRL",
              "display" : "student enrollment",
              "definition" : "Indicator of student status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22298"
                }
              ]
            }
          ]
        },
        {
          "code" : "HLSTAT",
          "display" : "health status",
          "definition" : "Code specifying non-clinical indicators related to health status used to assess or establish eligibility for coverage under a policy or program, e.g., pregnancy, disability, drug use, mental health issues.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22290"
            }
          ],
          "concept" : [
            {
              "code" : "DISABLE",
              "display" : "disabled",
              "definition" : "Indication of disability.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22293"
                }
              ]
            },
            {
              "code" : "DRUG",
              "display" : "drug use",
              "definition" : "Indication of drug use.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22294"
                }
              ]
            },
            {
              "code" : "IVDRG",
              "display" : "IV drug use",
              "definition" : "Indication of IV drug use .",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22292"
                }
              ]
            },
            {
              "code" : "PGNT",
              "display" : "pregnant",
              "definition" : "Non-clinical report of pregnancy.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22291"
                }
              ]
            }
          ]
        },
        {
          "code" : "LIVDEP",
          "display" : "living dependency",
          "definition" : "Code specifying observations related to living dependency, such as dependent upon spouse for activities of daily living.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22286"
            }
          ],
          "concept" : [
            {
              "code" : "RELDEP",
              "display" : "relative dependent",
              "definition" : "Continued living in private residence requires functional and health care assistance from one or more relatives.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22288"
                }
              ]
            },
            {
              "code" : "SPSDEP",
              "display" : "spouse dependent",
              "definition" : "Continued living in private residence requires functional and health care assistance from spouse or life partner.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22287"
                }
              ]
            },
            {
              "code" : "URELDEP",
              "display" : "unrelated person dependent",
              "definition" : "Continued living in private residence requires functional and health care assistance from one or more unrelated persons.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22289"
                }
              ]
            }
          ]
        },
        {
          "code" : "LIVSIT",
          "display" : "living situation",
          "definition" : "Code specifying observations related to living situation for a person in a private residence.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22277"
            }
          ],
          "concept" : [
            {
              "code" : "ALONE",
              "display" : "alone",
              "definition" : "Living alone. Maps to PD1-2 Living arrangement (IS) 00742 \\[A\\]",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22281"
                }
              ]
            },
            {
              "code" : "DEPCHD",
              "display" : "dependent children",
              "definition" : "Living with one or more dependent children requiring moderate supervision.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22278"
                }
              ]
            },
            {
              "code" : "DEPSPS",
              "display" : "dependent spouse",
              "definition" : "Living with disabled spouse requiring functional and health care assistance",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22280"
                }
              ]
            },
            {
              "code" : "DEPYGCHD",
              "display" : "dependent young children",
              "definition" : "Living with one or more dependent children requiring intensive supervision",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22279"
                }
              ]
            },
            {
              "code" : "FAM",
              "display" : "live with family",
              "definition" : "Living with family. Maps to PD1-2 Living arrangement (IS) 00742 \\[F\\]",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22284"
                }
              ]
            },
            {
              "code" : "RELAT",
              "display" : "relative",
              "definition" : "Living with one or more relatives. Maps to PD1-2 Living arrangement (IS) 00742 \\[R\\]",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22283"
                }
              ]
            },
            {
              "code" : "SPS",
              "display" : "spouse only",
              "definition" : "Living only with spouse or life partner. Maps to PD1-2 Living arrangement (IS) 00742 \\[S\\]",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22282"
                }
              ]
            },
            {
              "code" : "UNREL",
              "display" : "unrelated person",
              "definition" : "Living with one or more unrelated persons.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22285"
                }
              ]
            }
          ]
        },
        {
          "code" : "SOECSTAT",
          "display" : "socio economic status",
          "definition" : "Code specifying observations or indicators related to socio-economic status used to assess to assess for services, e.g., discharge planning, or to establish eligibility for coverage under a policy or program.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22269"
            }
          ],
          "concept" : [
            {
              "code" : "ABUSE",
              "display" : "abuse victim",
              "definition" : "Indication of abuse victim.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22275"
                }
              ]
            },
            {
              "code" : "HMLESS",
              "display" : "homeless",
              "definition" : "Indication of status as homeless.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22270"
                }
              ]
            },
            {
              "code" : "ILGIM",
              "display" : "illegal immigrant",
              "definition" : "Indication of status as illegal immigrant.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22271"
                }
              ]
            },
            {
              "code" : "INCAR",
              "display" : "incarcerated",
              "definition" : "Indication of status as incarcerated.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22272"
                }
              ]
            },
            {
              "code" : "PROB",
              "display" : "probation",
              "definition" : "Indication of probation status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22273"
                }
              ]
            },
            {
              "code" : "REFUG",
              "display" : "refugee",
              "definition" : "Indication of refugee status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22276"
                }
              ]
            },
            {
              "code" : "UNEMPL",
              "display" : "unemployed",
              "definition" : "Indication of unemployed status.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22274"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_AllergyTestValue",
      "display" : "AllergyTestValue",
      "definition" : "Indicates the result of a particular allergy test. E.g. Negative, Mild, Moderate, Severe",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21496"
        }
      ],
      "concept" : [
        {
          "code" : "A0",
          "display" : "no reaction",
          "definition" : "**Description:**Patient exhibits no reaction to the challenge agent.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22816"
            }
          ]
        },
        {
          "code" : "A1",
          "display" : "minimal reaction",
          "definition" : "**Description:**Patient exhibits a minimal reaction to the challenge agent.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22817"
            }
          ]
        },
        {
          "code" : "A2",
          "display" : "mild reaction",
          "definition" : "**Description:**Patient exhibits a mild reaction to the challenge agent.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22818"
            }
          ]
        },
        {
          "code" : "A3",
          "display" : "moderate reaction",
          "definition" : "**Description:**Patient exhibits moderate reaction to the challenge agent.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22819"
            }
          ]
        },
        {
          "code" : "A4",
          "display" : "severe reaction",
          "definition" : "**Description:**Patient exhibits a severe reaction to the challenge agent.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22820"
            }
          ]
        }
      ]
    },
    {
      "code" : "_CompositeMeasureScoring",
      "display" : "CompositeMeasureScoring",
      "definition" : "Observation values that communicate the method used in a quality measure to combine the component measure results included in an composite measure.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23783"
        }
      ],
      "concept" : [
        {
          "code" : "ALLORNONESCR",
          "display" : "All-or-nothing Scoring",
          "definition" : "Code specifying that the measure uses all-or-nothing scoring. All-or-nothing scoring places an individual in the numerator of the composite measure if and only if they are in the numerator of all component measures in which they are in the denominator.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23784"
            }
          ]
        },
        {
          "code" : "LINEARSCR",
          "display" : "Linear Scoring",
          "definition" : "Code specifying that the measure uses linear scoring. Linear scoring computes the fraction of component measures in which the individual appears in the numerator, giving equal weight to each component measure.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23785"
            }
          ]
        },
        {
          "code" : "OPPORSCR",
          "display" : "Opportunity Scoring",
          "definition" : "Code specifying that the measure uses opportunity-based scoring. In opportunity-based scoring the measure score is determined by combining the denominator and numerator of each component measure to determine an overall composite score.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23786"
            }
          ]
        },
        {
          "code" : "WEIGHTSCR",
          "display" : "Weighted Scoring",
          "definition" : "Code specifying that the measure uses weighted scoring. Weighted scoring assigns a factor to each component measure to weight that measure's contribution to the overall score.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23787"
            }
          ]
        }
      ]
    },
    {
      "code" : "_CoverageLimitObservationValue",
      "display" : "CoverageLimitObservationValue",
      "definition" : "**Description:**Coded observation values for coverage limitations, for e.g., types of claims or types of parties covered under a policy or program.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22627"
        }
      ],
      "concept" : [
        {
          "code" : "_CoverageLevelObservationValue",
          "display" : "CoverageLevelObservationValue",
          "definition" : "**Description:**Coded observation values for types of covered parties under a policy or program based on their personal relationships or employment status.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22630"
            }
          ],
          "concept" : [
            {
              "code" : "ADC",
              "display" : "adult child",
              "definition" : "**Description:**Child over an age as specified by coverage policy or program, e.g., student, differently abled, and income dependent.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22631"
                }
              ]
            },
            {
              "code" : "CHD",
              "display" : "child",
              "definition" : "**Description:**Dependent biological, adopted, foster child as specified by coverage policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22632"
                }
              ]
            },
            {
              "code" : "DEP",
              "display" : "dependent",
              "definition" : "**Description:**Person requiring functional and/or financial assistance from another person as specified by coverage policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22633"
                }
              ]
            },
            {
              "code" : "DP",
              "display" : "domestic partner",
              "definition" : "**Description:**Persons registered as a family unit in a domestic partner registry as specified by law and by coverage policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22634"
                }
              ]
            },
            {
              "code" : "ECH",
              "display" : "employee",
              "definition" : "**Description:**An individual employed by an employer who receive remuneration in wages, salary, commission, tips, piece-rates, or pay-in-kind through the employeraTMs payment system (i.e., not a contractor) as specified by coverage policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22635"
                }
              ]
            },
            {
              "code" : "FLY",
              "display" : "family coverage",
              "definition" : "**Description:**As specified by coverage policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22636"
                }
              ]
            },
            {
              "code" : "IND",
              "display" : "individual",
              "definition" : "**Description:**Person as specified by coverage policy or program.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22637"
                }
              ]
            },
            {
              "code" : "SSP",
              "display" : "same sex partner",
              "definition" : "**Description:**A pair of people of the same gender who live together as a family as specified by coverage policy or program, e.g., Naomi and Ruth from the Book of Ruth; Socrates and Alcibiades",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22638"
                }
              ]
            }
          ]
        },
        {
          "code" : "_CoverageItemLimitObservationValue",
          "display" : "CoverageItemLimitObservationValue",
          "definition" : "**Description:**Coded observation values for types or instances of items for which coverage is provided under a policy or program, e.g., a type of vehicle or a named work of art.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "22629"
            }
          ]
        },
        {
          "code" : "_CoverageLocationLimitObservationValue",
          "display" : "CoverageLocationLimitObservationValue",
          "definition" : "**Description:**Coded observation values for types or instances of locations for which coverage is provided under a policy or program, e.g., in the covered party home, in state or in the country.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "22628"
            }
          ]
        }
      ]
    },
    {
      "code" : "_CriticalityObservationValue",
      "display" : "CriticalityObservationValue",
      "definition" : "A clinical judgment as to the worst case result of a future exposure (including substance administration). When the worst case result is assessed to have a life-threatening or organ system threatening potential, it is considered to be of high criticality.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23726"
        }
      ],
      "concept" : [
        {
          "code" : "CRITH",
          "display" : "high criticality",
          "definition" : "Worst case result of a future exposure is assessed to be life-threatening or having high potential for organ system failure.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23727"
            }
          ]
        },
        {
          "code" : "CRITL",
          "display" : "low criticality",
          "definition" : "Worst case result of a future exposure is not assessed to be life-threatening or having high potential for organ system failure.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23728"
            }
          ]
        },
        {
          "code" : "CRITU",
          "display" : "unable to assess criticality",
          "definition" : "Unable to assess the worst case result of a future exposure.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23729"
            }
          ]
        }
      ]
    },
    {
      "code" : "_EmploymentStatus",
      "display" : "_EmploymentStatus",
      "definition" : "Concepts representing whether a person does or does not currently have a job or is not currently in the labor pool seeking employment.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23919"
        }
      ],
      "concept" : [
        {
          "code" : "Employed",
          "display" : "Employed",
          "definition" : "Individuals who, during the last week: a) did any work for at least 1 hour as paid or unpaid employees of a business or government organization; worked in their own businesses, professions, or on their own farms; or b) were not working, but who have a job or business from which the individual was temporarily absent because of vacation, illness, bad weather, childcare problems, maternity or paternity leave, labor-management dispute, job training, or other family or personal reasons, regardless of whether or not they were paid for the time off or were seeking other jobs.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23920"
            }
          ]
        },
        {
          "code" : "NotInLaborForce",
          "display" : "Not In Labor Force",
          "definition" : "Persons not classified as employed or unemployed, meaning those who have no job and are not looking for one.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23922"
            }
          ]
        },
        {
          "code" : "Unemployed",
          "display" : "Unemployed",
          "definition" : "Persons who currently have no employment, but are available for work and have made specific efforts to find employment.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23921"
            }
          ]
        }
      ]
    },
    {
      "code" : "_GeneticObservationValue",
      "display" : "GeneticObservationValue",
      "definition" : "**Description:** The domain contains genetic analysis specific observation values, e.g. Homozygote, Heterozygote, etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22648"
        }
      ],
      "concept" : [
        {
          "code" : "Homozygote",
          "display" : "HOMO",
          "definition" : "**Description:** An individual having different alleles at one or more loci regarding a specific character",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22649"
            }
          ]
        }
      ]
    },
    {
      "code" : "_MeasurementImprovementNotation",
      "display" : "Measurement Improvement Notation",
      "definition" : "Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24042"
        }
      ],
      "concept" : [
        {
          "code" : "DecrIsImp",
          "display" : "Decreased score indicates improvement",
          "definition" : "Improvement is indicated as a decrease in the score or measurement (e.g. Lower score indicates better quality)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "24044"
            }
          ]
        },
        {
          "code" : "IncrIsImp",
          "display" : "Increased score indicates improvement",
          "definition" : "Improvement is indicated as an increase in the score or measurement (e.g. Higher score indicates better quality)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "24043"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ObservationMeasureScoring",
      "display" : "ObservationMeasureScoring",
      "definition" : "Observation values used to indicate the type of scoring (e.g. proportion, ratio) used by a health quality measure.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23037"
        }
      ],
      "concept" : [
        {
          "code" : "COHORT",
          "display" : "cohort measure scoring",
          "definition" : "A measure in which either short-term cross-section or long-term longitudinal analysis is performed over a group of subjects defined by a set of common properties or defining characteristics (e.g., Male smokers between the ages of 40 and 50 years, exposure to treatment, exposure duration).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23553"
            }
          ]
        },
        {
          "code" : "CONTVAR",
          "display" : "continuous variable measure scoring",
          "definition" : "A measure score in which each individual value for the measure can fall anywhere along a continuous scale (e.g., mean time to thrombolytics which aggregates the time in minutes from a case presenting with chest pain to the time of administration of thrombolytics).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23038"
            }
          ]
        },
        {
          "code" : "PROPOR",
          "display" : "proportion measure scoring",
          "definition" : "A score derived by dividing the number of cases that meet a criterion for quality (the numerator) by the number of eligible cases within a given time frame (the denominator) where the numerator cases are a subset of the denominator cases (e.g., percentage of eligible women with a mammogram performed in the last year).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23039"
            }
          ]
        },
        {
          "code" : "RATIO",
          "display" : "ratio measure scoring",
          "definition" : "A score that may have a value of zero or greater that is derived by dividing a count of one type of data by a count of another type of data (e.g., the number of patients with central lines who develop infection divided by the number of central line days).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23040"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ObservationMeasureType",
      "display" : "ObservationMeasureType",
      "definition" : "Observation values used to indicate what kind of health quality measure is used.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23041"
        }
      ],
      "concept" : [
        {
          "code" : "COMPOSITE",
          "display" : "composite measure type",
          "definition" : "A measure that is composed from one or more other measures and indicates an overall summary of those measures.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23650"
            }
          ]
        },
        {
          "code" : "EFFICIENCY",
          "display" : "efficiency measure type",
          "definition" : "A measure related to the efficiency of medical treatment.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23652"
            }
          ]
        },
        {
          "code" : "EXPERIENCE",
          "display" : "experience measure type",
          "definition" : "A measure related to the level of patient engagement or patient experience of care.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23653"
            }
          ]
        },
        {
          "code" : "OUTCOME",
          "display" : "outcome measure type",
          "definition" : "A measure that indicates the result of the performance (or non-performance) of a function or process.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23042"
            }
          ],
          "concept" : [
            {
              "code" : "INTERM-OM",
              "display" : "intermediate outcome measure type",
              "definition" : "A measure that evaluates the change over time of a physiologic state observable that is associated with a specific long-term health outcome.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23862"
                }
              ]
            },
            {
              "code" : "PRO-PM",
              "display" : "patient reported outcome measure type",
              "definition" : "A measure that is a comparison of patient reported outcomes for a single or multiple patients collected via an instrument specifically designed to obtain input directly from patients.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23861"
                }
              ]
            }
          ]
        },
        {
          "code" : "PROCESS",
          "display" : "process measure type",
          "definition" : "A measure which focuses on a process which leads to a certain outcome, meaning that a scientific basis exists for believing that the process, when executed well, will increase the probability of achieving a desired outcome.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23043"
            }
          ],
          "concept" : [
            {
              "code" : "APPROPRIATE",
              "display" : "appropriate use process measure",
              "definition" : "A measure that assesses the use of one or more processes where the expected health benefit exceeds the expected negative consequences.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23863"
                }
              ]
            }
          ]
        },
        {
          "code" : "RESOURCE",
          "display" : "resource use measure type",
          "definition" : "A measure related to the extent of use of clinical resources or cost of care.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23651"
            }
          ]
        },
        {
          "code" : "STRUCTURE",
          "display" : "structure measure type",
          "definition" : "A measure related to the structure of patient care.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23654"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ObservationPopulationInclusion",
      "display" : "ObservationPopulationInclusion",
      "definition" : "Observation values used to assert various populations that a subject falls into.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2013-07-26"
        },
        {
          "code" : "internalId",
          "valueCode" : "23044"
        }
      ],
      "concept" : [
        {
          "code" : "DENEX",
          "display" : "denominator exclusions",
          "definition" : "Patients who should be removed from the eMeasure population and denominator before determining if numerator criteria are met. Denominator exclusions are used in proportion and ratio measures to help narrow the denominator.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23442"
            }
          ]
        },
        {
          "code" : "DENEXCEP",
          "display" : "denominator exceptions",
          "definition" : "Denominator exceptions are those conditions that should remove a patient, procedure or unit of measurement from the denominator only if the numerator criteria are not met. Denominator exceptions allow for adjustment of the calculated score for those providers with higher risk populations. Denominator exceptions are used only in proportion eMeasures. They are not appropriate for ratio or continuous variable eMeasures. Denominator exceptions allow for the exercise of clinical judgment and should be specifically defined where capturing the information in a structured manner fits the clinical workflow. Generic denominator exception reasons used in proportion eMeasures fall into three general categories:\r\n\r\n *  Medical reasons\r\n *  Patient reasons\r\n *  System reasons",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23046"
            }
          ]
        },
        {
          "code" : "DENOM",
          "display" : "denominator",
          "definition" : "It can be the same as the initial patient population or a subset of the initial patient population to further constrain the population for the purpose of the eMeasure. Different measures within an eMeasure set may have different Denominators. Continuous Variable eMeasures do not have a Denominator, but instead define a Measure Population.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23045"
            }
          ]
        },
        {
          "code" : "IP",
          "display" : "initial population",
          "definition" : "The initial population refers to all entities to be evaluated by a specific quality measure who share a common set of specified characteristics within a specific measurement set to which a given measure belongs.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23528"
            }
          ],
          "concept" : [
            {
              "code" : "IPP",
              "display" : "initial patient population",
              "definition" : "The initial patient population refers to all patients to be evaluated by a specific quality measure who share a common set of specified characteristics within a specific measurement set to which a given measure belongs. Details often include information based upon specific age groups, diagnoses, diagnostic and procedure codes, and enrollment periods.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "deprecated"
                },
                {
                  "code" : "deprecationDate",
                  "valueDateTime" : "2013-07-26"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23047"
                }
              ]
            }
          ]
        },
        {
          "code" : "MSRPOPL",
          "display" : "measure population",
          "definition" : "Measure population is used only in continuous variable eMeasures. It is a narrative description of the eMeasure population. (e.g., all patients seen in the Emergency Department during the measurement period).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23048"
            }
          ]
        },
        {
          "code" : "NUMER",
          "display" : "numerator",
          "definition" : "Numerators are used in proportion and ratio eMeasures. In proportion measures the numerator criteria are the processes or outcomes expected for each patient, procedure, or other unit of measurement defined in the denominator. In ratio measures the numerator is related, but not directly derived from the denominator (e.g., a numerator listing the number of central line blood stream infections and a denominator indicating the days per thousand of central line usage in a specific time period).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23049"
            }
          ]
        },
        {
          "code" : "NUMEX",
          "display" : "numerator exclusions",
          "definition" : "Numerator Exclusions are used only in ratio eMeasures to define instances that should not be included in the numerator data. (e.g., if the number of central line blood stream infections per 1000 catheter days were to exclude infections with a specific bacterium, that bacterium would be listed as a numerator exclusion.)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2013-07-26"
            },
            {
              "code" : "internalId",
              "valueCode" : "23443"
            }
          ]
        }
      ]
    },
    {
      "code" : "_PartialCompletionScale",
      "display" : "PartialCompletionScale",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21099"
        }
      ],
      "concept" : [
        {
          "code" : "G",
          "display" : "Great extent",
          "definition" : "Value for Act.partialCompletionCode attribute that implies 81-99% completion",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18126"
            }
          ]
        },
        {
          "code" : "LE",
          "display" : "Large extent",
          "definition" : "Value for Act.partialCompletionCode attribute that implies 61-80% completion",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18125"
            }
          ]
        },
        {
          "code" : "ME",
          "display" : "Medium extent",
          "definition" : "Value for Act.partialCompletionCode attribute that implies 41-60% completion",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18124"
            }
          ]
        },
        {
          "code" : "MI",
          "display" : "Minimal extent",
          "definition" : "Value for Act.partialCompletionCode attribute that implies 1-20% completion",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18122"
            }
          ]
        },
        {
          "code" : "N",
          "display" : "None",
          "definition" : "Value for Act.partialCompletionCode attribute that implies 0% completion",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18121"
            }
          ]
        },
        {
          "code" : "S",
          "display" : "Some extent",
          "definition" : "Value for Act.partialCompletionCode attribute that implies 21-40% completion",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18123"
            }
          ]
        }
      ]
    },
    {
      "code" : "_SecurityObservationValue",
      "display" : "SecurityObservationValue",
      "definition" : "Observation values used to indicate security observation metadata.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23483"
        }
      ],
      "concept" : [
        {
          "code" : "_SECCATOBV",
          "display" : "security category",
          "definition" : "Abstract security observation values used to indicate security category metadata.\r\n\r\n**Examples:** Codes conveying:\r\n\r\n *  privacy law\r\n *  information sensitivity\r\n *  consent directive types",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23485"
            }
          ]
        },
        {
          "code" : "_SECCLASSOBV",
          "display" : "security classification",
          "definition" : "Abstract security observation values used to indicate security classification metadata.\r\n\r\n**Examples:** Confidentiality Codes",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23484"
            }
          ]
        },
        {
          "code" : "_SECCONOBV",
          "display" : "security control",
          "definition" : "Abstract security observation values used to indicate security control metadata.\r\n\r\n**Examples:** Codes conveying dissemination controls, information handling caveats, purpose of use, refrain policies, and obligations to which custodians and information receivers must comply.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23486"
            }
          ]
        },
        {
          "code" : "_SECINTOBV",
          "display" : "security integrity",
          "definition" : "Abstract security observation values used to indicate security integrity metadata.\r\n\r\n**Examples:** Codes conveying integrity status, integrity confidence, and provenance.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23487"
            }
          ],
          "concept" : [
            {
              "code" : "_SECALTINTOBV",
              "display" : "alteration integrity",
              "definition" : "Abstract security metadata observation values used to indicate mechanism used for authorized alteration of an IT resource (data, information object, service, or system capability)",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23497"
                }
              ],
              "concept" : [
                {
                  "code" : "ABSTRED",
                  "display" : "abstracted",
                  "definition" : "Security metadata observation values used to indicate the use of a more abstract version of the content, e.g., replacing exact value of an age or date field with a range, or remove the left digits of a credit card number or SSN.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23498"
                    }
                  ]
                },
                {
                  "code" : "AGGRED",
                  "display" : "aggregated",
                  "definition" : "Security metadata observation values used to indicate the use of an algorithmic combination of actual values with the result of an aggregate function, e.g., average, sum, or count in order to limit disclosure of an IT resource (data, information object, service, or system capability) to the minimum necessary.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23499"
                    }
                  ]
                },
                {
                  "code" : "ANONYED",
                  "display" : "anonymized",
                  "definition" : "Security metadata observation value conveying the alteration integrity of an IT resource (data, information object, service, or system capability) by used to indicate the mechanism by which software systems can strip portions of the resource that could allow the identification of the source of the information or the information subject. No key to relink the data is retained.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23500"
                    }
                  ]
                },
                {
                  "code" : "MAPPED",
                  "display" : "mapped",
                  "definition" : "Security metadata observation value used to indicate that the IT resource semantic content has been transformed from one encoding to another.\r\n\r\n*Usage Note:* \"MAP\" code does not indicate the semantic fidelity of the transformed content.\r\n\r\nTo indicate semantic fidelity for maps of HL7 to other code systems, this security alteration integrity observation may be further specified using an Act valued with Value Set: MapRelationship (2.16.840.1.113883.1.11.11052).\r\n\r\nSemantic fidelity of the mapped IT Resource may also be indicated using a SecurityIntegrityConfidenceObservation.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23501"
                    }
                  ]
                },
                {
                  "code" : "MASKED",
                  "display" : "masked",
                  "definition" : "Security metadata observation value conveying the alteration integrity of an IT resource (data, information object, service, or system capability) by indicating the mechanism by which software systems can make data unintelligible (that is, as unreadable and unusable by algorithmically transforming plaintext into ciphertext) such that it can only be accessed or used by authorized users. An authorized user may be provided a key to decrypt per license or \"shared secret\".\r\n\r\n*Usage Note:* \"MASKED\" may be used, per applicable policy, as a flag to indicate to a user or receiver that some portion of an IT resource has been further encrypted, and may be accessed only by an authorized user or receiver to which a decryption key is provided.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23502"
                    }
                  ]
                },
                {
                  "code" : "PSEUDED",
                  "display" : "pseudonymized",
                  "definition" : "Security metadata observation value conveying the alteration integrity of an IT resource (data, information object, service, or system capability), by indicating the mechanism by which software systems can strip portions of the resource that could allow the identification of the source of the information or the information subject. Custodian may retain a key to relink data necessary to reidentify the information subject.\r\n\r\n*Rationale:* Personal data which has been processed to make it impossible to know whose data it is. Used particularly for secondary use of health data. In some cases, it may be possible for authorized individuals to restore the identity of the individual, e.g.,for public health case management. Based on ISO/TS 25237:2008 Health informatics-Pseudonymization",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23503"
                    }
                  ]
                },
                {
                  "code" : "REDACTED",
                  "display" : "redacted",
                  "definition" : "Security metadata observation value used to indicate the mechanism by which software systems can filter an IT resource (data, information object, service, or system capability) to remove any portion of the resource that is not authorized to be access, used, or disclosed.\r\n\r\n*Usage Note:* \"REDACTED\" may be used, per applicable policy, as a flag to indicate to a user or receiver that some portion of an IT resource has filtered and not included in the content accessed or received.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23504"
                    }
                  ]
                },
                {
                  "code" : "SUBSETTED",
                  "display" : "subsetted",
                  "definition" : "Metadata observation used to indicate that some information has been removed from the source object when the view this object contains was constructed because of configuration options when the view was created. The content may not be suitable for use as the basis of a record update\r\n\r\n*Usage Note:* This is not suitable to be used when information is removed for security reasons - see the code REDACTED for this use.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23730"
                    }
                  ]
                },
                {
                  "code" : "SYNTAC",
                  "display" : "syntactic transform",
                  "definition" : "Security metadata observation value used to indicate that the IT resource syntax has been transformed from one syntactical representation to another.\r\n\r\n*Usage Note:* \"SYNTAC\" code does not indicate the syntactical correctness of the syntactically transformed IT resource.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23505"
                    }
                  ]
                },
                {
                  "code" : "TRSLT",
                  "display" : "translated",
                  "definition" : "Security metadata observation value used to indicate that the IT resource has been translated from one human language to another.\r\n\r\n*Usage Note:* \"TRSLT\" does not indicate the fidelity of the translation or the languages translated.\r\n\r\nThe fidelity of the IT Resource translation may be indicated using a SecurityIntegrityConfidenceObservation.\r\n\r\nTo indicate languages, use the Value Set:HumanLanguage (2.16.840.1.113883.1.11.11526)",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23506"
                    }
                  ]
                },
                {
                  "code" : "VERSIONED",
                  "display" : "versioned",
                  "definition" : "Security metadata observation value conveying the alteration integrity of an IT resource (data, information object, service, or system capability) which indicates that the resource only retains versions of an IT resource for access and use per applicable policy\r\n\r\n*Usage Note:* When this code is used, expectation is that the system has removed historical versions of the data that falls outside the time period deemed to be the effective time of the applicable version.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23507"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SECDATINTOBV",
              "display" : "data integrity",
              "definition" : "Abstract security observation values used to indicate data integrity metadata.\r\n\r\n**Examples:** Codes conveying the mechanism used to preserve the accuracy and consistency of an IT resource such as a digital signature and a cryptographic hash function.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23494"
                }
              ],
              "concept" : [
                {
                  "code" : "CRYTOHASH",
                  "display" : "cryptographic hash function",
                  "definition" : "Security metadata observation value used to indicate the mechanism by which software systems can establish that data was not modified in transit.\r\n\r\n*Rationale:* This definition is intended to align with the ISO 22600-2 3.3.19 definition of cryptographic checkvalue: Information which is derived by performing a cryptographic transformation (see cryptography) on the data unit. The derivation of the checkvalue may be performed in one or more steps and is a result of a mathematical function of the key and a data unit. It is usually used to check the integrity of a data unit.\r\n\r\n**Examples:** \r\n\r\n *  SHA-1\r\n *  SHA-2 (Secure Hash Algorithm)",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23495"
                    }
                  ]
                },
                {
                  "code" : "DIGSIG",
                  "display" : "digital signature",
                  "definition" : "Security metadata observation value used to indicate the mechanism by which software systems use digital signature to establish that data has not been modified.\r\n\r\n*Rationale:* This definition is intended to align with the ISO 22600-2 3.3.26 definition of digital signature: Data appended to, or a cryptographic transformation (see cryptography) of, a data unit that allows a recipient of the data unit to prove the source and integrity of the data unit and protect against forgery e.g., by the recipient.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23496"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SECINTCONOBV",
              "display" : "integrity confidence",
              "definition" : "Abstract security observation value used to indicate integrity confidence metadata.\r\n\r\n**Examples:** Codes conveying the level of reliability and trustworthiness of an IT resource.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23489"
                }
              ],
              "concept" : [
                {
                  "code" : "HRELIABLE",
                  "display" : "highly reliable",
                  "definition" : "Security metadata observation value used to indicate that the veracity or trustworthiness of an IT resource (data, information object, service, or system capability) for a specified purpose of use is perceived to be or deemed by policy to be very high.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23490"
                    }
                  ]
                },
                {
                  "code" : "RELIABLE",
                  "display" : "reliable",
                  "definition" : "Security metadata observation value used to indicate that the veracity or trustworthiness of an IT resource (data, information object, service, or system capability) for a specified purpose of use is perceived to be or deemed by policy to be adequate.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23491"
                    }
                  ]
                },
                {
                  "code" : "UNCERTREL",
                  "display" : "uncertain reliability",
                  "definition" : "Security metadata observation value used to indicate that the veracity or trustworthiness of an IT resource (data, information object, service, or system capability) for a specified purpose of use is perceived to be or deemed by policy to be uncertain.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23492"
                    }
                  ]
                },
                {
                  "code" : "UNRELIABLE",
                  "display" : "unreliable",
                  "definition" : "Security metadata observation value used to indicate that the veracity or trustworthiness of an IT resource (data, information object, service, or system capability) for a specified purpose of use is perceived to be or deemed by policy to be inadequate.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23493"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SECINTPRVOBV",
              "display" : "provenance",
              "definition" : "Abstract security metadata observation value used to indicate the provenance of an IT resource (data, information object, service, or system capability).\r\n\r\n**Examples:** Codes conveying the provenance metadata about the entity reporting an IT resource.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23508"
                }
              ],
              "concept" : [
                {
                  "code" : "_SECINTPRVABOBV",
                  "display" : "provenance asserted by",
                  "definition" : "Abstract security provenance metadata observation value used to indicate the entity that asserted an IT resource (data, information object, service, or system capability).\r\n\r\n**Examples:** Codes conveying the provenance metadata about the entity asserting the resource.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23518"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "CLINAST",
                      "display" : "clinician asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a clinician.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23519"
                        }
                      ]
                    },
                    {
                      "code" : "DEVAST",
                      "display" : "device asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a device.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23523"
                        }
                      ]
                    },
                    {
                      "code" : "HCPAST",
                      "display" : "healthcare professional asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a healthcare professional.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23520"
                        }
                      ]
                    },
                    {
                      "code" : "PACQAST",
                      "display" : "patient acquaintance asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a patient acquaintance.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23526"
                        }
                      ]
                    },
                    {
                      "code" : "PATAST",
                      "display" : "patient asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a patient.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23524"
                        }
                      ]
                    },
                    {
                      "code" : "PAYAST",
                      "display" : "payer asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a payer.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23522"
                        }
                      ]
                    },
                    {
                      "code" : "PROAST",
                      "display" : "professional asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a professional.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23521"
                        }
                      ]
                    },
                    {
                      "code" : "SDMAST",
                      "display" : "substitute decision maker asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was asserted by a substitute decision maker.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23525"
                        }
                      ]
                    },
                    {
                      "code" : "AIAST",
                      "display" : "Artificial Intelligence asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, or information object) was asserted by a Artificial Intelligence (e.g. Clinical Decision Support, Machine Learning, Algorithm).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "123525"
                        }
                      ]
                    },
                    {
                      "code" : "DICTAST",
                      "display" : "Dictation asserted",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, or information object) was asserted by a Dictation algorithm transforming human communications (e.g. speech).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "223525"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_SECINTPRVRBOBV",
                  "display" : "provenance reported by",
                  "definition" : "Abstract security provenance metadata observation value used to indicate the entity that reported the resource (data, information object, service, or system capability).\r\n\r\n**Examples:** Codes conveying the provenance metadata about the entity reporting an IT resource.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23509"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "CLINRPT",
                      "display" : "clinician reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a clinician.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23510"
                        }
                      ]
                    },
                    {
                      "code" : "DEVRPT",
                      "display" : "device reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a device.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23514"
                        }
                      ]
                    },
                    {
                      "code" : "HCPRPT",
                      "display" : "healthcare professional reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a healthcare professional.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23511"
                        }
                      ]
                    },
                    {
                      "code" : "PACQRPT",
                      "display" : "patient acquaintance reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a patient acquaintance.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23517"
                        }
                      ]
                    },
                    {
                      "code" : "PATRPT",
                      "display" : "patient reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a patient.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23515"
                        }
                      ]
                    },
                    {
                      "code" : "PAYRPT",
                      "display" : "payer reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a payer.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23513"
                        }
                      ]
                    },
                    {
                      "code" : "PRORPT",
                      "display" : "professional reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a professional.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23512"
                        }
                      ]
                    },
                    {
                      "code" : "SDMRPT",
                      "display" : "substitute decision maker reported",
                      "definition" : "Security provenance metadata observation value used to indicate that an IT resource (data, information object, service, or system capability) was reported by a substitute decision maker.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23516"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SECINTSTOBV",
              "display" : "integrity status",
              "definition" : "Abstract security observation values used to indicate integrity status metadata.\r\n\r\n**Examples:** Codes, such as those in the HL7 DocumentClassification code system conveying the workflow status of resource as authenticated, legally authenticated, and in progress.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23488"
                }
              ]
            }
          ]
        },
        {
          "code" : "SECTRSTOBV",
          "display" : "security trust observation",
          "definition" : "Observation value used to indicate aspects of trust applicable to an IT resource (data, information object, service, or system capability).",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23672"
            }
          ],
          "concept" : [
            {
              "code" : "TRSTACCRDOBV",
              "display" : "trust accreditation observation",
              "definition" : "Values for security trust accreditation metadata observation made about the formal declaration by an authority or neutral third party that validates the technical, security, trust, and business practice conformance of Trust Agents to facilitate security, interoperability, and trust among participants within a security domain or trust framework.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23673"
                }
              ]
            },
            {
              "code" : "TRSTAGREOBV",
              "display" : "trust agreement observation",
              "definition" : "Values for security trust agreement metadata observation made about privacy and security requirements with which a security domain must comply. \\[ISO IEC 10181-1\\] \\[ISO IEC 10181-1\\]",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23674"
                }
              ]
            },
            {
              "code" : "TRSTCERTOBV",
              "display" : "trust certificate observation",
              "definition" : "Values for security trust certificate metadata observation made about a set of security-relevant data issued by a security authority or trusted third party, together with security information which is used to provide the integrity and data origin authentication services for an IT resource (data, information object, service, or system capability). \\[Based on ISO IEC 10181-1\\]\r\n\r\nFor example, a Certificate Policy (CP), which is a named set of rules that indicates the applicability of a certificate to a particular community and/or class of application with common security requirements. A particular Certificate Policy might indicate the applicability of a type of certificate to the authentication of electronic data interchange transactions for the trading of goods within a given price range. Another example is Cross Certification with Federal Bridge.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23675"
                }
              ]
            },
            {
              "code" : "TRSTFWKOBV",
              "display" : "none supplied 5",
              "definition" : "Values for security trust framework metadata observation made about a complete set of contracts, regulations or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. \\[Kantara Initiative\\]",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23717"
                }
              ]
            },
            {
              "code" : "TRSTLOAOBV",
              "display" : "trust assurance observation",
              "definition" : "Values for security trust assurance metadata observation made about the digital quality or reliability of a trust assertion, activity, capability, information exchange, mechanism, process, or protocol.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23676"
                }
              ],
              "concept" : [
                {
                  "code" : "LOAAN",
                  "display" : "authentication level of assurance value",
                  "definition" : "The value assigned as the indicator of the digital quality or reliability of the verification and validation process used to verify the claimed identity of an entity by securely associating an identifier and its authenticator. \\[Based on ISO 7498-2\\]\r\n\r\nFor example, the degree of confidence in the vetting process used to establish the identity of the individual to whom the credential was issued, and 2) the degree of confidence that the individual who uses the credential is the individual to whom the credential was issued. \\[OMB M-04-04 E-Authentication Guidance for Federal Agencies\\]",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23677"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOAAN1",
                      "display" : "low authentication level of assurance",
                      "definition" : "Indicator of low digital quality or reliability of the digital reliability of the verification and validation process used to verify the claimed identity of an entity by securely associating an identifier and its authenticator. \\[Based on ISO 7498-2\\]\r\n\r\nThe degree of confidence in the vetting process used to establish the identity of the individual to whom the credential was issued, and 2) the degree of confidence that the individual who uses the credential is the individual to whom the credential was issued. \\[OMB M-04-04 E-Authentication Guidance for Federal Agencies\\]\r\n\r\nLow authentication level of assurance indicates that the relying party may have little or no confidence in the asserted identity's validity. Level 1 requires little or no confidence in the asserted identity. No identity proofing is required at this level, but the authentication mechanism should provide some assurance that the same claimant is accessing the protected transaction or data. A wide range of available authentication technologies can be employed and any of the token methods of Levels 2, 3, or 4, including Personal Identification Numbers (PINs), may be used. To be authenticated, the claimant must prove control of the token through a secure authentication protocol. At Level 1, long-term shared authentication secrets may be revealed to verifiers. Assertions issued about claimants as a result of a successful authentication are either cryptographically authenticated by relying parties (using approved methods) or are obtained directly from a trusted party via a secure authentication protocol. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23678"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAN2",
                      "display" : "basic authentication level of assurance",
                      "definition" : "Indicator of basic digital quality or reliability of the digital reliability of the verification and validation process used to verify the claimed identity of an entity by securely associating an identifier and its authenticator. \\[Based on ISO 7498-2\\]\r\n\r\nThe degree of confidence in the vetting process used to establish the identity of the individual to whom the credential was issued, and 2) the degree of confidence that the individual who uses the credential is the individual to whom the credential was issued. \\[OMB M-04-04 E-Authentication Guidance for Federal Agencies\\]\r\n\r\nBasic authentication level of assurance indicates that the relying party may have some confidence in the asserted identity's validity. Level 2 requires confidence that the asserted identity is accurate. Level 2 provides for single-factor remote network authentication, including identity-proofing requirements for presentation of identifying materials or information. A wide range of available authentication technologies can be employed, including any of the token methods of Levels 3 or 4, as well as passwords. Successful authentication requires that the claimant prove through a secure authentication protocol that the claimant controls the token. Eavesdropper, replay, and online guessing attacks are prevented. Long-term shared authentication secrets, if used, are never revealed to any party except the claimant and verifiers operated by the CSP; however, session (temporary) shared secrets may be provided to independent verifiers by the CSP. Approved cryptographic techniques are required. Assertions issued about claimants as a result of a successful authentication are either cryptographically authenticated by relying parties (using approved methods) or are obtained directly from a trusted party via a secure authentication protocol. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23679"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAN3",
                      "display" : "medium authentication level of assurance",
                      "definition" : "Indicator of medium digital quality or reliability of the digital reliability of verification and validation of the process used to verify the claimed identity of an entity by securely associating an identifier and its authenticator. \\[Based on ISO 7498-2\\]\r\n\r\nThe degree of confidence in the vetting process used to establish the identity of the individual to whom the credential was issued, and 2) the degree of confidence that the individual who uses the credential is the individual to whom the credential was issued. \\[OMB M-04-04 E-Authentication Guidance for Federal Agencies\\]\r\n\r\nMedium authentication level of assurance indicates that the relying party may have high confidence in the asserted identity's validity. Level 3 is appropriate for transactions that need high confidence in the accuracy of the asserted identity. Level 3 provides multifactor remote network authentication. At this level, identity-proofing procedures require verification of identifying materials and information. Authentication is based on proof of possession of a key or password through a cryptographic protocol. Cryptographic strength mechanisms should protect the primary authentication token (a cryptographic key) against compromise by the protocol threats, including eavesdropper, replay, online guessing, verifier impersonation, and man-in-the-middle attacks. A minimum of two authentication factors is required. Three kinds of tokens may be used:\r\n\r\n *  \"soft\" cryptographic token, which has the key stored on a general-purpose computer,\r\n *  \"hard\" cryptographic token, which has the key stored on a special hardware device, and\r\n *  \"one-time password\" device token, which has symmetric key stored on a personal hardware device that is a cryptographic module validated at FIPS 140-2 Level 1 or higher. Validation testing of cryptographic modules and algorithms for conformance to Federal Information Processing Standard (FIPS) 140-2, Security Requirements for Cryptographic Modules, is managed by NIST.\r\n\r\nAuthentication requires that the claimant prove control of the token through a secure authentication protocol. The token must be unlocked with a password or biometric representation, or a password must be used in a secure authentication protocol, to establish two-factor authentication. Long-term shared authentication secrets, if used, are never revealed to any party except the claimant and verifiers operated directly by the CSP; however, session (temporary) shared secrets may be provided to independent verifiers by the CSP. Approved cryptographic techniques are used for all operations. Assertions issued about claimants as a result of a successful authentication are either cryptographically authenticated by relying parties (using approved methods) or are obtained directly from a trusted party via a secure authentication protocol. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23680"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAN4",
                      "display" : "high authentication level of assurance",
                      "definition" : "Indicator of high digital quality or reliability of the digital reliability of the verification and validation process used to verify the claimed identity of an entity by securely associating an identifier and its authenticator. \\[Based on ISO 7498-2\\]\r\n\r\nThe degree of confidence in the vetting process used to establish the identity of the individual to whom the credential was issued, and 2) the degree of confidence that the individual who uses the credential is the individual to whom the credential was issued. \\[OMB M-04-04 E-Authentication Guidance for Federal Agencies\\]\r\n\r\nHigh authentication level of assurance indicates that the relying party may have very high confidence in the asserted identity's validity. Level 4 is for transactions that need very high confidence in the accuracy of the asserted identity. Level 4 provides the highest practical assurance of remote network authentication. Authentication is based on proof of possession of a key through a cryptographic protocol. This level is similar to Level 3 except that only â€œhardâ€? cryptographic tokens are allowed, cryptographic module validation requirements are strengthened, and subsequent critical data transfers must be authenticated via a key that is bound to the authentication process. The token should be a hardware cryptographic module validated at FIPS 140-2 Level 2 or higher overall with at least FIPS 140-2 Level 3 physical security. This level requires a physical token, which cannot readily be copied, and operator authentication at Level 2 and higher, and ensures good, two-factor remote authentication.\r\n\r\nLevel 4 requires strong cryptographic authentication of all parties and all sensitive data transfers between the parties. Either public key or symmetric key technology may be used. Authentication requires that the claimant prove through a secure authentication protocol that the claimant controls the token. Eavesdropper, replay, online guessing, verifier impersonation, and man-in-the-middle attacks are prevented. Long-term shared authentication secrets, if used, are never revealed to any party except the claimant and verifiers operated directly by the CSP; however, session (temporary) shared secrets may be provided to independent verifiers by the CSP. Strong approved cryptographic techniques are used for all operations. All sensitive data transfers are cryptographically authenticated using keys bound to the authentication process. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23681"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOAAP",
                  "display" : "authentication process level of assurance value",
                  "definition" : "The value assigned as the indicator of the digital quality or reliability of a defined sequence of messages between a Claimant and a Verifier that demonstrates that the Claimant has possession and control of a valid token to establish his/her identity, and optionally, demonstrates to the Claimant that he or she is communicating with the intended Verifier. \\[Based on NIST SP 800-63-2\\]",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23682"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOAAP1",
                      "display" : "low authentication process level of assurance",
                      "definition" : "Indicator of the low digital quality or reliability of a defined sequence of messages between a Claimant and a Verifier that demonstrates that the Claimant has possession and control of a valid token to establish his/her identity, and optionally, demonstrates to the Claimant that he or she is communicating with the intended Verifier. \\[Based on NIST SP 800-63-2\\]\r\n\r\nLow authentication process level of assurance indicates that (1) long-term shared authentication secrets may be revealed to verifiers; and (2) assertions and assertion references require protection from manufacture/modification and reuse attacks. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23683"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAP2",
                      "display" : "basic authentication process level of assurance",
                      "definition" : "Indicator of the basic digital quality or reliability of a defined sequence of messages between a Claimant and a Verifier that demonstrates that the Claimant has possession and control of a valid token to establish his/her identity, and optionally, demonstrates to the Claimant that he or she is communicating with the intended Verifier. \\[Based on NIST SP 800-63-2\\]\r\n\r\nBasic authentication process level of assurance indicates that long-term shared authentication secrets are never revealed to any other party except Credential Service Provider (CSP). Sessions (temporary) shared secrets may be provided to independent verifiers by CSP. Long-term shared authentication secrets, if used, are never revealed to any other party except Verifiers operated by the Credential Service Provider (CSP); however, session (temporary) shared secrets may be provided to independent Verifiers by the CSP. In addition to Level 1 requirements, assertions are resistant to disclosure, redirection, capture and substitution attacks. Approved cryptographic techniques are required. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23684"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAP3",
                      "display" : "medium authentication process level of assurance",
                      "definition" : "Indicator of the medium digital quality or reliability of a defined sequence of messages between a Claimant and a Verifier that demonstrates that the Claimant has possession and control of a valid token to establish his/her identity, and optionally, demonstrates to the Claimant that he or she is communicating with the intended Verifier. \\[Based on NIST SP 800-63-2\\]\r\n\r\nMedium authentication process level of assurance indicates that the token can be unlocked with password, biometric, or uses a secure multi-token authentication protocol to establish two-factor authentication. Long-term shared authentication secrets are never revealed to any party except the Claimant and Credential Service Provider (CSP).\r\n\r\nAuthentication requires that the Claimant prove, through a secure authentication protocol, that he or she controls the token. The Claimant unlocks the token with a password or biometric, or uses a secure multi-token authentication protocol to establish two-factor authentication (through proof of possession of a physical or software token in combination with some memorized secret knowledge). Long-term shared authentication secrets, if used, are never revealed to any party except the Claimant and Verifiers operated directly by the CSP; however, session (temporary) shared secrets may be provided to independent Verifiers by the CSP. In addition to Level 2 requirements, assertions are protected against repudiation by the Verifier.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23685"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAP4",
                      "display" : "high authentication process level of assurance",
                      "definition" : "Indicator of the high digital quality or reliability of a defined sequence of messages between a Claimant and a Verifier that demonstrates that the Claimant has possession and control of a valid token to establish his/her identity, and optionally, demonstrates to the Claimant that he or she is communicating with the intended Verifier. \\[Based on NIST SP 800-63-2\\]\r\n\r\nHigh authentication process level of assurance indicates all sensitive data transfer are cryptographically authenticated using keys bound to the authentication process. Level 4 requires strong cryptographic authentication of all communicating parties and all sensitive data transfers between the parties. Either public key or symmetric key technology may be used. Authentication requires that the Claimant prove through a secure authentication protocol that he or she controls the token. All protocol threats at Level 3 are required to be prevented at Level 4. Protocols shall also be strongly resistant to man-in-the-middle attacks. Long-term shared authentication secrets, if used, are never revealed to any party except the Claimant and Verifiers operated directly by the CSP; however, session (temporary) shared secrets may be provided to independent Verifiers by the CSP. Approved cryptographic techniques are used for all operations. All sensitive data transfers are cryptographically authenticated using keys bound to the authentication process. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23686"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOAAS",
                  "display" : "assertion level of assurance value",
                  "definition" : "The value assigned as the indicator of the high quality or reliability of the statement from a Verifier to a Relying Party (RP) that contains identity information about a Subscriber. Assertions may also contain verified attributes.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23687"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOAAS1",
                      "display" : "low assertion level of assurance",
                      "definition" : "Indicator of the low quality or reliability of the statement from a Verifier to a Relying Party (RP) that contains identity information about a Subscriber. Assertions may also contain verified attributes.\r\n\r\nAssertions and assertion references require protection from modification and reuse attacks. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23688"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAS2",
                      "display" : "basic assertion level of assurance",
                      "definition" : "Indicator of the basic quality or reliability of the statement from a Verifier to a Relying Party (RP) that contains identity information about a Subscriber. Assertions may also contain verified attributes.\r\n\r\nAssertions are resistant to disclosure, redirection, capture and substitution attacks. Approved cryptographic techniques are required for all assertion protocols. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23689"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAS3",
                      "display" : "medium assertion level of assurance",
                      "definition" : "Indicator of the medium quality or reliability of the statement from a Verifier to a Relying Party (RP) that contains identity information about a Subscriber. Assertions may also contain verified attributes.\r\n\r\nAssertions are protected against repudiation by the verifier. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23690"
                        }
                      ]
                    },
                    {
                      "code" : "LOAAS4",
                      "display" : "high assertion level of assurance",
                      "definition" : "Indicator of the high quality or reliability of the statement from a Verifier to a Relying Party (RP) that contains identity information about a Subscriber. Assertions may also contain verified attributes.\r\n\r\nStrongly resistant to man-in-the-middle attacks. \"Bearer\" assertions are not used. \"Holder-of-key\" assertions may be used. RP maintains records of the assertions. \\[Summary of the technical requirements specified in NIST SP 800-63 for the four levels of assurance defined by the December 2003, the Office of Management and Budget (OMB) issued Memorandum M-04-04, E-Authentication Guidance for Federal Agencies.\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23691"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOACM",
                  "display" : "token and credential management level of assurance value)",
                  "definition" : "Indicator of the digital quality or reliability of the activities performed by the Credential Service Provider (CSP) subsequent to electronic authentication registration, identity proofing and issuance activities to manage and safeguard the integrity of an issued credential and its binding to an identity. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23712"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOACM1",
                      "display" : "low token and credential management level of assurance",
                      "definition" : "Indicator of the low digital quality or reliability of the activities performed by the Credential Service Provider (CSP) subsequent to electronic authentication registration, identity proofing and issuance activities to manage and safeguard the integrity of an issued credential and its binding to an identity. Little or no confidence that an individual has maintained control over a token that has been entrusted to him or her and that that token has not been compromised. Characteristics include weak identity binding to tokens and plaintext passwords or secrets not transmitted across a network. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23713"
                        }
                      ]
                    },
                    {
                      "code" : "LOACM2",
                      "display" : "basic token and credential management level of assurance",
                      "definition" : "Indicator of the basic digital quality or reliability of the activities performed by the Credential Service Provider (CSP) subsequent to electronic authentication registration, identity proofing and issuance activities to manage and safeguard the integrity of an issued credential and its binding to an identity. Some confidence that an individual has maintained control over a token that has been entrusted to him or her and that that token has not been compromised. Characteristics include: Verification must prove claimant controls the token; token resists online guessing, replay, session hijacking, and eavesdropping attacks; and token is at least weakly resistant to man-in-the middle attacks. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23714"
                        }
                      ]
                    },
                    {
                      "code" : "LOACM3",
                      "display" : "medium token and credential management level of assurance",
                      "definition" : "Indicator of the medium digital quality or reliability of the activities performed by the Credential Service Provider (CSP) subsequent to electronic authentication registration, identity proofing and issuance activities to manage and safeguard the integrity of an issued credential and it's binding to an identity. High confidence that an individual has maintained control over a token that has been entrusted to him or her and that that token has not been compromised. Characteristics include: Ownership of token verifiable through security authentication protocol and credential management protects against verifier impersonation attacks. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23715"
                        }
                      ]
                    },
                    {
                      "code" : "LOACM4",
                      "display" : "high token and credential management level of assurance",
                      "definition" : "Indicator of the high digital quality or reliability of the activities performed by the Credential Service Provider (CSP) subsequent to electronic authentication registration, identity proofing and issuance activities to manage and safeguard the integrity of an issued credential and it's binding to an identity. Very high confidence that an individual has maintained control over a token that has been entrusted to him or her and that that token has not been compromised. Characteristics include: Verifier can prove control of token through a secure protocol; credential management supports strong cryptographic authentication of all communication parties. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23716"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOAID",
                  "display" : "identity proofing level of assurance",
                  "definition" : "Indicator of the quality or reliability in the process of ascertaining that an individual is who he or she claims to be.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23692"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOAID1",
                      "display" : "low identity proofing level of assurance",
                      "definition" : "Indicator of low digital quality or reliability in the process of ascertaining that an individual is who he or she claims to be. Requires that a continuity of identity be maintained but does not require identity proofing. \\[Based on Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23693"
                        }
                      ]
                    },
                    {
                      "code" : "LOAID2",
                      "display" : "basic identity proofing level of assurance",
                      "definition" : "Indicator of some digital quality or reliability in the process of ascertaining that that an individual is who he or she claims to be. Requires identity proofing via presentation of identifying material or information. \\[Based on Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23694"
                        }
                      ]
                    },
                    {
                      "code" : "LOAID3",
                      "display" : "medium identity proofing level of assurance",
                      "definition" : "Indicator of high digital quality or reliability in the process of ascertaining that an individual is who he or she claims to be. Requires identity proofing procedures for verification of identifying materials and information. \\[Based on Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23695"
                        }
                      ]
                    },
                    {
                      "code" : "LOAID4",
                      "display" : "high identity proofing level of assurance",
                      "definition" : "Indicator of high digital quality or reliability in the process of ascertaining that an individual is who he or she claims to be. Requires identity proofing procedures for verification of identifying materials and information. \\[Based on Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23696"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOANR",
                  "display" : "non-repudiation level of assurance value",
                  "definition" : "Indicator of the digital quality or reliability in the process of establishing proof of delivery and proof of origin. \\[Based on ISO 7498-2\\]",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23697"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOANR1",
                      "display" : "low non-repudiation level of assurance",
                      "definition" : "Indicator of low digital quality or reliability in the process of establishing proof of delivery and proof of origin. \\[Based on ISO 7498-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23698"
                        }
                      ]
                    },
                    {
                      "code" : "LOANR2",
                      "display" : "basic non-repudiation level of assurance",
                      "definition" : "Indicator of basic digital quality or reliability in the process of establishing proof of delivery and proof of origin. \\[Based on ISO 7498-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23699"
                        }
                      ]
                    },
                    {
                      "code" : "LOANR3",
                      "display" : "medium non-repudiation level of assurance",
                      "definition" : "Indicator of medium digital quality or reliability in the process of establishing proof of delivery and proof of origin. \\[Based on ISO 7498-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23700"
                        }
                      ]
                    },
                    {
                      "code" : "LOANR4",
                      "display" : "high non-repudiation level of assurance",
                      "definition" : "Indicator of high digital quality or reliability in the process of establishing proof of delivery and proof of origin. \\[Based on ISO 7498-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23701"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOARA",
                  "display" : "remote access level of assurance value",
                  "definition" : "Indicator of the digital quality or reliability of the information exchange between network-connected devices where the information cannot be reliably protected end-to-end by a single organization's security controls. \\[Based on NIST SP 800-63-2\\]",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23702"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOARA1",
                      "display" : "low remote access level of assurance",
                      "definition" : "Indicator of low digital quality or reliability of the information exchange between network-connected devices where the information cannot be reliably protected end-to-end by a single organization's security controls. \\[Based on NIST SP 800-63-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23703"
                        }
                      ]
                    },
                    {
                      "code" : "LOARA2",
                      "display" : "basic remote access level of assurance",
                      "definition" : "Indicator of basic digital quality or reliability of the information exchange between network-connected devices where the information cannot be reliably protected end-to-end by a single organization's security controls. \\[Based on NIST SP 800-63-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23704"
                        }
                      ]
                    },
                    {
                      "code" : "LOARA3",
                      "display" : "medium remote access level of assurance",
                      "definition" : "Indicator of medium digital quality or reliability of the information exchange between network-connected devices where the information cannot be reliably protected end-to-end by a single organization's security controls. \\[Based on NIST SP 800-63-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23705"
                        }
                      ]
                    },
                    {
                      "code" : "LOARA4",
                      "display" : "high remote access level of assurance",
                      "definition" : "Indicator of high digital quality or reliability of the information exchange between network-connected devices where the information cannot be reliably protected end-to-end by a single organization's security controls. \\[Based on NIST SP 800-63-2\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23706"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "LOATK",
                  "display" : "token level of assurance value",
                  "definition" : "Indicator of the digital quality or reliability of single and multi-token authentication. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23707"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "LOATK1",
                      "display" : "low token level of assurance",
                      "definition" : "Indicator of the low digital quality or reliability of single and multi-token authentication. Permits the use of any of the token methods of Levels 2, 3, or 4. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23708"
                        }
                      ]
                    },
                    {
                      "code" : "LOATK2",
                      "display" : "basic token level of assurance",
                      "definition" : "Indicator of the basic digital quality or reliability of single and multi-token authentication. Requires single factor authentication using memorized secret tokens, pre-registered knowledge tokens, look-up secret tokens, out of band tokens, or single factor one-time password devices. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23709"
                        }
                      ]
                    },
                    {
                      "code" : "LOATK3",
                      "display" : "medium token level of assurance",
                      "definition" : "Indicator of the medium digital quality or reliability of single and multi-token authentication. Requires two authentication factors. Provides multi-factor remote network authentication. Permits multi-factor software cryptographic token. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23710"
                        }
                      ]
                    },
                    {
                      "code" : "LOATK4",
                      "display" : "high token level of assurance",
                      "definition" : "Indicator of the high digital quality or reliability of single and multi-token authentication. Requires token that is a hardware cryptographic module validated at validated at Federal Information Processing Standard (FIPS) 140-2 Level 2 or higher overall with at least FIPS 140-2 Level 3 physical security. Level 4 token requirements can be met by using the PIV authentication key of a FIPS 201 compliant Personal Identity Verification (PIV) Card. \\[Electronic Authentication Guideline - Recommendations of the National Institute of Standards and Technology, NIST Special Publication 800-63-1, Dec 2011\\]",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23711"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "TRSTMECOBV",
              "display" : "none supplied 6",
              "definition" : "Values for security trust mechanism metadata observation made about a security architecture system component that supports enforcement of security policies.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23718"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_SeverityObservation",
      "display" : "SeverityObservation",
      "definition" : "Potential values for observations of severity.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21100"
        }
      ],
      "concept" : [
        {
          "code" : "H",
          "display" : "High",
          "definition" : "Indicates the condition may be life-threatening or has the potential to cause permanent injury.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "16644"
            }
          ]
        },
        {
          "code" : "L",
          "display" : "Low",
          "definition" : "Indicates the condition may result in some adverse consequences but is unlikely to substantially affect the situation of the subject.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "16646"
            }
          ]
        },
        {
          "code" : "M",
          "display" : "Moderate",
          "definition" : "Indicates the condition may result in noticable adverse adverse consequences but is unlikely to be life-threatening or cause permanent injury.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "16645"
            }
          ]
        }
      ]
    },
    {
      "code" : "_SubjectBodyPosition",
      "display" : "_SubjectBodyPosition",
      "definition" : "Contains codes for defining the observed, physical position of a subject, such as during an observation, assessment, collection of a specimen, etc. ECG waveforms and vital signs, such as blood pressure, are two examples where a general, observed position typically needs to be noted.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22917"
        }
      ],
      "concept" : [
        {
          "code" : "LLD",
          "display" : "left lateral decubitus",
          "definition" : "Lying on the left side.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22918"
            }
          ]
        },
        {
          "code" : "PRN",
          "display" : "prone",
          "definition" : "Lying with the front or ventral surface downward; lying face down.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22919"
            }
          ]
        },
        {
          "code" : "RLD",
          "display" : "right lateral decubitus",
          "definition" : "Lying on the right side.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22920"
            }
          ]
        },
        {
          "code" : "SFWL",
          "display" : "Semi-Fowler's",
          "definition" : "A semi-sitting position in bed with the head of the bed elevated approximately 45 degrees.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22921"
            }
          ]
        },
        {
          "code" : "SIT",
          "display" : "sitting",
          "definition" : "Resting the body on the buttocks, typically with upper torso erect or semi erect.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22922"
            }
          ]
        },
        {
          "code" : "STN",
          "display" : "standing",
          "definition" : "To be stationary, upright, vertical, on one's legs.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22923"
            }
          ]
        },
        {
          "code" : "SUP",
          "display" : "supine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22924"
            }
          ],
          "concept" : [
            {
              "code" : "RTRD",
              "display" : "reverse trendelenburg",
              "definition" : "Lying on the back, on an inclined plane, typically about 30-45 degrees with head raised and feet lowered.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22925"
                }
              ]
            },
            {
              "code" : "TRD",
              "display" : "trendelenburg",
              "definition" : "Lying on the back, on an inclined plane, typically about 30-45 degrees, with head lowered and feet raised.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22926"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_VerificationOutcomeValue",
      "display" : "verification outcome",
      "definition" : "Values for observations of verification act results\r\n\r\n**Examples:** Verified, not verified, verified with warning.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21906"
        }
      ],
      "concept" : [
        {
          "code" : "ACT",
          "display" : "active coverage",
          "definition" : "**Definition:** Coverage is in effect for healthcare service(s) and/or product(s).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22213"
            }
          ]
        },
        {
          "code" : "ACTPEND",
          "display" : "active - pending investigation",
          "definition" : "**Definition:** Coverage is in effect for healthcare service(s) and/or product(s) - Pending Investigation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22214"
            }
          ]
        },
        {
          "code" : "ELG",
          "display" : "eligible",
          "definition" : "**Definition:** Coverage is in effect for healthcare service(s) and/or product(s).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22211"
            }
          ]
        },
        {
          "code" : "INACT",
          "display" : "inactive",
          "definition" : "**Definition:** Coverage is not in effect for healthcare service(s) and/or product(s).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22215"
            }
          ]
        },
        {
          "code" : "INPNDINV",
          "display" : "inactive - pending investigation",
          "definition" : "**Definition:** Coverage is not in effect for healthcare service(s) and/or product(s) - Pending Investigation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22217"
            }
          ]
        },
        {
          "code" : "INPNDUPD",
          "display" : "inactive - pending eligibility update",
          "definition" : "**Definition:** Coverage is not in effect for healthcare service(s) and/or product(s) - Pending Eligibility Update.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22216"
            }
          ]
        },
        {
          "code" : "NELG",
          "display" : "not eligible",
          "definition" : "**Definition:** Coverage is not in effect for healthcare service(s) and/or product(s). May optionally include reasons for the ineligibility.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22212"
            }
          ]
        }
      ]
    },
    {
      "code" : "_WorkSchedule",
      "display" : "_WorkSchedule",
      "definition" : "Concepts that describe an individual's typical arrangement of working hours for an occupation.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23907"
        }
      ],
      "concept" : [
        {
          "code" : "DS",
          "display" : "daytime shift",
          "definition" : "A person who is scheduled for work during daytime hours (for example between 6am and 6pm) on a regular basis.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23908"
            }
          ]
        },
        {
          "code" : "EMS",
          "display" : "early morning shift",
          "definition" : "Consistent Early morning schedule of 13 hours or less per shift (between 2 am and 2 pm)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23911"
            }
          ]
        },
        {
          "code" : "ES",
          "display" : "evening shift",
          "definition" : "A person who is scheduled for work during evening hours (for example between 2pm and midnight) on a regular basis.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23909"
            }
          ]
        },
        {
          "code" : "NS",
          "display" : "night shift",
          "definition" : "Scheduled for work during nighttime hours (for example between 9pm and 8am) on a regular basis.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23910"
            }
          ]
        },
        {
          "code" : "RSWN",
          "display" : "rotating shift with nights",
          "definition" : "Scheduled for work times that change periodically between days, and/or evenings, and includes some night shifts.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23912"
            }
          ]
        },
        {
          "code" : "RSWON",
          "display" : "rotating shift without nights",
          "definition" : "Scheduled for work days/times that change periodically between days, but does not include night or evening work.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23913"
            }
          ]
        },
        {
          "code" : "SS",
          "display" : "split shift",
          "definition" : "Shift consisting of two distinct work periods each day that are separated by a break of a few hours (for example 2 to 4 hours)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23914"
            }
          ]
        },
        {
          "code" : "VLS",
          "display" : "very long shift",
          "definition" : "Shifts of 17 or more hours.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23915"
            }
          ]
        },
        {
          "code" : "VS",
          "display" : "variable shift",
          "definition" : "Irregular, unpredictable hours scheduled on a short notice (for example, less than 2 day notice): inconsistent schedule, on-call, as needed, as available.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23916"
            }
          ]
        }
      ]
    },
    {
      "code" : "_AnnotationValue",
      "display" : "AnnotationValue",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21095"
        }
      ],
      "concept" : [
        {
          "code" : "_ECGAnnotationValue",
          "display" : "ECGAnnotationValue",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21097"
            }
          ]
        }
      ]
    },
    {
      "code" : "_CommonClinicalObservationValue",
      "display" : "common clinical observation",
      "definition" : "**Description:**Used in a patient care message to value simple clinical (non-lab) observations.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21945"
        }
      ],
      "concept" : [
        {
          "code" : "_CommonClinicalObservationAssertionValue",
          "display" : "CommonClinicalObservationAssertionValue",
          "definition" : "**Definition:** The non-laboratory, non-DI (diagnostic imaging) coded observation if no value is also required to convey the full meaning of the observation. This may be a single concept code or a complex expression.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "22262"
            }
          ]
        },
        {
          "code" : "_CommonClinicalObservationResultValue",
          "display" : "CommonClinicalObservationResultValue",
          "definition" : "**Definition:** The non-laboratory, non-diagnostic imaging coded result of the coded observable or \"question\" represented by the paired concept from the the NonLabDICodedObservationType domain.\r\n\r\n\\]\r\n\r\n**Examples:**An APGAR result, a functional assessment, etc. The value must not require a specific unit of measure.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "22263"
            }
          ]
        }
      ]
    },
    {
      "code" : "_CoverageChemicalDependencyValue",
      "display" : "CoverageChemicalDependencyValue",
      "definition" : "**Definition:** The category of addiction used for coverage purposes that may refer to a substance, the consumption of which may result in physical or emotional harm.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22242"
        }
      ]
    },
    {
      "code" : "_IndividualCaseSafetyReportValueDomains",
      "display" : "Individual Case Safety Report Value Domains",
      "definition" : "This domain is established as a parent to a variety of value domains being defined to support the communication of Individual Case Safety Reports to regulatory bodies. Arguably, this aggregation is not taxonomically pure, but the grouping will facilitate the management of these domains.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21397"
        }
      ],
      "concept" : [
        {
          "code" : "_CaseSeriousnessCriteria",
          "display" : "CaseSeriousnessCriteria",
          "definition" : "A code that provides information on the overall effect or outcome of the adverse reaction/adverse event reported in the ICSR. Note the criterion applies to the case as a whole and not to an individual reaction.\r\n\r\nExample concepts are: death, disability, hospitalization, congenital anomaly/ birth defect, and other medically important condition.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21398"
            }
          ]
        },
        {
          "code" : "_DeviceManufacturerEvaluationInterpretation",
          "display" : "DeviceManufacturerEvaluationInterpretation",
          "definition" : "A code set that includes codes that are used to characterize the outcome of the device evaluation process. The code defines the manufacturer's conclusions following the evaluation.\r\n\r\nExamples include: inadequate alarms, device maintenance contributed to event, device failed just prior to use, user error caused event",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21405"
            }
          ]
        },
        {
          "code" : "_DeviceManufacturerEvaluationMethod",
          "display" : "DeviceManufacturerEvaluationMethod",
          "definition" : "Code assigned to indicate a relevant fact within the context of the evaluation of a reported product. There are a number of concept types including the status of the evaluation, the type of evaluation findings, and the type of activity carried out as part of the evaluation process.\r\n\r\nExamples include: Actual device involved in incident was evaluated, electrical tests performed, visual examination.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21406"
            }
          ]
        },
        {
          "code" : "_DeviceManufacturerEvaluationResult",
          "display" : "DeviceManufacturerEvaluationResult",
          "definition" : "Code assigned to indicate an outcome of the manufacturer's investigation of a product for which a defect has been reported.\r\n\r\nExamples include:.component/subassembly failure: air cleaner, computer-, imaging system-, microprocessor-controlled device problem: cache memory, design -- not fail safe.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21404"
            }
          ]
        },
        {
          "code" : "_PertinentReactionRelatedness",
          "display" : "Pertinent Reaction Relatedness",
          "definition" : "A code to capture the reporter's assessment of the extent to which the reaction is related to the suspect product reported in the ICSR.\r\n\r\nExample concepts include: related, not related, possibly related and unlikely related.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21401"
            }
          ]
        },
        {
          "code" : "_ProductCharacterization",
          "display" : "Product Characterization",
          "definition" : "A code that characterizes the role that the primary reporter felt that the suspect intervention -- either a substance administration or a device related procedure - played in the incident being reported. This code will capture the primary reporter's assessment of the role that the suspect product played in the incident reported in the ICSR.\r\n\r\nExamples include: Suspect, Concomitant, Interacting, Re-challenge.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21400"
            }
          ]
        },
        {
          "code" : "_ReactionActionTaken",
          "display" : "ReactionActionTaken",
          "definition" : "Code used to indicate the action taken by practitioner in response to the problem (whether drug or device related) that is reported in the ICSR.\r\n\r\nExamples include: failing device replaced, medication stopped, medication dose adjusted.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21407"
            }
          ]
        },
        {
          "code" : "_SubjectReaction",
          "display" : "Subject Reaction",
          "definition" : "A code to capture the kind of reaction that was suffered by the investigated subject, and that is being reported in the ICSR. At this point, SNOMED or MedDRA have been suggested as code systems to be used for providing this information.\r\n\r\nExample concepts include hives, swelling, rash, anaphylactic shock.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21399"
            }
          ]
        },
        {
          "code" : "_SubjectReactionEmphasis",
          "display" : "SubjectReactionEmphasis",
          "definition" : "Code that captures the emphasis that the reporter placed on this reaction.\r\n\r\nExamples include: highlighted by the reporter, NOT serious, Not highlighted by the reporter, NOT serious, Highlighted by the reporter, SERIOUS, Not highlighted by the reporter, SERIOUS.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21403"
            }
          ]
        },
        {
          "code" : "_SubjectReactionOutcome",
          "display" : "SubjectReactionOutcome",
          "definition" : "Code that captures the type of outcome from an individual outcome of a reaction to the suspect product reported in the ICSR.\r\n\r\nExamples include: Recovered/resolved. Recovering/resolving, Not recovered/not resolved, Recovered/resolved with sequelae, Fatal.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21402"
            }
          ]
        }
      ]
    },
    {
      "code" : "_InjuryObservationValue",
      "display" : "InjuryObservationValue",
      "definition" : "Values for observations of injuries.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21098"
        }
      ]
    },
    {
      "code" : "_IntoleranceValue",
      "display" : "IntoleranceValue",
      "definition" : "Codes identifying pariticular groupings of allergens and other agents which cause allergies and intolerances. E.g. the drug, allergen group, food or environmental agent which triggers the intolerance",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21495"
        }
      ]
    },
    {
      "code" : "_IssueTriggerObservationValue",
      "display" : "IssueTriggerObservationValue",
      "definition" : "The combined domain for different types of coded observation issue triggers, such as diagnoses, allergies, etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21528"
        }
      ]
    },
    {
      "code" : "_OtherIndicationValue",
      "display" : "OtherIndicationValue",
      "definition" : "Indicates an observed reason for a medical action other than an indication or symptom. E.g. Need for a contrast agent prior to a diagnostic image, need for anesthesia prior to surgery, etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21544"
        }
      ]
    },
    {
      "code" : "_IndicationValue",
      "display" : "IndicationValue",
      "definition" : "Indicates the specific observation result which is the reason for the action (prescription, lab test, etc.). E.g. Headache, Ear infection, planned diagnostic image (requiring contrast agent), etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21542"
        }
      ],
      "concept" : [
        {
          "code" : "_DiagnosisValue",
          "display" : "DiagnosisValue",
          "definition" : "Diagnosis Value",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21096"
            }
          ]
        },
        {
          "code" : "_SymptomValue",
          "display" : "SymptomValue",
          "definition" : "Indicates an observed abnormality in the patientaTMs condition, but does not assert causation. E.g. Runny nose, swelling, flaky skin, etc.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "21543"
            }
          ]
        }
      ]
    }
  ]
}

```
