# NullFlavor - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NullFlavor**

## CodeSystem: NullFlavor 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-NullFlavor | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NullFlavor |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1008 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A collection of codes specifying why a valid value is not present. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GenderIdentity](ValueSet-gender-identity.md)
* [AskedButUnknown](ValueSet-v3-AskedButUnknown.md)
* [ClassNullFlavor](ValueSet-v3-ClassNullFlavor.md)
* [NoInformation](ValueSet-v3-NoInformation.md)
* [NullFlavor](ValueSet-v3-NullFlavor.md)
* [Other](ValueSet-v3-Other.md)
* [Unknown](ValueSet-v3-Unknown.md)
* [YesNoUnknownNotApplicable](ValueSet-yes-no-unknown-not-applicable.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-NullFlavor",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1008"
    }
  ],
  "version" : "3.0.0",
  "name" : "NullFlavor",
  "title" : "NullFlavor",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A collection of codes specifying why a valid value is not present.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "NI",
      "display" : "NoInformation",
      "definition" : "**Description:**The value is exceptional (missing, omitted, incomplete, improper). No information as to the reason for being an exceptional value is provided. This is the most general exceptional value. It is also the default exceptional value.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10610"
        }
      ]
    },
    {
      "code" : "NP",
      "display" : "not present",
      "definition" : "Value is not present in a message. This is only defined in messages, never in application data! All values not present in the message must be replaced by the applicable default, or no-information (NI) as the default of all defaults.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "10619"
        }
      ]
    },
    {
      "code" : "NAV",
      "display" : "temporarily unavailable",
      "definition" : "Information is not available at this time but it is expected that it will be available later.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10615"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ASKU"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NAVU"
        }
      ]
    },
    {
      "code" : "DER",
      "display" : "derived",
      "definition" : "**Description:**An actual value may exist, but it must be derived from the provided information (usually an EXPR generic data type extension will be used to convey the derivation expressionexpression .",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22657"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INV"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "other",
      "definition" : "**Description:**The actual value is not a member of the set of permitted data values in the constrained value domain of a variable. (e.g., concept not provided by required code system).\r\n\r\n**Usage Notes**: This flavor and its specializations are most commonly used with the CD datatype and its flavors. However, it may apply to \\*any\\* datatype where the constraints of the type are tighter than can be conveyed. For example, a PQ that is for a true measured amount whose units are not supported in UCUM, a need to convey a REAL when the type has been constrained to INT, etc.\r\n\r\nWith coded datatypes, this null flavor may only be used if the vocabulary binding has a coding strength of CNE. By definition, all local codes and original text are part of the value set if the coding strength is CWE.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "This flavor and its specializations are most commonly used with the CD datatype and its flavors.  However, it may apply to *any* datatype where the constraints of the type are tighter than can be conveyed.  For example, a PQ that is for a true measured amount whose units are not supported in UCUM, a need to convey a REAL when the type has been constrained to INT, etc. With coded datatypes, this null flavor may only be used if the vocabulary binding has a coding strength of CNE.  By definition, all local codes and original text are part of the value set if the coding strength is CWE."
        },
        {
          "code" : "internalId",
          "valueCode" : "10616"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INV"
        }
      ]
    },
    {
      "code" : "UNC",
      "display" : "un-encoded",
      "definition" : "**Description:** The actual value has not yet been encoded within the approved value domain.\r\n\r\n**Example**: Original text or a local code has been specified but translation or encoding to the approved value set has not yet occurred due to limitations of the sending system. Original text has been captured for a PQ, but not attempt has been made to split the value and unit or to encode the unit in UCUM.\r\n\r\n**Usage Notes**: If it is known that it is not possible to encode the concept, OTH should be used instead. However, use of UNC does not necessarily guarantee the concept will be encodable, only that encoding has not been attempted.\r\n\r\nData type properties such as original text and translations may be present when this null flavor is included.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "If it is known that it is not possible to encode the concept, OTH should be used instead.  However, use of UNC does not necessarily guarantee the concept will be encodable, only that encoding has not been attempted. Data type properties such as original text and translations may be present when this null flavor is included."
        },
        {
          "code" : "internalId",
          "valueCode" : "22185"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INV"
        }
      ]
    },
    {
      "code" : "INV",
      "display" : "invalid",
      "definition" : "**Description:**The value as represented in the instance is not a member of the set of permitted data values in the constrained value domain of a variable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22656"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NI"
        }
      ]
    },
    {
      "code" : "MSK",
      "display" : "masked",
      "definition" : "There is information on this item available but it has not been provided by the sender due to security, privacy or other reasons. There may be an alternate mechanism for gaining access to this information.\r\n\r\nNote: using this null flavor does provide information that may be a breach of confidentiality, even though no detail data is provided. Its primary purpose is for those circumstances where it is necessary to inform the receiver that the information does exist without providing any detail.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17932"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NI"
        }
      ]
    },
    {
      "code" : "NA",
      "display" : "not applicable",
      "definition" : "Known to have no proper value (e.g., last menstrual period for a male).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10611"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NI"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "unknown",
      "definition" : "**Description:**A proper value is applicable, but not known.\r\n\r\n**Usage Notes**: This means the actual value is not known. If the only thing that is unknown is how to properly express the value in the necessary constraints (value set, datatype, etc.), then the OTH or UNC flavor should be used. No properties should be included for a datatype with this property unless:\r\n\r\n1.  Those properties themselves directly translate to a semantic of \"unknown\". (E.g. a local code sent as a translation that conveys 'unknown')\r\n2.  Those properties further qualify the nature of what is unknown. (E.g. specifying a use code of \"H\" and a URL prefix of \"tel:\" to convey that it is the home phone number that is unknown.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "This means the actual value is not known.  If the only thing that is unknown is how to properly express the value in the necessary constraints (value set, datatype, etc.), then the OTH or UNC flavor should be used.  No properties should be included for a datatype with this property unless:  Those properties themselves directly translate to a semantic of \"unknown\".  (E.g. a local code sent as a translation that conveys 'unknown') Those properties further qualify the nature of what is unknown.  (E.g. specifying a use code of \"H\" and a URL prefix of \"tel:\" to convey that it is the home phone number that is unknown.)"
        },
        {
          "code" : "internalId",
          "valueCode" : "10612"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NI"
        }
      ]
    },
    {
      "code" : "NINF",
      "display" : "negative infinity",
      "definition" : "Negative infinity of numbers.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10618"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OTH"
        }
      ]
    },
    {
      "code" : "PINF",
      "display" : "positive infinity",
      "definition" : "Positive infinity of numbers.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10617"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OTH"
        }
      ]
    },
    {
      "code" : "ASKU",
      "display" : "asked but unknown",
      "definition" : "Information was sought but not found (e.g., patient was asked but didn't know)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10614"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "UNK"
        }
      ]
    },
    {
      "code" : "NASK",
      "display" : "not asked",
      "definition" : "This information has not been sought (e.g., patient was not asked)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10613"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "UNK"
        }
      ]
    },
    {
      "code" : "NAVU",
      "display" : "Not available",
      "definition" : "Information is not available at this time (with no expectation regarding whether it will or will not be available in the future).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23731"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "UNK"
        }
      ]
    },
    {
      "code" : "QS",
      "display" : "Sufficient Quantity",
      "definition" : "**Description:**The specific quantity is not known, but is known to be non-zero and is not specified because it makes up the bulk of the material. e.g. 'Add 10mg of ingredient X, 50mg of ingredient Y, and sufficient quantity of water to 100mL.' The null flavor would be used to express the quantity of water.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21436"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "UNK"
        }
      ]
    },
    {
      "code" : "TRC",
      "display" : "trace",
      "definition" : "The content is greater than zero, but too small to be quantified.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21386"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "UNK"
        }
      ]
    }
  ]
}

```
