# AddressPartType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AddressPartType**

## CodeSystem: AddressPartType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-AddressPartType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AddressPartType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.16 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**Code that specifies whether an address part names the street, city, country, postal code, post box, etc. 
Discussion: The hierarchical nature of these concepts shows composition. E.g. "Street Name" is part of "Street Address Line" 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdditionalLocator](ValueSet-v3-AdditionalLocator.md)
* [AddressLine](ValueSet-v3-AddressLine.md)
* [AddressPartType](ValueSet-v3-AddressPartType.md)
* [BuildingNumber](ValueSet-v3-BuildingNumber.md)
* [DeliveryAddressLine](ValueSet-v3-DeliveryAddressLine.md)
* [StreetAddressLine](ValueSet-v3-StreetAddressLine.md)
* [StreetName](ValueSet-v3-StreetName.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-AddressPartType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.16"
    }
  ],
  "version" : "3.0.0",
  "name" : "AddressPartType",
  "title" : "AddressPartType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** Code that specifies whether an address part names the street, city, country, postal code, post box, etc.\r\n\r\nDiscussion: The hierarchical nature of these concepts shows composition. E.g. \"Street Name\" is part of \"Street Address Line\"",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "ComponentOf"
        }
      ],
      "code" : "ComponentOf",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#ComponentOf",
      "description" : "This relationship indicates that the source concept is a component of the target concept.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ADL",
      "display" : "additional locator",
      "definition" : "This can be a unit designator, such as apartment number, suite number, or floor. There may be several unit designators in an address (e.g., \"3rd floor, Appt. 342\"). This can also be a designator pointing away from the location, rather than specifying a smaller location within some larger one (e.g., Dutch \"t.o.\" means \"opposite to\" for house boats located across the street facing houses).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "AL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "10651"
        }
      ]
    },
    {
      "code" : "AL",
      "display" : "address line",
      "definition" : "**Description:** An address line is for either an additional locator, a delivery address or a street address.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22619"
        }
      ],
      "concept" : [
        {
          "code" : "DAL",
          "display" : "delivery address line",
          "definition" : "A delivery address line is frequently used instead of breaking out delivery mode, delivery installation, etc. An address generally has only a delivery address line or a street address line, but not both.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "17887"
            }
          ]
        },
        {
          "code" : "SAL",
          "display" : "street address line",
          "definition" : "**Description:** A street address line is frequently used instead of breaking out build number, street name, street type, etc. An address generally has only a delivery address line or a street address line, but not both.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "14822"
            }
          ]
        }
      ]
    },
    {
      "code" : "BNN",
      "display" : "building number numeric",
      "definition" : "The numeric portion of a building number",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "BNR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17881"
        }
      ]
    },
    {
      "code" : "BNR",
      "display" : "building number",
      "definition" : "The number of a building, house or lot alongside the street. Also known as \"primary street number\". This does not number the street but rather the building.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "SAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "10649"
        }
      ]
    },
    {
      "code" : "BNS",
      "display" : "building number suffix",
      "definition" : "Any alphabetic character, fraction or other text that may appear after the numeric portion of a building number",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "BNR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17882"
        }
      ]
    },
    {
      "code" : "CAR",
      "display" : "care of",
      "definition" : "The name of the party who will take receipt at the specified address, and will take on responsibility for ensuring delivery to the target recipient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17879"
        }
      ]
    },
    {
      "code" : "CEN",
      "display" : "census tract",
      "definition" : "A geographic sub-unit delineated for demographic purposes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17934"
        }
      ]
    },
    {
      "code" : "CNT",
      "display" : "country",
      "definition" : "Country",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10644"
        }
      ]
    },
    {
      "code" : "CPA",
      "display" : "county or parish",
      "definition" : "A sub-unit of a state or province. (49 of the United States of America use the term \"county;\" Louisiana uses the term \"parish\".)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12210"
        }
      ]
    },
    {
      "code" : "CTY",
      "display" : "municipality",
      "definition" : "The name of the city, town, village, or other community or delivery center",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10646"
        }
      ]
    },
    {
      "code" : "DEL",
      "display" : "delimiter",
      "definition" : "Delimiters are printed without framing white space. If no value component is provided, the delimiter appears as a line break.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10643"
        }
      ]
    },
    {
      "code" : "DINST",
      "display" : "delivery installation type",
      "definition" : "Indicates the type of delivery installation (the facility to which the mail will be delivered prior to final shipping via the delivery mode.) Example: post office, letter carrier depot, community mail center, station, etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "DAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17890"
        }
      ]
    },
    {
      "code" : "DINSTA",
      "display" : "delivery installation area",
      "definition" : "The location of the delivery installation, usually a town or city, and is only required if the area is different from the municipality. Area to which mail delivery service is provided from any postal facility or service such as an individual letter carrier, rural route, or postal route.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "DAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17892"
        }
      ]
    },
    {
      "code" : "DINSTQ",
      "display" : "delivery installation qualifier",
      "definition" : "A number, letter or name identifying a delivery installation. E.g., for Station A, the delivery installation qualifier would be 'A'.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "DAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17891"
        }
      ]
    },
    {
      "code" : "DIR",
      "display" : "direction",
      "definition" : "Direction (e.g., N, S, W, E)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "SAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "10650"
        }
      ]
    },
    {
      "code" : "DMOD",
      "display" : "delivery mode",
      "definition" : "Indicates the type of service offered, method of delivery. For example: post office box, rural route, general delivery, etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "DAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17888"
        }
      ]
    },
    {
      "code" : "DMODID",
      "display" : "delivery mode identifier",
      "definition" : "Represents the routing information such as a letter carrier route number. It is the identifying number of the designator (the box number or rural route number).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "DAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17889"
        }
      ]
    },
    {
      "code" : "DPID",
      "display" : "delivery point identifier",
      "definition" : "A value that uniquely identifies the postal address.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23531"
        }
      ]
    },
    {
      "code" : "INT",
      "display" : "intersection",
      "definition" : "**Description:**An intersection denotes that the actual address is located AT or CLOSE TO the intersection OF two or more streets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "AL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "22620"
        }
      ]
    },
    {
      "code" : "POB",
      "display" : "post box",
      "definition" : "A numbered box located in a post station.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "DMODID"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "10652"
        }
      ]
    },
    {
      "code" : "PRE",
      "display" : "precinct",
      "definition" : "A subsection of a municipality",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17880"
        }
      ]
    },
    {
      "code" : "STA",
      "display" : "state or province",
      "definition" : "A sub-unit of a country with limited sovereignty in a federally organized country.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10645"
        }
      ]
    },
    {
      "code" : "STB",
      "display" : "street name base",
      "definition" : "The base name of a roadway or artery recognized by a municipality (excluding street type and direction)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "STR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17883"
        }
      ]
    },
    {
      "code" : "STR",
      "display" : "street name",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "SAL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "10648"
        }
      ]
    },
    {
      "code" : "STTYP",
      "display" : "street type",
      "definition" : "The designation given to the street. (e.g. Street, Avenue, Crescent, etc.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "STR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17884"
        }
      ]
    },
    {
      "code" : "UNID",
      "display" : "unit identifier",
      "definition" : "The number or name of a specific unit contained within a building or complex, as assigned by that building or complex.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "ADL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17886"
        }
      ]
    },
    {
      "code" : "UNIT",
      "display" : "unit designator",
      "definition" : "Indicates the type of specific unit contained within a building or complex. E.g. Appartment, Floor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "ComponentOf",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressPartType",
            "code" : "ADL"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "17885"
        }
      ]
    },
    {
      "code" : "ZIP",
      "display" : "postal code",
      "definition" : "A postal code designating a region defined by the postal service.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10647"
        }
      ]
    }
  ]
}

```
