# ActStatus - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActStatus**

## CodeSystem: ActStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActStatus | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.14 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes representing the defined possible states of an Act, as defined by the Act class state machine. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActStatus](ValueSet-v3-ActStatus.md)
* [ActStatusAborted](ValueSet-v3-ActStatusAborted.md)
* [ActStatusAbortedCancelledCompleted](ValueSet-v3-ActStatusAbortedCancelledCompleted.md)
* [ActStatusActive](ValueSet-v3-ActStatusActive.md)
* [ActStatusActiveAborted](ValueSet-v3-ActStatusActiveAborted.md)
* [ActStatusActiveSuspendedObsolete](ValueSet-v3-ActStatusActiveSuspendedObsolete.md)
* [ActStatusCancelled](ValueSet-v3-ActStatusCancelled.md)
* [ActStatusCompleted](ValueSet-v3-ActStatusCompleted.md)
* [ActStatusHeld](ValueSet-v3-ActStatusHeld.md)
* [ActStatusNew](ValueSet-v3-ActStatusNew.md)
* [ActStatusNormal](ValueSet-v3-ActStatusNormal.md)
* [ActStatusNullified](ValueSet-v3-ActStatusNullified.md)
* [ActStatusObsolete](ValueSet-v3-ActStatusObsolete.md)
* [ActStatusSuspended](ValueSet-v3-ActStatusSuspended.md)
* [ProvenanceEventCurrentStateAS](ValueSet-v3-ProvenanceEventCurrentState-AS.md)
* [XActStatusActiveComplete](ValueSet-v3-xActStatusActiveComplete.md)
* [XActStatusActiveSuspended](ValueSet-v3-xActStatusActiveSuspended.md)
* [XActStatusPrevious](ValueSet-v3-xActStatusPrevious.md)
* [XDocumentStatus](ValueSet-v3-xDocumentStatus.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.14"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActStatus",
  "title" : "ActStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes representing the defined possible states of an Act, as defined by the Act class state machine.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "normal",
      "display" : "normal",
      "definition" : "Encompasses the expected states of an Act, but excludes \"nullified\" and \"obsolete\" which represent unusual terminal states for the life-cycle.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15936"
        }
      ],
      "concept" : [
        {
          "code" : "aborted",
          "display" : "aborted",
          "definition" : "The Act has been terminated prior to the originally intended completion.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15941"
            }
          ]
        },
        {
          "code" : "active",
          "display" : "active",
          "definition" : "The Act can be performed or is being performed",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15942"
            }
          ]
        },
        {
          "code" : "cancelled",
          "display" : "cancelled",
          "definition" : "The Act has been abandoned before activation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15938"
            }
          ]
        },
        {
          "code" : "completed",
          "display" : "completed",
          "definition" : "An Act that has terminated normally after all of its constituents have been performed.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15940"
            }
          ]
        },
        {
          "code" : "held",
          "display" : "held",
          "definition" : "An Act that is still in the preparatory stages has been put aside. No action can occur until the Act is released.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15937"
            }
          ]
        },
        {
          "code" : "new",
          "display" : "new",
          "definition" : "An Act that is in the preparatory stages and may not yet be acted upon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15943"
            }
          ]
        },
        {
          "code" : "suspended",
          "display" : "suspended",
          "definition" : "An Act that has been activated (actions could or have been performed against it), but has been temporarily disabled. No further action should be taken against it until it is released",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15939"
            }
          ]
        }
      ]
    },
    {
      "code" : "nullified",
      "display" : "nullified",
      "definition" : "This Act instance was created in error and has been 'removed' and is treated as though it never existed. A record is retained for audit purposes only.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15934"
        }
      ]
    },
    {
      "code" : "obsolete",
      "display" : "obsolete",
      "definition" : "This Act instance has been replaced by a new instance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15935"
        }
      ]
    }
  ]
}

```
