# name-addressRepresentation - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **name-addressRepresentation**

## CodeSystem: name-addressRepresentation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-4000 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NameAddressRepresentation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.436 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined cdoe system of concepts that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data. It is used to provides hints for a receiver, so it can make choices regarding what it has been sent and what it is capable of displaying. 

 
Underlying Master Code System for V2 table 4000 (Name/address representation) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSNameAddressRepresentation](ValueSet-v2-4000.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-4000",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-4000",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.436"
    }
  ],
  "version" : "2.0.0",
  "name" : "NameAddressRepresentation",
  "title" : "name-addressRepresentation",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined cdoe system of concepts that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data.  It is used to provides hints for a receiver, so it can make choices regarding what it has been sent and what it is capable of displaying.",
  "purpose" : "Underlying Master Code System for V2 table 4000 (Name/address representation)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-4000",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6795",
      "code" : "I",
      "display" : "Ideographic (i.e., Kanji)",
      "definition" : "Ideographic (i.e., Kanji)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6796",
      "code" : "A",
      "display" : "Alphabetic (i.e., Default or some single-byte)",
      "definition" : "Alphabetic (i.e., Default or some single-byte)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6797",
      "code" : "P",
      "display" : "Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)",
      "definition" : "Phonetic (i.e., ASCII, Katakana, Hiragana, etc.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
