# phlebotomyIssue - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **phlebotomyIssue**

## CodeSystem: phlebotomyIssue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0925 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PhlebotomyIssue |
| *Other Identifiers:*OID:2.16.840.1.113883.18.431 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the phlebotomy issue. Used in HL7 Version 2.x messaging in the DON segment. 

 
Underlying Master Code System for V2 table 0925 (Phlebotomy Issue) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPhlebotomyIssue](ValueSet-v2-0925.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0925",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0925",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.431"
    }
  ],
  "version" : "2.0.0",
  "name" : "PhlebotomyIssue",
  "title" : "phlebotomyIssue",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the phlebotomy issue.  Used in HL7 Version 2.x messaging in the DON segment.",
  "purpose" : "Underlying Master Code System for V2 table 0925 (Phlebotomy Issue)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0925",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6653",
      "code" : "INF",
      "display" : "Infiltration",
      "definition" : "Infiltration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6654",
      "code" : "VSM",
      "display" : "Vein Spasm",
      "definition" : "Vein Spasm",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6655",
      "code" : "COL",
      "display" : "Collapse",
      "definition" : "Collapse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6656",
      "code" : "MIS",
      "display" : "Missed / in tissue",
      "definition" : "Missed / in tissue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6657",
      "code" : "NAD",
      "display" : "Needle adjustment (this may not end a procedure, if successful will impact component production)",
      "definition" : "Needle adjustment (this may not end a procedure, if successful will impact component production)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6658",
      "code" : "PFL",
      "display" : "Poor flow",
      "definition" : "Poor flow",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6659",
      "code" : "CLT",
      "display" : "Clotted",
      "definition" : "Clotted",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6660",
      "code" : "DND",
      "display" : "Defective Needle",
      "definition" : "Defective Needle",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6661",
      "code" : "DBG",
      "display" : "Defective Bag",
      "definition" : "Defective Bag",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6662",
      "code" : "DAK",
      "display" : "Defective Apheresis Kit",
      "definition" : "Defective Apheresis Kit",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6663",
      "code" : "DMT",
      "display" : "Defective Instrument",
      "definition" : "Defective Instrument",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6664",
      "code" : "IPF",
      "display" : "Instrument Power Failure",
      "definition" : "Instrument Power Failure",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6665",
      "code" : "ACN",
      "display" : "Air Contamination",
      "definition" : "Air Contamination",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Luftverschmutzung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
