# drgProcedureDeterminationStatus - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **drgProcedureDeterminationStatus**

## CodeSystem: drgProcedureDeterminationStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0761 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DrgProcedureDeterminationStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.400 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the status of the use of this particular procedure for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the PR1 segment. 

 
Underlying Master Code System for V2 table 0761 (DRG Procedure Determination Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDrgProcedureDeterminationStatus](ValueSet-v2-0761.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0761",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0761",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.400"
    }
  ],
  "version" : "2.0.0",
  "name" : "DrgProcedureDeterminationStatus",
  "title" : "drgProcedureDeterminationStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status of the use of this particular procedure for the diagnosis related group (DRG) determination.  US Realm. Used in HL7 Version 2.x messaging in the PR1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0761 (DRG Procedure Determination Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0761",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6464",
      "code" : "0",
      "display" : "Valid code",
      "definition" : "Valid code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6465",
      "code" : "1",
      "display" : "Invalid code",
      "definition" : "Invalid code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6466",
      "code" : "2",
      "display" : "Not used",
      "definition" : "Not used",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6467",
      "code" : "3",
      "display" : "Invalid for this gender",
      "definition" : "Invalid for this gender",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6468",
      "code" : "4",
      "display" : "Invalid for this age",
      "definition" : "Invalid for this age",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
