# payeeRelationshipToInvoice - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **payeeRelationshipToInvoice**

## CodeSystem: payeeRelationshipToInvoice 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0558 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PayeeRelationshipToInvoice |
| *Other Identifiers:*OID:2.16.840.1.113883.18.362 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the relationship to the invoice for Person Payee Types. Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0558 (Payee Relationship to Invoice) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPayeeRelationshipToInvoice](ValueSet-v2-0558.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0558",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0558",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.362"
    }
  ],
  "version" : "2.0.0",
  "name" : "PayeeRelationshipToInvoice",
  "title" : "payeeRelationshipToInvoice",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the relationship to the invoice for Person Payee Types.  Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0558 (Payee Relationship to Invoice)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0558",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6182",
      "code" : "PT",
      "display" : "Patient",
      "definition" : "Patient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6183",
      "code" : "FM",
      "display" : "Family Member",
      "definition" : "Family Member",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6184",
      "code" : "SB",
      "display" : "Subscriber",
      "definition" : "Subscriber",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6185",
      "code" : "GT",
      "display" : "Guarantor",
      "definition" : "Guarantor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
