# eventRelatedPeriod - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eventRelatedPeriod**

## CodeSystem: eventRelatedPeriod 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0528 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EventRelatedPeriod |
| *Other Identifiers:*OID:2.16.840.1.113883.18.344 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying a common (periodical) activity of daily living. Used in HL7 Version 2 messaging in the RPT segment. 

 
Underlying Master Code System for V2 table 0528 (Event Related Period) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSEventRelatedPeriod](ValueSet-v2-0528.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0528",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0528",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.344"
    }
  ],
  "version" : "2.0.0",
  "name" : "EventRelatedPeriod",
  "title" : "eventRelatedPeriod",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying a common (periodical) activity of daily living.  Used in HL7 Version 2 messaging in the RPT segment.",
  "purpose" : "Underlying Master Code System for V2 table 0528 (Event Related Period)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0528",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5613",
      "code" : "HS",
      "display" : "the hour of sleep (e.g., H18-22)",
      "definition" : "the hour of sleep (e.g., H18-22)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5614",
      "code" : "AC",
      "display" : "before meal (from lat. ante cibus)",
      "definition" : "before meal (from lat. ante cibus)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "vor der Mahlzeit (from lat. Ante cibus)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5615",
      "code" : "PC",
      "display" : "after meal (from lat. post cibus)",
      "definition" : "after meal (from lat. post cibus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5616",
      "code" : "IC",
      "display" : "between meals (from lat. inter cibus)",
      "definition" : "between meals (from lat. inter cibus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5617",
      "code" : "ACM",
      "display" : "before breakfast (from lat. ante cibus matutinus)",
      "definition" : "before breakfast (from lat. ante cibus matutinus)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "vor dem Frühstück (from lat. Ante cibus matutinus)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5618",
      "code" : "ACD",
      "display" : "before lunch (from lat. ante cibus diurnus)",
      "definition" : "before lunch (from lat. ante cibus diurnus)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "vor dem Mittagessen (from lat. Ante cibus diurnus)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5619",
      "code" : "ACV",
      "display" : "before dinner (from lat. ante cibus vespertinus)",
      "definition" : "before dinner (from lat. ante cibus vespertinus)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "vor dem Abendessen (from lat. Ante cibus vespertinus)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5620",
      "code" : "PCM",
      "display" : "after breakfast (from lat. post cibus matutinus)",
      "definition" : "after breakfast (from lat. post cibus matutinus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5621",
      "code" : "PCD",
      "display" : "after lunch (from lat. post cibus diurnus)",
      "definition" : "after lunch (from lat. post cibus diurnus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5622",
      "code" : "PCV",
      "display" : "after dinner (from lat. post cibus vespertinus)",
      "definition" : "after dinner (from lat. post cibus vespertinus)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5623",
      "code" : "ICM",
      "display" : "between breakfast and lunch",
      "definition" : "between breakfast and lunch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5624",
      "code" : "ICD",
      "display" : "between lunch and dinner",
      "definition" : "between lunch and dinner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5625",
      "code" : "ICV",
      "display" : "between dinner and the hour of sleep",
      "definition" : "between dinner and the hour of sleep",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
