# errorSeverity - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **errorSeverity**

## CodeSystem: errorSeverity 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0516 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ErrorSeverity |
| *Other Identifiers:*OID:2.16.840.1.113883.18.337 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow. Used in HL7 Version 2.x messaging acknowledgment in the ERR segment. 

 
Underlying Master Code System for V2 table 0516 (Error Severity) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSErrorSeverity](ValueSet-v2-0516.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0516",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0516",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.337"
    }
  ],
  "version" : "2.0.0",
  "name" : "ErrorSeverity",
  "title" : "errorSeverity",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow.  Used in HL7 Version 2.x messaging acknowledgment in the ERR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0516 (Error Severity)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0516",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "5586",
      "code" : "W",
      "display" : "Warning",
      "definition" : "Transaction successful, but there may be issues",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Warnung"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Use this severity when parts of the message may not have been stored."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Transaction successful, but there may issues"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5587",
      "code" : "I",
      "display" : "Information",
      "definition" : "Transaction was successful but includes information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Information"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "e.g., inform patient"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Transaction was successful but includes information e.g., inform patient"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5588",
      "code" : "E",
      "display" : "Error",
      "definition" : "Transaction was unsuccessful",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fehler"
        }
      ],
      "property" : [
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Transaction was unsuccessful"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5589",
      "code" : "F",
      "display" : "Fatal Error",
      "definition" : "Message not processed due to application or network failure condition",
      "property" : [
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Message not processed due to application or network failure condition"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
