# identityReliability - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **identityReliability**

## CodeSystem: identityReliability 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0445 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:IdentityReliability |
| *Other Identifiers:*OID:2.16.840.1.113883.18.285 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the reliability of patient/person identifying data transmitted via a transaction. Used in HL7 Version 2.x messaging in the PID segment. 

 
Underlying Master Code System for V2 table 0445 (Identity Reliability Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSIdentityReliabilityCode](ValueSet-v2-0445.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0445",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0445",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.285"
    }
  ],
  "version" : "2.0.0",
  "name" : "IdentityReliability",
  "title" : "identityReliability",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the reliability of patient/person identifying data transmitted via a transaction.  Used in HL7 Version 2.x messaging in the PID segment.",
  "purpose" : "Underlying Master Code System for V2 table 0445 (Identity Reliability Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0445",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4819",
      "code" : "US",
      "display" : "Unknown/Default Social Security Number",
      "definition" : "Unknown/Default Social Security Number",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4820",
      "code" : "UD",
      "display" : "Unknown/Default Date of Birth",
      "definition" : "Unknown/Default Date of Birth",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4821",
      "code" : "UA",
      "display" : "Unknown/Default Address",
      "definition" : "Unknown/Default Address",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4822",
      "code" : "AL",
      "display" : "Patient/Person Name is an Alias",
      "definition" : "Patient/Person Name is an Alias",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
