# bloodProduct - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **bloodProduct**

## CodeSystem: bloodProduct 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0426 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BloodProduct |
| *Other Identifiers:*OID:2.16.840.1.113883.18.267 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts which specify a type of blood product. Used in HL7 Version 2 messaging in the BLC segment. 

 
Underlying Master Code System for V2 table 0426 (Blood Product Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSBloodProductCode](ValueSet-v2-0426.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0426",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0426",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.267"
    }
  ],
  "version" : "2.0.0",
  "name" : "BloodProduct",
  "title" : "bloodProduct",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a type of blood product.  Used in HL7 Version 2 messaging in the BLC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0426 (Blood Product Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0426",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4591",
      "code" : "CRYO",
      "display" : "Cryoprecipitated AHF",
      "definition" : "Cryoprecipitated AHF",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4592",
      "code" : "CRYOP",
      "display" : "Pooled Cryoprecipitate",
      "definition" : "Pooled Cryoprecipitate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4593",
      "code" : "FFP",
      "display" : "Fresh Frozen Plasma",
      "definition" : "Fresh Frozen Plasma",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4594",
      "code" : "FFPTH",
      "display" : "Fresh Frozen Plasma - Thawed",
      "definition" : "Fresh Frozen Plasma - Thawed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4595",
      "code" : "PC",
      "display" : "Packed Cells",
      "definition" : "Packed Cells",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4596",
      "code" : "PCA",
      "display" : "Autologous Packed Cells",
      "definition" : "Autologous Packed Cells",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4597",
      "code" : "PCNEO",
      "display" : "Packed Cells - Neonatal",
      "definition" : "Packed Cells - Neonatal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4598",
      "code" : "PCW",
      "display" : "Washed Packed Cells",
      "definition" : "Washed Packed Cells",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4599",
      "code" : "PLT",
      "display" : "Platelet Concentrate",
      "definition" : "Platelet Concentrate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4600",
      "code" : "PLTNEO",
      "display" : "Reduced Volume Platelets",
      "definition" : "Reduced Volume Platelets",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4601",
      "code" : "PLTP",
      "display" : "Pooled Platelets",
      "definition" : "Pooled Platelets",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4602",
      "code" : "PLTPH",
      "display" : "Platelet Pheresis",
      "definition" : "Platelet Pheresis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4603",
      "code" : "PLTPHLR",
      "display" : "Leukoreduced Platelet Pheresis",
      "definition" : "Leukoreduced Platelet Pheresis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4604",
      "code" : "RWB",
      "display" : "Reconstituted Whole Blood",
      "definition" : "Reconstituted Whole Blood",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4605",
      "code" : "WBA",
      "display" : "Autologous Whole Blood",
      "definition" : "Autologous Whole Blood",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
