# allowSubstitution - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **allowSubstitution**

## CodeSystem: allowSubstitution 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0279 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AllowSubstitution |
| *Other Identifiers:*OID:2.16.840.1.113883.18.172 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the AIS and AIG segments. 

 
Underlying Master Code System for V2 table 0279 (Allow Substitution Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAllowSubstitutionCodes](ValueSet-v2-0279.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0279",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0279",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.172"
    }
  ],
  "version" : "2.0.0",
  "name" : "AllowSubstitution",
  "title" : "allowSubstitution",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the AIS and AIG segments.",
  "purpose" : "Underlying Master Code System for V2 table 0279 (Allow Substitution Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0279",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2701",
      "code" : "CONFIRM",
      "display" : "Contact the Placer Contact Person prior to making any substitutions of this resource",
      "definition" : "Contact the Placer Contact Person prior to making any substitutions of this resource",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2702",
      "code" : "NO",
      "display" : "Substitution of this resource is not allowed",
      "definition" : "Substitution of this resource is not allowed",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2703",
      "code" : "NOTIFY",
      "display" : "Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made",
      "definition" : "Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2704",
      "code" : "YES",
      "display" : "Substitution of this resource is allowed",
      "definition" : "Substitution of this resource is allowed",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2705",
      "code" : "No",
      "display" : "Substitution of this resource is not allowed",
      "definition" : "Substitution of this resource is not allowed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2706",
      "code" : "Confirm",
      "display" : "Contact the Placer Contact Person prior to making any substitutions of this resource",
      "definition" : "Contact the Placer Contact Person prior to making any substitutions of this resource",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2707",
      "code" : "Notify",
      "display" : "Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made",
      "definition" : "Notify the Placer Contact Person, through normal institutional procedures, that a substitution of this resource has been made",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2708",
      "code" : "Yes",
      "display" : "Substitution of this resource is allowed",
      "definition" : "Substitution of this resource is allowed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
