# locationEquipment - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **locationEquipment**

## CodeSystem: locationEquipment 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0261 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LocationEquipment |
| *Other Identifiers:*OID:2.16.840.1.113883.18.156 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to identify the equipment available in a location definition identified as a room or bed. Used in HL7 Version 2.x messaging in the LOC segment. 

 
Underlying Master Code System for V2 table 0261 (Location Equipment) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSLocationEquipment](ValueSet-v2-0261.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0261",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0261",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.156"
    }
  ],
  "version" : "2.0.0",
  "name" : "LocationEquipment",
  "title" : "locationEquipment",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to identify the equipment available in a location definition identified as a room or bed.  Used in HL7 Version 2.x messaging in the LOC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0261 (Location Equipment)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0261",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2572",
      "code" : "OXY",
      "display" : "Oxygen",
      "definition" : "Oxygen",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2573",
      "code" : "SUC",
      "display" : "Suction",
      "definition" : "Suction",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2574",
      "code" : "VIT",
      "display" : "Vital signs monitor",
      "definition" : "Vital signs monitor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2575",
      "code" : "INF",
      "display" : "Infusion pump",
      "definition" : "Infusion pump",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2576",
      "code" : "IVP",
      "display" : "IV pump",
      "definition" : "IV pump",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2577",
      "code" : "EEG",
      "display" : "Electro-Encephalogram",
      "definition" : "Electro-Encephalogram",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2578",
      "code" : "EKG",
      "display" : "Electro-Cardiogram",
      "definition" : "Electro-Cardiogram",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2579",
      "code" : "VEN",
      "display" : "Ventilator",
      "definition" : "Ventilator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
