# eventType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eventType**

## CodeSystem: eventType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0003 | *Version*:2.13.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EventType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.4 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. 

 
Underlying Master Code System for V2 table 0003 (Event Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSEventTypeCode](ValueSet-v2-0003.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0003",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0003",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.4"
    }
  ],
  "version" : "2.13.0",
  "name" : "EventType",
  "title" : "eventType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages.  Used in HL7 Version 2.x messaging in the MSH segment.",
  "purpose" : "Underlying Master Code System for V2 table 0003 (Event Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0003",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "123",
      "code" : "X01",
      "display" : "PEX - Product experience",
      "definition" : "PEX - Product experience",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "124",
      "code" : "A01",
      "display" : "ADT/ACK - Admit/visit notification",
      "definition" : "ADT/ACK - Admit/visit notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "stationäre Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "125",
      "code" : "A02",
      "display" : "ADT/ACK - Transfer a patient",
      "definition" : "ADT/ACK - Transfer a patient",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "126",
      "code" : "A03",
      "display" : "ADT/ACK -  Discharge/end visit",
      "definition" : "ADT/ACK -  Discharge/end visit",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Entlassung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "127",
      "code" : "A04",
      "display" : "ADT/ACK -  Register a patient",
      "definition" : "ADT/ACK -  Register a patient",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Besuchsmeldung (nicht-stationär)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "128",
      "code" : "A05",
      "display" : "ADT/ACK -  Pre-admit a patient",
      "definition" : "ADT/ACK -  Pre-admit a patient",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Voraufnahme eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "129",
      "code" : "A06",
      "display" : "ADT/ACK -  Change an outpatient to an inpatient",
      "definition" : "ADT/ACK -  Change an outpatient to an inpatient",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung von ambulant in stationär"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "130",
      "code" : "A07",
      "display" : "ADT/ACK -  Change an inpatient to an outpatient",
      "definition" : "ADT/ACK -  Change an inpatient to an outpatient",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung von stationär in ambulant"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "131",
      "code" : "A08",
      "display" : "ADT/ACK -  Update patient information",
      "definition" : "ADT/ACK -  Update patient information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung von Patienteninformationen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "132",
      "code" : "A09",
      "display" : "ADT/ACK -  Patient departing - tracking",
      "definition" : "ADT/ACK -  Patient departing - tracking",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient verläßt Einrichtung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "133",
      "code" : "A10",
      "display" : "ADT/ACK -  Patient arriving - tracking",
      "definition" : "ADT/ACK -  Patient arriving - tracking",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient erreicht Einrichtung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "134",
      "code" : "A11",
      "display" : "ADT/ACK -  Cancel admit/visit notification",
      "definition" : "ADT/ACK -  Cancel admit/visit notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung für A01 und A04"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "135",
      "code" : "A12",
      "display" : "ADT/ACK -  Cancel transfer",
      "definition" : "ADT/ACK -  Cancel transfer",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung für A02"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "136",
      "code" : "A13",
      "display" : "ADT/ACK -  Cancel discharge/end visit",
      "definition" : "ADT/ACK -  Cancel discharge/end visit",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung für A03"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "137",
      "code" : "A14",
      "display" : "ADT/ACK -  Pending admit",
      "definition" : "ADT/ACK -  Pending admit",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Geplante Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "138",
      "code" : "A15",
      "display" : "ADT/ACK -  Pending transfer",
      "definition" : "ADT/ACK -  Pending transfer",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Geplante Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "139",
      "code" : "A16",
      "display" : "ADT/ACK -  Pending discharge",
      "definition" : "ADT/ACK -  Pending discharge",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Geplante Entlassung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "140",
      "code" : "A17",
      "display" : "ADT/ACK -  Swap patients",
      "definition" : "ADT/ACK -  Swap patients",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Bettentausch zweier Patienten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "141",
      "code" : "A18",
      "display" : "ADT/ACK -  Merge patient information",
      "definition" : "ADT/ACK -  Merge patient information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patienteninformation zusammenführen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "142",
      "code" : "A19",
      "display" : "QRY/ADR -  Patient query",
      "definition" : "QRY/ADR -  Patient query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage nach Patientendaten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "143",
      "code" : "A20",
      "display" : "ADT/ACK -  Bed status update",
      "definition" : "ADT/ACK -  Bed status update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung des Bettenstatus"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "144",
      "code" : "A21",
      "display" : "ADT/ACK -  Patient goes on a \"leave of absence\"",
      "definition" : "ADT/ACK -  Patient goes on a \"leave of absence\"",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Beginn einer Patientenabwesenheit"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "145",
      "code" : "A22",
      "display" : "ADT/ACK -  Patient returns from a \"leave of absence\"",
      "definition" : "ADT/ACK -  Patient returns from a \"leave of absence\"",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ende einer Patientenabwesenheit"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "146",
      "code" : "A23",
      "display" : "ADT/ACK -  Delete a patient record",
      "definition" : "ADT/ACK -  Delete a patient record",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Löschen eines Patientensatzes"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "147",
      "code" : "A24",
      "display" : "ADT/ACK -  Link patient information",
      "definition" : "ADT/ACK -  Link patient information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verknüpfen von Patientendaten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "148",
      "code" : "A25",
      "display" : "ADT/ACK -  Cancel pending discharge",
      "definition" : "ADT/ACK -  Cancel pending discharge",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung einer eingeleiteten Entlassung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "149",
      "code" : "A26",
      "display" : "ADT/ACK -  Cancel pending transfer",
      "definition" : "ADT/ACK -  Cancel pending transfer",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung einer eingeleiteten Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "150",
      "code" : "A27",
      "display" : "ADT/ACK -  Cancel pending admit",
      "definition" : "ADT/ACK -  Cancel pending admit",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung einer eingeleiteten Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "151",
      "code" : "A28",
      "display" : "ADT/ACK -  Add person information",
      "definition" : "ADT/ACK -  Add person information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Personendaten hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "152",
      "code" : "A29",
      "display" : "ADT/ACK -  Delete person information",
      "definition" : "ADT/ACK -  Delete person information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Löschung von personenbezogenen Daten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "153",
      "code" : "A30",
      "display" : "ADT/ACK -  Merge person information",
      "definition" : "ADT/ACK -  Merge person information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "veraltet"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "154",
      "code" : "A31",
      "display" : "ADT/ACK -  Update person information",
      "definition" : "ADT/ACK -  Update person information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ändern personenbezogener Daten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "155",
      "code" : "A32",
      "display" : "ADT/ACK -  Cancel patient arriving - tracking",
      "definition" : "ADT/ACK -  Cancel patient arriving - tracking",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung eines Patientenzugangs (Bettenzuweisung)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "156",
      "code" : "A33",
      "display" : "ADT/ACK -  Cancel patient departing - tracking",
      "definition" : "ADT/ACK -  Cancel patient departing - tracking",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung eines Patientenabgangs (Bettenfreigabe)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "157",
      "code" : "A34",
      "display" : "ADT/ACK -  Merge patient information - patient ID only",
      "definition" : "ADT/ACK -  Merge patient information - patient ID only",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abgleich nur der Patientennummer (veraltet)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "158",
      "code" : "A35",
      "display" : "ADT/ACK -  Merge patient information - account number only",
      "definition" : "ADT/ACK -  Merge patient information - account number only",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abgleich nur der Abrechnungsnummer / Debitorenkontonummer (veraltet)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "159",
      "code" : "A36",
      "display" : "ADT/ACK -  Merge patient information - patient ID and account number",
      "definition" : "ADT/ACK -  Merge patient information - patient ID and account number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abgleich von Patientennummer und Abrechnungsnummer / Debitorenkontonummer (veraltet)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "160",
      "code" : "A37",
      "display" : "ADT/ACK -  Unlink patient information",
      "definition" : "ADT/ACK -  Unlink patient information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auflösung einer Verknüpfung von Patientendaten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "161",
      "code" : "A38",
      "display" : "ADT/ACK - Cancel pre-admit",
      "definition" : "ADT/ACK - Cancel pre-admit",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung zu A05"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "162",
      "code" : "A39",
      "display" : "ADT/ACK - Merge person - patient ID",
      "definition" : "ADT/ACK - Merge person - patient ID",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zusammenführung von Information über externe ID (veraltet)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "163",
      "code" : "A40",
      "display" : "ADT/ACK - Merge patient - patient identifier list",
      "definition" : "ADT/ACK - Merge patient - patient identifier list",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zusammenführung v. Pat-Information über ID-Liste"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "164",
      "code" : "A41",
      "display" : "ADT/ACK - Merge account - patient account number",
      "definition" : "ADT/ACK - Merge account - patient account number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zusammenführung von Konten über Kontonummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "165",
      "code" : "A42",
      "display" : "ADT/ACK - Merge visit - visit number",
      "definition" : "ADT/ACK - Merge visit - visit number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zusammenführung v.Fall-Information über Fallnummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "166",
      "code" : "A43",
      "display" : "ADT/ACK - Move patient information - patient identifier list",
      "definition" : "ADT/ACK - Move patient information - patient identifier list",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Korrektur einer falschen Zuordnung bzgl. PID-Liste"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "167",
      "code" : "A44",
      "display" : "ADT/ACK - Move account information - patient account number",
      "definition" : "ADT/ACK - Move account information - patient account number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Korrektur einer falschen Zuordnung bzgl.Abrechungsnummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "168",
      "code" : "A45",
      "display" : "ADT/ACK - Move visit information - visit number",
      "definition" : "ADT/ACK - Move visit information - visit number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Korrektur einer falschen Zuordnung bzgl.Fallnummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "169",
      "code" : "A46",
      "display" : "ADT/ACK - Change patient ID",
      "definition" : "ADT/ACK - Change patient ID",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung der externen Pat.ID (PID-2)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "170",
      "code" : "A47",
      "display" : "ADT/ACK - Change patient identifier list",
      "definition" : "ADT/ACK - Change patient identifier list",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung der internen Pat.ID (PID-3)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "171",
      "code" : "A48",
      "display" : "ADT/ACK - Change alternate patient ID",
      "definition" : "ADT/ACK - Change alternate patient ID",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung der alternativen Pat.ID (PID-4)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "172",
      "code" : "A49",
      "display" : "ADT/ACK - Change patient account number",
      "definition" : "ADT/ACK - Change patient account number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung der Abrechungsnummer (PID-18)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "173",
      "code" : "A50",
      "display" : "ADT/ACK - Change visit number",
      "definition" : "ADT/ACK - Change visit number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung der Fallnummer (PV1-19)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "174",
      "code" : "A51",
      "display" : "ADT/ACK - Change alternate visit ID",
      "definition" : "ADT/ACK - Change alternate visit ID",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung der alternativen Fallnummer (PV1-50)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "175",
      "code" : "A52",
      "display" : "ADT/ACK - Cancel leave of absence for a patient",
      "definition" : "ADT/ACK - Cancel leave of absence for a patient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "176",
      "code" : "A53",
      "display" : "ADT/ACK - Cancel patient returns from a leave of absence",
      "definition" : "ADT/ACK - Cancel patient returns from a leave of absence",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "177",
      "code" : "A54",
      "display" : "ADT/ACK - Change attending doctor",
      "definition" : "ADT/ACK - Change attending doctor",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung des behandelnden Arztes"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "178",
      "code" : "A55",
      "display" : "ADT/ACK - Cancel change attending doctor",
      "definition" : "ADT/ACK - Cancel change attending doctor",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung der Änderung des behandelnden Arztes"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "179",
      "code" : "A60",
      "display" : "ADT/ACK - Update allergy information",
      "definition" : "ADT/ACK - Update allergy information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aktualisierung der Allergie-Informationen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "180",
      "code" : "A61",
      "display" : "ADT/ACK - Change consulting doctor",
      "definition" : "ADT/ACK - Change consulting doctor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "181",
      "code" : "A62",
      "display" : "ADT/ACK - Cancel change consulting doctor",
      "definition" : "ADT/ACK - Cancel change consulting doctor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "182",
      "code" : "B01",
      "display" : "PMU/ACK - Add personnel record",
      "definition" : "PMU/ACK - Add personnel record",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "183",
      "code" : "B02",
      "display" : "PMU/ACK - Update personnel record",
      "definition" : "PMU/ACK - Update personnel record",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "184",
      "code" : "B03",
      "display" : "PMU/ACK - Delete personnel re cord",
      "definition" : "PMU/ACK - Delete personnel re cord",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "185",
      "code" : "B04",
      "display" : "PMU/ACK - Active practicing person",
      "definition" : "PMU/ACK - Active practicing person",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "186",
      "code" : "B05",
      "display" : "PMU/ACK - Deactivate practicing person",
      "definition" : "PMU/ACK - Deactivate practicing person",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "187",
      "code" : "B06",
      "display" : "PMU/ACK - Terminate practicing person",
      "definition" : "PMU/ACK - Terminate practicing person",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "188",
      "code" : "B07",
      "display" : "PMU/ACK - Grant Certificate/Permission",
      "definition" : "PMU/ACK - Grant Certificate/Permission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "189",
      "code" : "B08",
      "display" : "PMU/ACK - Revoke Certificate/Permission",
      "definition" : "PMU/ACK - Revoke Certificate/Permission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "190",
      "code" : "C01",
      "display" : "CRM - Register a patient on a clinical trial",
      "definition" : "CRM - Register a patient on a clinical trial",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Registrierung eines Patienten f.eine klin.Studie"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "191",
      "code" : "C02",
      "display" : "CRM - Cancel a patient registration on clinical trial (for clerical mistakes only)",
      "definition" : "CRM - Cancel a patient registration on clinical trial (for clerical mistakes only)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Löschung der Registrierung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "192",
      "code" : "C03",
      "display" : "CRM - Correct/update registration information",
      "definition" : "CRM - Correct/update registration information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Korrektur/Änderung der Registrierung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "193",
      "code" : "C04",
      "display" : "CRM - Patient has gone off a clinical trial",
      "definition" : "CRM - Patient has gone off a clinical trial",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient ist aus der Studie ausgeschieden"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "194",
      "code" : "C05",
      "display" : "CRM - Patient enters phase of clinical trial",
      "definition" : "CRM - Patient enters phase of clinical trial",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient tritt in Studienphase ein"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "195",
      "code" : "C06",
      "display" : "CRM - Cancel patient entering a phase (clerical mistake)",
      "definition" : "CRM - Cancel patient entering a phase (clerical mistake)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Löschung des Eintritts in eine Studienphase"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "196",
      "code" : "C07",
      "display" : "CRM - Correct/update phase information",
      "definition" : "CRM - Correct/update phase information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Korrektur/Änderung der Angaben zur Studienphase"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "197",
      "code" : "C08",
      "display" : "CRM - Patient has gone off phase of clinical trial",
      "definition" : "CRM - Patient has gone off phase of clinical trial",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient ist aus Studienphase ausgeschieden"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "198",
      "code" : "C09",
      "display" : "CSU - Automated time intervals for reporting, like monthly",
      "definition" : "CSU - Automated time intervals for reporting, like monthly",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Festlegung des Zeitintervalls für autom. Berichte"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "199",
      "code" : "C10",
      "display" : "CSU - Patient completes the clinical trial",
      "definition" : "CSU - Patient completes the clinical trial",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient beendet Studie"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "200",
      "code" : "C11",
      "display" : "CSU - Patient completes a phase of the clinical trial",
      "definition" : "CSU - Patient completes a phase of the clinical trial",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Patient beendet eine Studienphase"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "201",
      "code" : "C12",
      "display" : "CSU - Update/correction of patient order/result information",
      "definition" : "CSU - Update/correction of patient order/result information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Korrektur/Änderung von Anforderungen/Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "202",
      "code" : "CNQ",
      "display" : "Cancel Query",
      "definition" : "Cancel Query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung einer Anfrage"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "203",
      "code" : "E01",
      "display" : "Submit HealthCare Services Invoice",
      "definition" : "Submit HealthCare Services Invoice",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "204",
      "code" : "E02",
      "display" : "Cancel HealthCare Services Invoice",
      "definition" : "Cancel HealthCare Services Invoice",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "205",
      "code" : "E03",
      "display" : "HealthCare Services Invoice Status",
      "definition" : "HealthCare Services Invoice Status",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "206",
      "code" : "varies",
      "display" : "MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)",
      "definition" : "MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "allgemeine Stammdatenanfrage"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "207",
      "code" : "E04",
      "display" : "Re-Assess HealthCare Services Invoice Request",
      "definition" : "Re-Assess HealthCare Services Invoice Request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "208",
      "code" : "E10",
      "display" : "Edit/Adjudication Results",
      "definition" : "Edit/Adjudication Results",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "209",
      "code" : "E12",
      "display" : "Request Additional Information",
      "definition" : "Request Additional Information",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "210",
      "code" : "E13",
      "display" : "Additional Information Response",
      "definition" : "Additional Information Response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "211",
      "code" : "E15",
      "display" : "Payment/Remittance Advice",
      "definition" : "Payment/Remittance Advice",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "212",
      "code" : "E20",
      "display" : "Submit Authorization Request",
      "definition" : "Submit Authorization Request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "213",
      "code" : "E21",
      "display" : "Cancel Authorization Request",
      "definition" : "Cancel Authorization Request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "214",
      "code" : "E22",
      "display" : "Authorization Request Status",
      "definition" : "Authorization Request Status",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "215",
      "code" : "E24",
      "display" : "Authorization Response",
      "definition" : "Authorization Response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "216",
      "code" : "E30",
      "display" : "Submit Health Document related to Authorization Request",
      "definition" : "Submit Health Document related to Authorization Request",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "reserved for future/not yet defined"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "reserved for future/not yet defined"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "217",
      "code" : "E31",
      "display" : "Cancel Health Document related to Authorization Request",
      "definition" : "Cancel Health Document related to Authorization Request",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "reserved for future/not yet defined"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "reserved for future/not yet defined"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "218",
      "code" : "I01",
      "display" : "RQI/RPI - Request for insurance information",
      "definition" : "RQI/RPI - Request for insurance information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung von Versicherungsdaten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "219",
      "code" : "I02",
      "display" : "RQI/RPL - Request/receipt of patient selection display list",
      "definition" : "RQI/RPL - Request/receipt of patient selection display list",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderg.einer Patientenauswahlliste (zur Anzeige)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "220",
      "code" : "I03",
      "display" : "RQI/RPR - Request/receipt of patient selection list",
      "definition" : "RQI/RPR - Request/receipt of patient selection list",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderg.einer strukt. Patientenauswahlliste"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "221",
      "code" : "I04",
      "display" : "RQD/RPI - Request for patient demographic data",
      "definition" : "RQD/RPI - Request for patient demographic data",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung demographischer Informationen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "222",
      "code" : "I05",
      "display" : "RQC/RCI - Request for patient clinical information",
      "definition" : "RQC/RCI - Request for patient clinical information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung klinischer Informationen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "223",
      "code" : "I06",
      "display" : "RQC/RCL - Request/receipt of clinical data listing",
      "definition" : "RQC/RCL - Request/receipt of clinical data listing",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung strukt. klinischer Informationen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "224",
      "code" : "I07",
      "display" : "PIN/ACK - Unsolicited insurance information",
      "definition" : "PIN/ACK - Unsolicited insurance information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unaufgeforderte Übermittlung v. Versicherungsdaten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "225",
      "code" : "I08",
      "display" : "RQA/RPA - Request for treatment authorization information",
      "definition" : "RQA/RPA - Request for treatment authorization information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "226",
      "code" : "I09",
      "display" : "RQA/RPA - Request for modification to an authorization",
      "definition" : "RQA/RPA - Request for modification to an authorization",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderg bzgl. Änderung Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "227",
      "code" : "I10",
      "display" : "RQA/RPA - Request for resubmission of an authorization",
      "definition" : "RQA/RPA - Request for resubmission of an authorization",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "erneute Anforderung Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "228",
      "code" : "I11",
      "display" : "RQA/RPA - Request for cancellation of an authorization",
      "definition" : "RQA/RPA - Request for cancellation of an authorization",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfordrg Stornierg einer Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "229",
      "code" : "I12",
      "display" : "REF/RRI - Patient referral",
      "definition" : "REF/RRI - Patient referral",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Überweisung eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "230",
      "code" : "I13",
      "display" : "REF/RRI - Modify patient referral",
      "definition" : "REF/RRI - Modify patient referral",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung einer Patientenüberweisung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "231",
      "code" : "I14",
      "display" : "REF/RRI - Cancel patient referral",
      "definition" : "REF/RRI - Cancel patient referral",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung einer Patientenüberweisung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "232",
      "code" : "I15",
      "display" : "REF/RRI - Request patient referral status",
      "definition" : "REF/RRI - Request patient referral status",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Statusabfrage bzgl. Patientenüberweisung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "233",
      "code" : "I16",
      "display" : "Collaborative Care Referral",
      "definition" : "Collaborative Care Referral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "234",
      "code" : "I17",
      "display" : "Modify Collaborative Care Referral",
      "definition" : "Modify Collaborative Care Referral",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "235",
      "code" : "I18",
      "display" : "Cancel Collaborative Care Referral",
      "definition" : "Cancel Collaborative Care Referral",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "236",
      "code" : "I19",
      "display" : "Collaborative Care Query/Collaborative Care Query Update",
      "definition" : "Collaborative Care Query/Collaborative Care Query Update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "237",
      "code" : "I20",
      "display" : "Asynchronous Collaborative Care Update",
      "definition" : "Asynchronous Collaborative Care Update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "238",
      "code" : "I21",
      "display" : "Collaborative Care Message",
      "definition" : "Collaborative Care Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "239",
      "code" : "I22",
      "display" : "Collaborative Care Fetch / Collaborative Care Information",
      "definition" : "Collaborative Care Fetch / Collaborative Care Information",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "240",
      "code" : "J01",
      "display" : "QCN/ACK - Cancel query/acknowledge message",
      "definition" : "QCN/ACK - Cancel query/acknowledge message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "241",
      "code" : "J02",
      "display" : "QSX/ACK - Cancel subscription/acknowledge message",
      "definition" : "QSX/ACK - Cancel subscription/acknowledge message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "242",
      "code" : "K11",
      "display" : "RSP - Segment pattern response in response to QBP^Q11",
      "definition" : "RSP - Segment pattern response in response to QBP^Q11",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "243",
      "code" : "K13",
      "display" : "RTB - Tabular response in response to QBP^Q13",
      "definition" : "RTB - Tabular response in response to QBP^Q13",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "244",
      "code" : "K15",
      "display" : "RDY - Display response in response to QBP^Q15",
      "definition" : "RDY - Display response in response to QBP^Q15",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "245",
      "code" : "K21",
      "display" : "RSP - Get person demographics response",
      "definition" : "RSP - Get person demographics response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "246",
      "code" : "K22",
      "display" : "RSP - Find candidates response",
      "definition" : "RSP - Find candidates response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "247",
      "code" : "K23",
      "display" : "RSP - Get corresponding identifiers response",
      "definition" : "RSP - Get corresponding identifiers response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "248",
      "code" : "K24",
      "display" : "RSP - Allocate identifiers response",
      "definition" : "RSP - Allocate identifiers response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "249",
      "code" : "K25",
      "display" : "RSP - Personnel Information by Segment Response",
      "definition" : "RSP - Personnel Information by Segment Response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "250",
      "code" : "K31",
      "display" : "RSP -Dispense History Response",
      "definition" : "RSP -Dispense History Response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "251",
      "code" : "K32",
      "display" : "Find Candidates including Visit Information Response",
      "definition" : "Find Candidates including Visit Information Response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "252",
      "code" : "K33",
      "display" : "Get Donor Record Candidates Response Message",
      "definition" : "Get Donor Record Candidates Response Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "253",
      "code" : "K34",
      "display" : "Segment Pattern Response Message",
      "definition" : "Segment Pattern Response Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "254",
      "code" : "M01",
      "display" : "MFN/MFK - Master file not otherwise specified",
      "definition" : "MFN/MFK - Master file not otherwise specified",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung (veraltet)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "255",
      "code" : "M02",
      "display" : "MFN/MFK - Master file - staff practitioner",
      "definition" : "MFN/MFK - Master file - staff practitioner",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Ärzte"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "256",
      "code" : "M03",
      "display" : "MFN/MFK - Master file - test/observation",
      "definition" : "MFN/MFK - Master file - test/observation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Tests / Untersuchungen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "257",
      "code" : "M04",
      "display" : "MFN/MFK - Master files charge description",
      "definition" : "MFN/MFK - Master files charge description",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - delayed appl ack"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "258",
      "code" : "M05",
      "display" : "MFN/MFK - Patient location master file",
      "definition" : "MFN/MFK - Patient location master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Aufenthaltsorte"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "259",
      "code" : "M06",
      "display" : "MFN/MFK - Clinical study with phases and schedules master file",
      "definition" : "MFN/MFK - Clinical study with phases and schedules master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Abrechnungskataloge"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "260",
      "code" : "M07",
      "display" : "MFN/MFK - Clinical study without phases but with schedules master file",
      "definition" : "MFN/MFK - Clinical study without phases but with schedules master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - klinische Studien ohne Phasen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "261",
      "code" : "M08",
      "display" : "MFN/MFK - Test/observation (numeric) master file",
      "definition" : "MFN/MFK - Test/observation (numeric) master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Tests/Untersuchung mit numerischen Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "262",
      "code" : "M09",
      "display" : "MFN/MFK - Test/observation (categorical) master file",
      "definition" : "MFN/MFK - Test/observation (categorical) master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Tests mit nicht numerischen Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "263",
      "code" : "M10",
      "display" : "MFN/MFK - Test /observation batteries master file",
      "definition" : "MFN/MFK - Test /observation batteries master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - Testprofile"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "264",
      "code" : "M11",
      "display" : "MFN/MFK - Test/calculated observations master file",
      "definition" : "MFN/MFK - Test/calculated observations master file",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stammdatenänderung - berechnete Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "265",
      "code" : "M12",
      "display" : "MFN/MFK - Master file notification message",
      "definition" : "MFN/MFK - Master file notification message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "266",
      "code" : "M13",
      "display" : "MFN/MFK - Master file notification - general",
      "definition" : "MFN/MFK - Master file notification - general",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "267",
      "code" : "M14",
      "display" : "MFN/MFK - Master file notification - site defined",
      "definition" : "MFN/MFK - Master file notification - site defined",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "268",
      "code" : "M15",
      "display" : "MFN/MFK - Inventory item master file notification",
      "definition" : "MFN/MFK - Inventory item master file notification",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "269",
      "code" : "R0R",
      "display" : "R0R - Pharmacy prescription order query response",
      "definition" : "R0R - Pharmacy prescription order query response",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "270",
      "code" : "M16",
      "display" : "MFN/MFK - Master File Notification Inventory Item Enhanced",
      "definition" : "MFN/MFK - Master File Notification Inventory Item Enhanced",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "271",
      "code" : "M17",
      "display" : "DRG Master File Message",
      "definition" : "DRG Master File Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "272",
      "code" : "M18",
      "display" : "MFN/MFK - Master file notification - Test/Observation (Payer)",
      "definition" : "MFN/MFK - Master file notification - Test/Observation (Payer)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "273",
      "code" : "N01",
      "display" : "NMQ/NMR - Application management query message",
      "definition" : "NMQ/NMR - Application management query message",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "274",
      "code" : "N02",
      "display" : "NMD/ACK - Application management data message (unsolicited)",
      "definition" : "NMD/ACK - Application management data message (unsolicited)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "275",
      "code" : "O01",
      "display" : "ORM - Order message (also RDE, RDS, RGV, RAS)",
      "definition" : "ORM - Order message (also RDE, RDS, RGV, RAS)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag / Verordnung"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "276",
      "code" : "O02",
      "display" : "ORR - Order response (also RRE, RRD, RRG, RRA)",
      "definition" : "ORR - Order response (also RRE, RRD, RRG, RRA)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "277",
      "code" : "O03",
      "display" : "OMD - Diet order",
      "definition" : "OMD - Diet order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "278",
      "code" : "O04",
      "display" : "ORD - Diet order acknowledgment",
      "definition" : "ORD - Diet order acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "279",
      "code" : "O05",
      "display" : "OMS - Stock requisition order",
      "definition" : "OMS - Stock requisition order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "280",
      "code" : "O06",
      "display" : "ORS - Stock requisition acknowledgment",
      "definition" : "ORS - Stock requisition acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "281",
      "code" : "O07",
      "display" : "OMN - Non-stock requisition order",
      "definition" : "OMN - Non-stock requisition order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "282",
      "code" : "O08",
      "display" : "ORN - Non-stock requisition acknowledgment",
      "definition" : "ORN - Non-stock requisition acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "283",
      "code" : "O09",
      "display" : "OMP - Pharmacy/treatment order",
      "definition" : "OMP - Pharmacy/treatment order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "284",
      "code" : "O10",
      "display" : "ORP - Pharmacy/treatment order acknowledgment",
      "definition" : "ORP - Pharmacy/treatment order acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "285",
      "code" : "O11",
      "display" : "RDE - Pharmacy/treatment encoded order",
      "definition" : "RDE - Pharmacy/treatment encoded order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "286",
      "code" : "O12",
      "display" : "RRE - Pharmacy/treatment encoded order acknowledgment",
      "definition" : "RRE - Pharmacy/treatment encoded order acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "287",
      "code" : "O13",
      "display" : "RDS - Pharmacy/treatment dispense",
      "definition" : "RDS - Pharmacy/treatment dispense",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "288",
      "code" : "O14",
      "display" : "RRD - Pharmacy/treatment dispense acknowledgment",
      "definition" : "RRD - Pharmacy/treatment dispense acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "289",
      "code" : "O15",
      "display" : "RGV - Pharmacy/treatment give",
      "definition" : "RGV - Pharmacy/treatment give",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "290",
      "code" : "O16",
      "display" : "RRG - Pharmacy/treatment give acknowledgment",
      "definition" : "RRG - Pharmacy/treatment give acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "291",
      "code" : "O17",
      "display" : "RAS - Pharmacy/treatment administration",
      "definition" : "RAS - Pharmacy/treatment administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "292",
      "code" : "O18",
      "display" : "RRA - Pharmacy/treatment administration acknowledgment",
      "definition" : "RRA - Pharmacy/treatment administration acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "293",
      "code" : "O19",
      "display" : "OMG - General clinical order",
      "definition" : "OMG - General clinical order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "294",
      "code" : "O20",
      "display" : "ORG/ORL - General clinical order response",
      "definition" : "ORG/ORL - General clinical order response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "295",
      "code" : "O21",
      "display" : "OML - Laboratory order",
      "definition" : "OML - Laboratory order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "296",
      "code" : "O22",
      "display" : "ORL - General laboratory order response message to any OML",
      "definition" : "ORL - General laboratory order response message to any OML",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "297",
      "code" : "O23",
      "display" : "OMI - Imaging order",
      "definition" : "OMI - Imaging order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "298",
      "code" : "O24",
      "display" : "ORI - Imaging order response message to any OMI",
      "definition" : "ORI - Imaging order response message to any OMI",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "299",
      "code" : "O25",
      "display" : "RDE - Pharmacy/treatment refill authorization request",
      "definition" : "RDE - Pharmacy/treatment refill authorization request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "300",
      "code" : "O26",
      "display" : "RRE - Pharmacy/Treatment Refill Authorization Acknowledgement",
      "definition" : "RRE - Pharmacy/Treatment Refill Authorization Acknowledgement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "301",
      "code" : "O27",
      "display" : "OMB - Blood product order",
      "definition" : "OMB - Blood product order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "302",
      "code" : "O28",
      "display" : "ORB - Blood product order acknowledgment",
      "definition" : "ORB - Blood product order acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "303",
      "code" : "O29",
      "display" : "BPS - Blood product dispense status",
      "definition" : "BPS - Blood product dispense status",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "304",
      "code" : "O30",
      "display" : "BRP - Blood product dispense status acknowledgment",
      "definition" : "BRP - Blood product dispense status acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "305",
      "code" : "O31",
      "display" : "BTS - Blood product transfusion/disposition",
      "definition" : "BTS - Blood product transfusion/disposition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "306",
      "code" : "O32",
      "display" : "BRT - Blood product transfusion/disposition acknowledgment",
      "definition" : "BRT - Blood product transfusion/disposition acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "307",
      "code" : "O33",
      "display" : "OML - Laboratory order for multiple orders related to a single specimen",
      "definition" : "OML - Laboratory order for multiple orders related to a single specimen",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "308",
      "code" : "O34",
      "display" : "ORL - Laboratory order response message to a multiple order related to single specimen OML",
      "definition" : "ORL - Laboratory order response message to a multiple order related to single specimen OML",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "309",
      "code" : "O35",
      "display" : "OML - Laboratory order for multiple orders related to a single container of a specimen",
      "definition" : "OML - Laboratory order for multiple orders related to a single container of a specimen",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "310",
      "code" : "R05",
      "display" : "QRY/DSR - query for display results (See Q01)",
      "definition" : "QRY/DSR - query for display results (See Q01)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage nach anzeigeorientierten Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "311",
      "code" : "O36",
      "display" : "ORL - Laboratory order response message to a single container of a specimen OML",
      "definition" : "ORL - Laboratory order response message to a single container of a specimen OML",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "312",
      "code" : "R06",
      "display" : "UDM - unsolicited update/display results (See Q05)",
      "definition" : "UDM - unsolicited update/display results (See Q05)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unaufgeforderte Änderung anzeigeorientierter Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "313",
      "code" : "O37",
      "display" : "OPL - Population/Location-Based Laboratory Order Message",
      "definition" : "OPL - Population/Location-Based Laboratory Order Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "314",
      "code" : "O38",
      "display" : "OPR - Population/Location-Based Laboratory Order Acknowledgment Message",
      "definition" : "OPR - Population/Location-Based Laboratory Order Acknowledgment Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "315",
      "code" : "O39",
      "display" : "Specimen shipment centric laboratory order",
      "definition" : "Specimen shipment centric laboratory order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "316",
      "code" : "O40",
      "display" : "Specimen Shipment Centric Laboratory Order Acknowledgment Message",
      "definition" : "Specimen Shipment Centric Laboratory Order Acknowledgment Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "317",
      "code" : "O41",
      "display" : "DBC - Create Donor Record Message",
      "definition" : "DBC - Create Donor Record Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "318",
      "code" : "O42",
      "display" : "DBU - Update Donor Record Message",
      "definition" : "DBU - Update Donor Record Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "319",
      "code" : "RAR",
      "display" : "RAR - Pharmacy administration information query response",
      "definition" : "RAR - Pharmacy administration information query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort bzgl. der Behandlungs-/Darreichungsform"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "320",
      "code" : "O43",
      "display" : "General Order Message with Document Payload Acknowledgement Message",
      "definition" : "General Order Message with Document Payload Acknowledgement Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "321",
      "code" : "RDR",
      "display" : "RDR - Pharmacy dispense information query response",
      "definition" : "RDR - Pharmacy dispense information query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort bzgl. des zu verabreichenden Medikamentes bzw. der Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "322",
      "code" : "Q04",
      "display" : "EQQ - Embedded query language query",
      "definition" : "EQQ - Embedded query language query",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "323",
      "code" : "O44",
      "display" : "Donor Registration - Minimal Message",
      "definition" : "Donor Registration - Minimal Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "324",
      "code" : "RER",
      "display" : "RER - Pharmacy encoded order information query response",
      "definition" : "RER - Pharmacy encoded order information query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort bzgl. des zu verabreichenden Medikamentes bzw. der Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "325",
      "code" : "O45",
      "display" : "Donor Eligibility Observations Message",
      "definition" : "Donor Eligibility Observations Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "326",
      "code" : "RGR",
      "display" : "RGR - Pharmacy dose information query response",
      "definition" : "RGR - Pharmacy dose information query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort bzgl. der Dosis bzw. der Frequenz der Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "327",
      "code" : "O46",
      "display" : "Donor Eligiblity Message",
      "definition" : "Donor Eligiblity Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "328",
      "code" : "Q07",
      "display" : "VQQ - Virtual table query",
      "definition" : "VQQ - Virtual table query",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "329",
      "code" : "O47",
      "display" : "Donor Request to Collect Message",
      "definition" : "Donor Request to Collect Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "330",
      "code" : "Q08",
      "display" : "SPQ - Stored procedure request",
      "definition" : "SPQ - Stored procedure request",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "331",
      "code" : "O48",
      "display" : "Donation Procedure Message",
      "definition" : "Donation Procedure Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "332",
      "code" : "Q09",
      "display" : "RQQ - event replay query",
      "definition" : "RQQ - event replay query",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "333",
      "code" : "O49",
      "display" : "Pharmacy/Treatment Dispense Request Message",
      "definition" : "Pharmacy/Treatment Dispense Request Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "334",
      "code" : "O50",
      "display" : "Pharmacy/Treatment Encoded Order Acknowledgment",
      "definition" : "Pharmacy/Treatment Encoded Order Acknowledgment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "335",
      "code" : "O51",
      "display" : "OSU – Order Status Update",
      "definition" : "OSU – Order Status Update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "336",
      "code" : "O52",
      "display" : "OSU – Order Status Update Acknowledgement",
      "definition" : "OSU – Order Status Update Acknowledgement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "337",
      "code" : "O53",
      "display" : "ORL - General Laboratory Order Acknowledgment Message (Patient Optional)",
      "definition" : "ORL - General Laboratory Order Acknowledgment Message (Patient Optional)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "338",
      "code" : "O54",
      "display" : "ORL - Laboratory Order Acknowledgment Message  – Multiple Order Per Specimen (Patient Optional)",
      "definition" : "ORL - Laboratory Order Acknowledgment Message  – Multiple Order Per Specimen (Patient Optional)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "339",
      "code" : "O55",
      "display" : "ORL - Laboratory Order Acknowledgment Message  – Multiple Order Per Container of Specimen (Patient Optional)",
      "definition" : "ORL - Laboratory Order Acknowledgment Message  – Multiple Order Per Container of Specimen (Patient Optional)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "340",
      "code" : "O56",
      "display" : "ORL - Specimen Shipment Centric Laboratory Order Acknowledgment Message (Patient Optional)",
      "definition" : "ORL - Specimen Shipment Centric Laboratory Order Acknowledgment Message (Patient Optional)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "341",
      "code" : "O57",
      "display" : "OMQ- General Order Message with Document Payload",
      "definition" : "OMQ- General Order Message with Document Payload",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "B"
        }
      ]
    },
    {
      "id" : "342",
      "code" : "O58",
      "display" : "ORX - General Order Message with Document Payload Acknowledgement Message",
      "definition" : "ORX - General Order Message with Document Payload Acknowledgement Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "343",
      "code" : "O59",
      "display" : "OML - Laboratory order for additional work up",
      "definition" : "Fulfillment order for work up on a previously communicated result or submitted specimen",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "An example is the IHE LCC profile describes this message in the LAB-7 transaction"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "344",
      "code" : "P01",
      "display" : "BAR/ACK - Add patient accounts",
      "definition" : "BAR/ACK - Add patient accounts",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Eröffnung eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "345",
      "code" : "P02",
      "display" : "BAR/ACK - Purge patient accounts",
      "definition" : "BAR/ACK - Purge patient accounts",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Löschen der Abrechnungsdaten eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "346",
      "code" : "P03",
      "display" : "DFT/ACK - Post detail financial transaction",
      "definition" : "DFT/ACK - Post detail financial transaction",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Leistungs- und Abrechnungsinformationen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "347",
      "code" : "P04",
      "display" : "QRY/DSP - Generate bill and A/R statements",
      "definition" : "QRY/DSP - Generate bill and A/R statements",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Druck und Anzeige von Rechnungen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "348",
      "code" : "P05",
      "display" : "BAR/ACK - Update account",
      "definition" : "BAR/ACK - Update account",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "349",
      "code" : "P06",
      "display" : "BAR/ACK - End account",
      "definition" : "BAR/ACK - End account",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abschluß eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "350",
      "code" : "P07",
      "display" : "PEX - Unsolicited initial individual product experience report",
      "definition" : "PEX - Unsolicited initial individual product experience report",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unaufgeforderte individueller Produktersterfahrungsbericht"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "351",
      "code" : "R03",
      "display" : "QRY/DSR Display-oriented results, query/unsol. update (for backward compatibility only) (Replaced by Q05)",
      "definition" : "QRY/DSR Display-oriented results, query/unsol. update (for backward compatibility only) (Replaced by Q05)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anzeigeorientiertes Ergebnis"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "352",
      "code" : "P08",
      "display" : "PEX - Unsolicited update individual product experience report",
      "definition" : "PEX - Unsolicited update individual product experience report",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung individueller Produktersterfahrungsbericht"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "353",
      "code" : "P09",
      "display" : "SUR - Summary product experience report",
      "definition" : "SUR - Summary product experience report",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "zusammenfassender Produkterfahrungsbericht"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "354",
      "code" : "P10",
      "display" : "BAR/ACK -Transmit Ambulatory Payment  Classification(APC)",
      "definition" : "BAR/ACK -Transmit Ambulatory Payment  Classification(APC)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "355",
      "code" : "R07",
      "display" : "EDR - Enhanced Display Response",
      "definition" : "EDR - Enhanced Display Response",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "356",
      "code" : "P11",
      "display" : "DFT/ACK - Post Detail Financial Transactions - New",
      "definition" : "DFT/ACK - Post Detail Financial Transactions - New",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "357",
      "code" : "R08",
      "display" : "TBR - Tabular Data Response",
      "definition" : "TBR - Tabular Data Response",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "358",
      "code" : "P12",
      "display" : "BAR/ACK - Update Diagnosis/Procedure",
      "definition" : "BAR/ACK - Update Diagnosis/Procedure",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "359",
      "code" : "PC1",
      "display" : "PPR - PC/ problem add",
      "definition" : "PPR - PC/ problem add",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Problem hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "360",
      "code" : "R09",
      "display" : "ERP - Event Replay Response",
      "definition" : "ERP - Event Replay Response",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "361",
      "code" : "PC2",
      "display" : "PPR - PC/ problem update",
      "definition" : "PPR - PC/ problem update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Problem ändern"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "362",
      "code" : "PC3",
      "display" : "PPR - PC/ problem delete",
      "definition" : "PPR - PC/ problem delete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Problem löschen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "363",
      "code" : "PC4",
      "display" : "QRY - PC/ problem query",
      "definition" : "QRY - PC/ problem query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Problem abfragen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "364",
      "code" : "PC5",
      "display" : "PRR - PC/ problem response",
      "definition" : "PRR - PC/ problem response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Problem Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "365",
      "code" : "PC6",
      "display" : "PGL - PC/ goal add",
      "definition" : "PGL - PC/ goal add",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ziel hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "366",
      "code" : "PC7",
      "display" : "PGL - PC/ goal update",
      "definition" : "PGL - PC/ goal update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ziel ändern"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "367",
      "code" : "PC8",
      "display" : "PGL - PC/ goal delete",
      "definition" : "PGL - PC/ goal delete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ziel löschen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "368",
      "code" : "PC9",
      "display" : "QRY - PC/ goal query",
      "definition" : "QRY - PC/ goal query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ziel abfragen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "369",
      "code" : "PCA",
      "display" : "PPV - PC/ goal response",
      "definition" : "PPV - PC/ goal response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ziel Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "370",
      "code" : "PCB",
      "display" : "PPP - PC/ pathway (problem-oriented) add",
      "definition" : "PPP - PC/ pathway (problem-oriented) add",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(problemorientierte) Leitlinie hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "371",
      "code" : "PCC",
      "display" : "PPP - PC/ pathway (problem-oriented) update",
      "definition" : "PPP - PC/ pathway (problem-oriented) update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(problemorientierte) Leitlinie ändern"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "372",
      "code" : "PCD",
      "display" : "PPP - PC/ pathway (problem-oriented) delete",
      "definition" : "PPP - PC/ pathway (problem-oriented) delete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(problemorientierte) Leitlinie löschen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "373",
      "code" : "PCE",
      "display" : "QRY - PC/ pathway (problem-oriented) query",
      "definition" : "QRY - PC/ pathway (problem-oriented) query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(problemorientierte) Leitlinie abfragen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "374",
      "code" : "PCF",
      "display" : "PTR - PC/ pathway (problem-oriented) query response",
      "definition" : "PTR - PC/ pathway (problem-oriented) query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(problemorientierte) Leitlinie Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "375",
      "code" : "PCG",
      "display" : "PPG - PC/ pathway (goal-oriented) add",
      "definition" : "PPG - PC/ pathway (goal-oriented) add",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(zielorientierte) Leitlinie hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "376",
      "code" : "PCH",
      "display" : "PPG - PC/ pathway (goal-oriented) update",
      "definition" : "PPG - PC/ pathway (goal-oriented) update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(zielorientierte) Leitlinie ändern"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "377",
      "code" : "PCJ",
      "display" : "PPG - PC/ pathway (goal-oriented) delete",
      "definition" : "PPG - PC/ pathway (goal-oriented) delete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(zielorientierte) Leitlinie löschen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "378",
      "code" : "PCK",
      "display" : "QRY - PC/ pathway (goal-oriented) query",
      "definition" : "QRY - PC/ pathway (goal-oriented) query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(zielorientierte) Leitlinie abfragen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "379",
      "code" : "PCL",
      "display" : "PPT - PC/ pathway (goal-oriented) query response",
      "definition" : "PPT - PC/ pathway (goal-oriented) query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "(zielorientierte) Leitlinie Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "380",
      "code" : "Q01",
      "display" : "QRY/DSR - Query sent for immediate response",
      "definition" : "QRY/DSR - Query sent for immediate response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage mit sofortiger Antwort"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "381",
      "code" : "Q02",
      "display" : "QRY/QCK - Query sent for deferred response",
      "definition" : "QRY/QCK - Query sent for deferred response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage mit verzögerter Antwort"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "382",
      "code" : "Q03",
      "display" : "DSR/ACK - Deferred response to a query",
      "definition" : "DSR/ACK - Deferred response to a query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verzögerte Antwort auf Anfrage"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "383",
      "code" : "Q05",
      "display" : "UDM/ACK - Unsolicited display update message",
      "definition" : "UDM/ACK - Unsolicited display update message",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Sofortige Bildschirmanzeige (Eilmeldung)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "384",
      "code" : "Q06",
      "display" : "OSQ/OSR - Query for order status",
      "definition" : "OSQ/OSR - Query for order status",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abfrage des Auftragsstatus"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "385",
      "code" : "Q11",
      "display" : "QBP - Query by parameter requesting an RSP segment pattern response",
      "definition" : "QBP - Query by parameter requesting an RSP segment pattern response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "386",
      "code" : "Q13",
      "display" : "QBP - Query by parameter requesting an  RTB - tabular response",
      "definition" : "QBP - Query by parameter requesting an  RTB - tabular response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "387",
      "code" : "Q15",
      "display" : "QBP - Query by parameter requesting an RDY display response",
      "definition" : "QBP - Query by parameter requesting an RDY display response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "388",
      "code" : "Q16",
      "display" : "QSB - Create subscription",
      "definition" : "QSB - Create subscription",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "389",
      "code" : "Q17",
      "display" : "QVR - Query for previous events",
      "definition" : "QVR - Query for previous events",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "390",
      "code" : "Q21",
      "display" : "QBP - Get person demographics",
      "definition" : "QBP - Get person demographics",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "391",
      "code" : "Q22",
      "display" : "QBP - Find candidates",
      "definition" : "QBP - Find candidates",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "392",
      "code" : "Q23",
      "display" : "QBP - Get corresponding identifiers",
      "definition" : "QBP - Get corresponding identifiers",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "393",
      "code" : "Q24",
      "display" : "QBP - Allocate identifiers",
      "definition" : "QBP - Allocate identifiers",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "394",
      "code" : "Q25",
      "display" : "QBP - Personnel Information by Segment Query",
      "definition" : "QBP - Personnel Information by Segment Query",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "395",
      "code" : "Q26",
      "display" : "ROR - Pharmacy/treatment order response",
      "definition" : "ROR - Pharmacy/treatment order response",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "396",
      "code" : "Q27",
      "display" : "RAR - Pharmacy/treatment administration information",
      "definition" : "RAR - Pharmacy/treatment administration information",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "397",
      "code" : "Q28",
      "display" : "RDR - Pharmacy/treatment dispense information",
      "definition" : "RDR - Pharmacy/treatment dispense information",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "398",
      "code" : "Q29",
      "display" : "RER - Pharmacy/treatment encoded order information",
      "definition" : "RER - Pharmacy/treatment encoded order information",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "399",
      "code" : "Q30",
      "display" : "RGR - Pharmacy/treatment dose information",
      "definition" : "RGR - Pharmacy/treatment dose information",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "400",
      "code" : "Q31",
      "display" : "QBP Query Dispense history",
      "definition" : "QBP Query Dispense history",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "401",
      "code" : "Q32",
      "display" : "Find Candidates including Visit Information",
      "definition" : "Find Candidates including Visit Information",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "402",
      "code" : "Q33",
      "display" : "QBP - Get Donor Record Candidates",
      "definition" : "QBP - Get Donor Record Candidates",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "403",
      "code" : "Q34",
      "display" : "QBP - Get Donor Record",
      "definition" : "QBP - Get Donor Record",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "404",
      "code" : "R01",
      "display" : "ORU/ACK - Unsolicited transmission of an observation message",
      "definition" : "ORU/ACK - Unsolicited transmission of an observation message",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unangeforderte Übermittlung eines Befundes"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "405",
      "code" : "R02",
      "display" : "QRY - Query for results of observation",
      "definition" : "QRY - Query for results of observation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage nach Untersuchungsergebnis"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "406",
      "code" : "R04",
      "display" : "ORF - Response to query; transmission of requested observation",
      "definition" : "ORF - Response to query; transmission of requested observation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort auf Anfrage / Übermittlung eines angeforderten Ergebnisses"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "407",
      "code" : "R21",
      "display" : "OUL - Unsolicited laboratory observation",
      "definition" : "OUL - Unsolicited laboratory observation",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "408",
      "code" : "R22",
      "display" : "OUL - Unsolicited Specimen Oriented Observation Message",
      "definition" : "OUL - Unsolicited Specimen Oriented Observation Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "409",
      "code" : "R23",
      "display" : "OUL - Unsolicited Specimen Container Oriented Observation Message",
      "definition" : "OUL - Unsolicited Specimen Container Oriented Observation Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "410",
      "code" : "R24",
      "display" : "OUL - Unsolicited Order Oriented Observation Message",
      "definition" : "OUL - Unsolicited Order Oriented Observation Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "411",
      "code" : "R25",
      "display" : "OPU - Unsolicited Population/Location-Based Laboratory Observation Message",
      "definition" : "OPU - Unsolicited Population/Location-Based Laboratory Observation Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "412",
      "code" : "R26",
      "display" : "OSM - Unsolicited Specimen Shipment Manifest Message",
      "definition" : "OSM - Unsolicited Specimen Shipment Manifest Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "413",
      "code" : "R30",
      "display" : "ORU - Unsolicited Point-Of-Care Observation Message Without Existing Order - Place An Order",
      "definition" : "ORU - Unsolicited Point-Of-Care Observation Message Without Existing Order - Place An Order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "414",
      "code" : "R31",
      "display" : "ORU - Unsolicited New Point-Of-Care Observation Message - Search For An Order",
      "definition" : "ORU - Unsolicited New Point-Of-Care Observation Message - Search For An Order",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "415",
      "code" : "R32",
      "display" : "ORU - Unsolicited Pre-Ordered Point-Of-Care Observation",
      "definition" : "ORU - Unsolicited Pre-Ordered Point-Of-Care Observation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "416",
      "code" : "R33",
      "display" : "ORA - Observation Report Acknowledgement",
      "definition" : "ORA - Observation Report Acknowledgement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "417",
      "code" : "R40",
      "display" : "ORU - Unsolicited Report Alarm",
      "definition" : "ORU - Unsolicited Report Alarm",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "418",
      "code" : "R41",
      "display" : "Observation Report Alert Acknowledgement",
      "definition" : "Observation Report Alert Acknowledgement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "419",
      "code" : "R42",
      "display" : "ORU – Unsolicited Device Event Observation Message",
      "definition" : "ORU – Unsolicited Device Event Observation Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "420",
      "code" : "R43",
      "display" : "ORU – Unsolicited Patient-Device Association Observation Message",
      "definition" : "ORU – Unsolicited Patient-Device Association Observation Message",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "421",
      "code" : "ROR",
      "display" : "ROR - Pharmacy prescription order query response",
      "definition" : "ROR - Pharmacy prescription order query response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort bzgl. der Verschreibungsanforderung des Arzneiverordnung bzw. d.Behandlg"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "422",
      "code" : "S01",
      "display" : "SRM/SRR - Request new appointment booking",
      "definition" : "SRM/SRR - Request new appointment booking",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Terminanforderung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "423",
      "code" : "S02",
      "display" : "SRM/SRR - Request appointment rescheduling",
      "definition" : "SRM/SRR - Request appointment rescheduling",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung für Terminverschiebung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "424",
      "code" : "S03",
      "display" : "SRM/SRR - Request appointment modification",
      "definition" : "SRM/SRR - Request appointment modification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung für inhaltliche Terminänderung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "425",
      "code" : "S04",
      "display" : "SRM/SRR - Request appointment cancellation",
      "definition" : "SRM/SRR - Request appointment cancellation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Absage eines Termins"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "426",
      "code" : "S05",
      "display" : "SRM/SRR - Request appointment discontinuation",
      "definition" : "SRM/SRR - Request appointment discontinuation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aussetzung des aktuellen oder weiterer Termine"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "427",
      "code" : "S06",
      "display" : "SRM/SRR - Request appointment deletion",
      "definition" : "SRM/SRR - Request appointment deletion",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung eines Termins"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "428",
      "code" : "S07",
      "display" : "SRM/SRR - Request addition of service/resource on appointment",
      "definition" : "SRM/SRR - Request addition of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung zusätzlicher Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "429",
      "code" : "S08",
      "display" : "SRM/SRR - Request modification of service/resource on appointment",
      "definition" : "SRM/SRR - Request modification of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderungsanforderung für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "430",
      "code" : "S09",
      "display" : "SRM/SRR - Request cancellation of service/resource on appointment",
      "definition" : "SRM/SRR - Request cancellation of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Absage für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "431",
      "code" : "S10",
      "display" : "SRM/SRR - Request discontinuation of service/resource on appointment",
      "definition" : "SRM/SRR - Request discontinuation of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aussetzung für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "432",
      "code" : "S11",
      "display" : "SRM/SRR - Request deletion of service/resource on appointment",
      "definition" : "SRM/SRR - Request deletion of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornierung für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "433",
      "code" : "S12",
      "display" : "SIU/ACK - Notification of new appointment booking",
      "definition" : "SIU/ACK - Notification of new appointment booking",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über Terminvergabe"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "434",
      "code" : "S13",
      "display" : "SIU/ACK - Notification of appointment rescheduling",
      "definition" : "SIU/ACK - Notification of appointment rescheduling",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung für Terminverschiebung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "435",
      "code" : "S14",
      "display" : "SIU/ACK - Notification of appointment modification",
      "definition" : "SIU/ACK - Notification of appointment modification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung für inhaltliche Terminänderung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "436",
      "code" : "S15",
      "display" : "SIU/ACK - Notification of appointment cancellation",
      "definition" : "SIU/ACK - Notification of appointment cancellation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über Terminabsage"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "437",
      "code" : "S16",
      "display" : "SIU/ACK - Notification of appointment discontinuation",
      "definition" : "SIU/ACK - Notification of appointment discontinuation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über Aussetzung des aktuellen oder weiterer Termine"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "438",
      "code" : "S17",
      "display" : "SIU/ACK - Notification of appointment deletion",
      "definition" : "SIU/ACK - Notification of appointment deletion",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über Stornierung eines Termins"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "439",
      "code" : "S18",
      "display" : "SIU/ACK - Notification of addition of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of addition of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über  zusätzlicher Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "440",
      "code" : "S19",
      "display" : "SIU/ACK - Notification of modification of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of modification of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderungsbenachrichtigung f.zusätzl. Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "441",
      "code" : "S20",
      "display" : "SIU/ACK - Notification of cancellation of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of cancellation of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung f. zusätzliche Leistungen/Voraussetzungen zu einem Terminabsage"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "442",
      "code" : "S21",
      "display" : "SIU/ACK - Notification of discontinuation of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of discontinuation of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über Aussetzung für zusätzliche Leistungen/Voraussetzungen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "443",
      "code" : "S22",
      "display" : "SIU/ACK - Notification of deletion of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of deletion of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung Stornierg.f.zusätzl.Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "444",
      "code" : "S23",
      "display" : "SIU/ACK - Notification of blocked schedule time slot(s)",
      "definition" : "SIU/ACK - Notification of blocked schedule time slot(s)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über nicht verfügbare Zeitbereiche"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "445",
      "code" : "S24",
      "display" : "SIU/ACK - Notification of opened (\"unblocked\") schedule time slot(s)",
      "definition" : "SIU/ACK - Notification of opened (\"unblocked\") schedule time slot(s)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über (wieder) verfügbare Zeitbereiche"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "446",
      "code" : "S25",
      "display" : "SQM/SQR - Schedule query message and response",
      "definition" : "SQM/SQR - Schedule query message and response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage nach Zeitplaninformation"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "447",
      "code" : "S26",
      "display" : "SIU/ACK Notification that patient did not show up for schedule appointment",
      "definition" : "SIU/ACK Notification that patient did not show up for schedule appointment",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über Nichterscheinen eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "448",
      "code" : "S27",
      "display" : "SIU/ACK - Broadcast Notification of Scheduled Appointments",
      "definition" : "SIU/ACK - Broadcast Notification of Scheduled Appointments",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "449",
      "code" : "S28",
      "display" : "SLR/SLS - Request new sterilization lot",
      "definition" : "SLR/SLS - Request new sterilization lot",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "450",
      "code" : "S29",
      "display" : "SLR/SLS - Request Sterilization lot deletion",
      "definition" : "SLR/SLS - Request Sterilization lot deletion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "451",
      "code" : "S30",
      "display" : "STI/STS - Request item",
      "definition" : "STI/STS - Request item",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "452",
      "code" : "S31",
      "display" : "SDR/SDS - Request anti-microbial device data",
      "definition" : "SDR/SDS - Request anti-microbial device data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "453",
      "code" : "S32",
      "display" : "SMD/SMS - Request anti-microbial device cycle data",
      "definition" : "SMD/SMS - Request anti-microbial device cycle data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "454",
      "code" : "S33",
      "display" : "STC/ACK - Notification of sterilization configuration",
      "definition" : "STC/ACK - Notification of sterilization configuration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "455",
      "code" : "S34",
      "display" : "SLN/ACK - Notification of sterilization lot",
      "definition" : "SLN/ACK - Notification of sterilization lot",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "456",
      "code" : "S35",
      "display" : "SLN/ACK - Notification of sterilization lot deletion",
      "definition" : "SLN/ACK - Notification of sterilization lot deletion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "457",
      "code" : "S36",
      "display" : "SDN/ACK - Notification of anti-microbial device data",
      "definition" : "SDN/ACK - Notification of anti-microbial device data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "458",
      "code" : "S37",
      "display" : "SCN/ACK - Notification of anti-microbial device cycle data",
      "definition" : "SCN/ACK - Notification of anti-microbial device cycle data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "459",
      "code" : "S38",
      "display" : "Containers Prepared for Specimen Collection",
      "definition" : "Describes the event before specimen collection, when containers have been prepared",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "460",
      "code" : "S39",
      "display" : "Specimen Collection Successful",
      "definition" : "Describes the event when specimen collection was successful",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "461",
      "code" : "S40",
      "display" : "Specimen Collection Unsuccessful",
      "definition" : "Describes the event when specimen collection was not successful and provides a means to document the reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "462",
      "code" : "S41",
      "display" : "Specimen Departed",
      "definition" : "Describes the event when a specimen has been moved from a location",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "463",
      "code" : "S42",
      "display" : "Specimen Arrived",
      "definition" : "Describes the event when a specimen has been moved to a location",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "464",
      "code" : "S43",
      "display" : "Specimen Accepted",
      "definition" : "Describes the event when a specimen has been accepted on the receiver side of a specimen movement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "465",
      "code" : "S44",
      "display" : "Specimen Rejected",
      "definition" : "Describes the event when a specimen has been rejected by the receiver side of a specimen movement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "466",
      "code" : "S45",
      "display" : "Specimen Re-identified",
      "definition" : "Describes the event when a specimen has been assigned an identifier",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "467",
      "code" : "S46",
      "display" : "Specimen De-identified",
      "definition" : "Describes the event when a specimen identifier has been removed to anonymize it",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "468",
      "code" : "S47",
      "display" : "Specimen Sent to Archive",
      "definition" : "Describes the event when a specimen has been moved into storage",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : ">"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "469",
      "code" : "S48",
      "display" : "Specimen Retrieved from Archive",
      "definition" : "Describes the event when a specimen has been moved out of storage",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "470",
      "code" : "S49",
      "display" : "Specimen Disposed of",
      "definition" : "Describes the event when a specimen has been permanently disposed of",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "471",
      "code" : "S50",
      "display" : "Specimen Procedure Step Successful , with Derived Specimen(s)",
      "definition" : "Describes the event when one or more specimen(s) has(ve) been created from one or more specimen(s)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "472",
      "code" : "S51",
      "display" : "Specimen Procedure Step Successful, no Derived Specimen(s)",
      "definition" : "Describes the event when a specimen has been successfully processed without producing any child specimen(s)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "473",
      "code" : "S52",
      "display" : "Specimen Procedure Step Unsuccessful",
      "definition" : "Describes the event when a specimen could not be successfully processed and provides a means to document the reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "474",
      "code" : "T01",
      "display" : "MDM/ACK - Original document notification",
      "definition" : "MDM/ACK - Original document notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Neuanlage eines Dokuments ohne Inhalt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "475",
      "code" : "T02",
      "display" : "MDM/ACK - Original document notification and content",
      "definition" : "MDM/ACK - Original document notification and content",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Neuanlage eines Dokuments mit Inhaltsübermittlung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "476",
      "code" : "T03",
      "display" : "MDM/ACK - Document status change notification",
      "definition" : "MDM/ACK - Document status change notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Statusänderung eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "477",
      "code" : "T04",
      "display" : "MDM/ACK - Document status change notification and content",
      "definition" : "MDM/ACK - Document status change notification and content",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Statusänderung eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "478",
      "code" : "T05",
      "display" : "MDM/ACK - Document addendum notification",
      "definition" : "MDM/ACK - Document addendum notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Ergänzung eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "479",
      "code" : "T06",
      "display" : "MDM/ACK - Document addendum notification and content",
      "definition" : "MDM/ACK - Document addendum notification and content",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Ergänzung eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "480",
      "code" : "T07",
      "display" : "MDM/ACK - Document edit notification",
      "definition" : "MDM/ACK - Document edit notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Änderung eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "481",
      "code" : "T08",
      "display" : "MDM/ACK - Document edit notification and content",
      "definition" : "MDM/ACK - Document edit notification and content",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Änderung eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "482",
      "code" : "T09",
      "display" : "MDM/ACK - Document replacement notification",
      "definition" : "MDM/ACK - Document replacement notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über den Austausch eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "483",
      "code" : "T10",
      "display" : "MDM/ACK - Document replacement notification and content",
      "definition" : "MDM/ACK - Document replacement notification and content",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über den Austausch eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "484",
      "code" : "T11",
      "display" : "MDM/ACK - Document cancel notification",
      "definition" : "MDM/ACK - Document cancel notification",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Benachrichtigung über die Löschung eines Dokuments"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "485",
      "code" : "T12",
      "display" : "QRY/DOC - Document query",
      "definition" : "QRY/DOC - Document query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Dokumentanfrage"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "486",
      "code" : "U01",
      "display" : "ESU/ACK - Automated equipment status update",
      "definition" : "ESU/ACK - Automated equipment status update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "487",
      "code" : "U02",
      "display" : "ESR/ACK - Automated equipment status request",
      "definition" : "ESR/ACK - Automated equipment status request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "488",
      "code" : "U03",
      "display" : "SSU/ACK - Specimen status update",
      "definition" : "SSU/ACK - Specimen status update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "489",
      "code" : "U04",
      "display" : "SSR/ACK - specimen status request",
      "definition" : "SSR/ACK - specimen status request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "490",
      "code" : "U05",
      "display" : "INU/ACK  - Automated equipment inventory update",
      "definition" : "INU/ACK  - Automated equipment inventory update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "491",
      "code" : "U06",
      "display" : "INR/ACK - Automated equipment inventory request",
      "definition" : "INR/ACK - Automated equipment inventory request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "492",
      "code" : "U07",
      "display" : "EAC/ACK - Automated equipment command",
      "definition" : "EAC/ACK - Automated equipment command",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "493",
      "code" : "U08",
      "display" : "EAR/ACK - Automated equipment response",
      "definition" : "EAR/ACK - Automated equipment response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "494",
      "code" : "U09",
      "display" : "EAN/ACK - Automated equipment notification",
      "definition" : "EAN/ACK - Automated equipment notification",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "495",
      "code" : "U10",
      "display" : "TCU/ACK - Automated equipment test code settings update",
      "definition" : "TCU/ACK - Automated equipment test code settings update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "496",
      "code" : "U11",
      "display" : "TCR/ACK - Automated equipment test code settings request",
      "definition" : "TCR/ACK - Automated equipment test code settings request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "497",
      "code" : "U12",
      "display" : "LSU/ACK - Automated equipment log/service update",
      "definition" : "LSU/ACK - Automated equipment log/service update",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "498",
      "code" : "U13",
      "display" : "LSR/ACK - Automated equipment log/service request",
      "definition" : "LSR/ACK - Automated equipment log/service request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "499",
      "code" : "U14",
      "display" : "INR/ACK – Automated Equipment Inventory Request",
      "definition" : "INR/ACK – Automated Equipment Inventory Request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "500",
      "code" : "V01",
      "display" : "VXQ - Query for vaccination record",
      "definition" : "VXQ - Query for vaccination record",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anfrage nach Impfstatus eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "501",
      "code" : "V02",
      "display" : "VXX - Response to vaccination query returning multiple PID matches",
      "definition" : "VXX - Response to vaccination query returning multiple PID matches",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort auf Impfstatusanfrage bei nicht-eindeutiger Patienten-ID"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "502",
      "code" : "V03",
      "display" : "VXR - Vaccination record response",
      "definition" : "VXR - Vaccination record response",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Antwort auf Impfstatusanfrage zu einem Patienten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "503",
      "code" : "V04",
      "display" : "VXU - Unsolicited vaccination record update",
      "definition" : "VXU - Unsolicited vaccination record update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unaufgeforderte Änderung zu dem Impfstatus eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "504",
      "code" : "Varies",
      "display" : "MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)",
      "definition" : "MFQ/MFR - Master files query (use event same as asking for e.g., M05 - location)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "allgemeine Stammdatenanfrage"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "505",
      "code" : "W01",
      "display" : "ORU - Waveform result, unsolicited transmission of requested information",
      "definition" : "ORU - Waveform result, unsolicited transmission of requested information",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unaufgeforderte Übermittlung von Signaldaten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "506",
      "code" : "W02",
      "display" : "QRF - Waveform result, response to query",
      "definition" : "QRF - Waveform result, response to query",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "angeforderte Übermittlung von Signaldaten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    }
  ]
}

```
