# UsageContextType - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **UsageContextType**

## CodeSystem: UsageContextType 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/usage-context-type | *Version*:2.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 5 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:UsageContextType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1068 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
A code that specifies a type of context being specified by a usage context. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [UsageContextType](ValueSet-usage-context-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "usage-context-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 5
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1068"
    }
  ],
  "version" : "2.0.1",
  "name" : "UsageContextType",
  "title" : "UsageContextType",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code that specifies a type of context being specified by a usage context.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/usage-context-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "gender",
      "display" : "Gender",
      "definition" : "The gender of the patient for which this artifact/element applies. For this context type, appropriate values can be found in the http://hl7.org/fhir/ValueSet/administrative-gender value set."
    },
    {
      "code" : "age",
      "display" : "Age Range",
      "definition" : "The age of the patients for which this artifact/element applies. For this context type, the value could be a range that specifies the applicable ages or a code from an appropriate value set such as the MeSH value set http://terminology.hl7.org/ValueSet/v3-AgeGroupObservationValue."
    },
    {
      "code" : "focus",
      "display" : "Clinical Focus",
      "definition" : "The clinical concept(s) addressed by the artifact/element. For example, disease, diagnostic test interpretation, medication ordering as in http://hl7.org/fhir/ValueSet/condition-code."
    },
    {
      "code" : "user",
      "display" : "User Type",
      "definition" : "The clinical specialty of the context in which the patient is being treated - For example, PCP, Patient, Cardiologist, Behavioral Professional, Oral Health Professional, Prescriber, etc... taken from a specialty value set such as the NUCC Health Care provider taxonomy value set http://hl7.org/fhir/ValueSet/provider-taxonomy that is relevant to this artifact/element."
    },
    {
      "code" : "workflow",
      "display" : "Workflow Setting",
      "definition" : "The settings in which the artifact/element is intended for use. For example, admission, pre-op, etc. For example, the ActEncounterCode value set http://terminology.hl7.org/ValueSet/v3-ActEncounterCode."
    },
    {
      "code" : "task",
      "display" : "Workflow Task",
      "definition" : "The context for the clinical task(s) represented by this artifact/element. For example, this could be any task context represented by the HL7 ActTaskCode value set http://terminology.hl7.org/ValueSet/v3-ActTaskCode. General categories include: order entry, patient documentation and patient information review."
    },
    {
      "code" : "venue",
      "display" : "Clinical Venue",
      "definition" : "The venue in which an artifact/element could be used. For example, Outpatient, Inpatient, Home, Nursing home. The code value may originate from the HL7 ServiceDeliveryLocationRoleType value set (http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType)."
    },
    {
      "code" : "species",
      "display" : "Species",
      "definition" : "The species to which an artifact/element applies. For example, SNOMED - 387961004 | Kingdom Animalia (organism)."
    },
    {
      "code" : "program",
      "display" : "Program",
      "definition" : "A program/project of work for which this artifact/element is applicable."
    },
    {
      "code" : "jurisdiction",
      "display" : "Jurisdiction",
      "definition" : "A country, state, territory or other geographic or geopolicital area for which this artifact/element is applicable."
    },
    {
      "code" : "topic",
      "display" : "Topic",
      "definition" : "Descriptive topics related to the content of the artifact. Topics provide a high-level categorization as well as keywords for the artifact that can be useful for filtering and searching."
    }
  ]
}

```
