# Sex Parameter For Clinical Use - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sex Parameter For Clinical Use**

## CodeSystem: Sex Parameter For Clinical Use 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use | *Version*:2.0.0 | |
| Active as of 2025-11-12 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SexParameterForClinicalUseCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.4.2038 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A summary parameter that provides guidance on how a receiver should apply settings or reference ranges that are derived from observable information such as an organ inventory, recent hormone lab tests, genetic testing, menstrual status, obstetric history, etc.. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SexParameterForClinicalUse](ValueSet-sex-parameter-for-clinical-use.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "sex-parameter-for-clinical-use",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.4.2038"
    }
  ],
  "version" : "2.0.0",
  "name" : "SexParameterForClinicalUseCS",
  "title" : "Sex Parameter For Clinical Use",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A summary parameter that provides guidance on how a receiver should apply settings or reference ranges that are derived from observable information such as an organ inventory, recent hormone lab tests, genetic testing, menstrual status, obstetric history, etc..",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "content" : "complete",
  "property" : [
    {
      "code" : "usage-note",
      "uri" : "http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use/property/usage-note",
      "description" : "Usage notes for the concept.",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "female-typical",
      "display" : "Apply female-typical setting or reference range",
      "definition" : "Available data indicates that diagnostics, analytics, and treatments should consider best practices associated with female reference populations."
    },
    {
      "code" : "male-typical",
      "display" : "Apply male-typical setting or reference range",
      "definition" : "Available data indicates that diagnostics, analytics, and treatments should consider best practices associated with male reference populations."
    },
    {
      "code" : "specified",
      "display" : "Apply specified setting or reference range",
      "definition" : "Available data indicates that diagnostics, analytics, and treatment best practices may be undefined or not aligned with sex-derived reference populations. Additional information may be available in the form of comments and/or observations. The terms \"Other\" or \"Complex\" may be considered synonyms of \"Specified\".",
      "property" : [
        {
          "code" : "usage-note",
          "valueString" : "Individuals or systems providing care should either use default behavior that is safe for both male and female populations, individually review treatment options with the patient, or carefully inspect comments and relevant observations before proceeding with treatment. Systems that are unable to review additional information may manage a SPECIFIED and an UNKNOWN value in the same way."
        }
      ]
    }
  ]
}

```
