# Risk Probability - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Probability**

## CodeSystem: Risk Probability 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/risk-probability | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RiskProbability |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1133 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes representing the likelihood of a particular outcome in a risk assessment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RiskProbability](ValueSet-risk-probability.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "risk-probability",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/risk-probability",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1133"
    }
  ],
  "version" : "1.0.1",
  "name" : "RiskProbability",
  "title" : "Risk Probability",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes representing the likelihood of a particular outcome in a risk assessment.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/risk-probability",
  "content" : "complete",
  "concept" : [
    {
      "code" : "negligible",
      "display" : "Negligible likelihood",
      "definition" : "The specified outcome is exceptionally unlikely."
    },
    {
      "code" : "low",
      "display" : "Low likelihood",
      "definition" : "The specified outcome is possible but unlikely."
    },
    {
      "code" : "moderate",
      "display" : "Moderate likelihood",
      "definition" : "The specified outcome has a reasonable likelihood of occurrence."
    },
    {
      "code" : "high",
      "display" : "High likelihood",
      "definition" : "The specified outcome is more likely to occur than not."
    },
    {
      "code" : "certain",
      "display" : "Certain",
      "definition" : "The specified outcome is effectively guaranteed."
    }
  ]
}

```
