# Program - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Program**

## CodeSystem: Program 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/program | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Program |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1384 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set defines an example set of codes that could be can be used to classify groupings of service-types/specialties. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Program](ValueSet-program.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "program",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/program",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1384"
    }
  ],
  "version" : "1.0.1",
  "name" : "Program",
  "title" : "Program",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines an example set of codes that could be can be used to classify groupings of service-types/specialties.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/program",
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "Acquired Brain Injury (ABI) Program"
    },
    {
      "code" : "2",
      "display" : "ABI Slow To Recover (ABI STR) Program"
    },
    {
      "code" : "3",
      "display" : "Access Programs"
    },
    {
      "code" : "4",
      "display" : "Adult and Further Education (ACFE) Program"
    },
    {
      "code" : "5",
      "display" : "Adult Day Activity and Support Services (ADASS) Program"
    },
    {
      "code" : "6",
      "display" : "Adult Day Care Program"
    },
    {
      "code" : "7",
      "display" : "ATSS (Adult Training Support Service)"
    },
    {
      "code" : "8",
      "display" : "Community Aged Care Packages (CACP)"
    },
    {
      "code" : "9",
      "display" : "Care Coordination & Supplementary Services (CCSS)"
    },
    {
      "code" : "10",
      "display" : "Cognitive Dementia Memory Service (CDAMS)"
    },
    {
      "code" : "11",
      "display" : "ChildFIRST"
    },
    {
      "code" : "12",
      "display" : "Children's Contact Services"
    },
    {
      "code" : "13",
      "display" : "Community Visitors Scheme"
    },
    {
      "code" : "14",
      "display" : "CPP (Community Partners Program)"
    },
    {
      "code" : "15",
      "display" : "Closing the Gap (CTG)"
    },
    {
      "code" : "16",
      "display" : "Coordinated Veterans' Care (CVC) Program"
    },
    {
      "code" : "17",
      "display" : "Day Program"
    },
    {
      "code" : "18",
      "display" : "Drop In Program"
    },
    {
      "code" : "19",
      "display" : "Early Years Program"
    },
    {
      "code" : "20",
      "display" : "Employee Assistance Program"
    },
    {
      "code" : "21",
      "display" : "Home And Community Care (HACC)"
    },
    {
      "code" : "22",
      "display" : "Hospital Admission Risk Program (HARP)"
    },
    {
      "code" : "23",
      "display" : "Hospital in the Home (HITH) Program"
    },
    {
      "code" : "24",
      "display" : "ICTP (Intensive Community Treatment Program)"
    },
    {
      "code" : "25",
      "display" : "IFSS (Intensive Family Support Program)"
    },
    {
      "code" : "26",
      "display" : "JPET (Job Placement, Education and Training)"
    },
    {
      "code" : "27",
      "display" : "Koori Juvenile Justice Program"
    },
    {
      "code" : "28",
      "display" : "Language Literacy and Numeracy Program"
    },
    {
      "code" : "29",
      "display" : "Life Skills Program"
    },
    {
      "code" : "30",
      "display" : "LMP (Lifestyle Modification Program)"
    },
    {
      "code" : "31",
      "display" : "MedsCheck Program"
    },
    {
      "code" : "32",
      "display" : "Methadone/Buprenorphine Program"
    },
    {
      "code" : "33",
      "display" : "National Disabilities Insurance Scheme (NDIS)"
    },
    {
      "code" : "34",
      "display" : "National Diabetes Services Scheme (NDSS)"
    },
    {
      "code" : "35",
      "display" : "Needle/Syringe Program"
    },
    {
      "code" : "36",
      "display" : "nPEP Program"
    },
    {
      "code" : "37",
      "display" : "Personal Support Program"
    },
    {
      "code" : "38",
      "display" : "Partners in Recovery (PIR) Program"
    },
    {
      "code" : "39",
      "display" : "Pre-employment Program"
    },
    {
      "code" : "40",
      "display" : "Reconnect Program"
    },
    {
      "code" : "41",
      "display" : "Sexual Abuse Counselling and Prevention Program (SACPP)"
    },
    {
      "code" : "42",
      "display" : "Social Support Programs"
    },
    {
      "code" : "43",
      "display" : "Supported Residential Service (SRS)"
    },
    {
      "code" : "44",
      "display" : "Tasmanian Aboriginal Centre (TAC)"
    },
    {
      "code" : "45",
      "display" : "Victim's Assistance Program"
    }
  ]
}

```
