# Operation Outcome Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Operation Outcome Codes**

## CodeSystem: Operation Outcome Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/operation-outcome | *Version*:3.0.0 | | |
| Draft as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OperationOutcomeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1127 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Operation Outcome codes used by FHIR test servers (see Implementation file translations.xml) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "operation-outcome",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/operation-outcome",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1127"
    }
  ],
  "version" : "3.0.0",
  "name" : "OperationOutcomeCodes",
  "title" : "Operation Outcome Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Operation Outcome codes used by FHIR test servers (see Implementation file translations.xml)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "DELETE_MULTIPLE_MATCHES",
      "display" : "Error: Multiple matches exist for the conditional delete",
      "designation" : [
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fout: er is meer dan één resultaat voor de conditionele delete"
        }
      ]
    },
    {
      "code" : "MSG_AUTH_REQUIRED",
      "display" : "You must authenticate before you can use this service",
      "designation" : [
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Autenticazione richiesta prima di usare questo servizio"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Wymagana autentykacja przed użyciem tego serwisu"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Vous devez être authentifié avant de pouvoir utiliser ce service"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "U moet zich authenticeren voor gebruik van deze service"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "使用此服务前需认证"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Debe autenticarse antes de poder usar este servicio"
        }
      ]
    },
    {
      "code" : "MSG_BAD_FORMAT",
      "display" : "Bad Syntax: \"%s\" must be a %s'",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Неверный синтакс: \"%s\" должен быть %s"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Sintassi Errata: \"%s\" deve essere un %s'"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd składni: \"%s\" powinno być %s'"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Erreur de Syntaxe : \"%s\" doit être un %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verkeerde syntax: \"%s\" moet een %s zijn"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "句法错误: \"%s\" 必须是一个 %s'"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Sintaxis Incorrecta: \"%s\" debe de ser un %s'"
        }
      ]
    },
    {
      "code" : "MSG_BAD_SYNTAX",
      "display" : "Bad Syntax in %s",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Неверный синтакс: %s"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Sintassi errata in %s"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd składni w %s"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Erreur de Syntaxe dans %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verkeerde syntax in %s"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "%s 中句法错误"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Sintaxis Incorrecta en %s"
        }
      ]
    },
    {
      "code" : "MSG_CANT_PARSE_CONTENT",
      "display" : "Unable to parse feed (entry content type = \"%s\")",
      "designation" : [
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossibile effettuare il parsing del feed (tipo del contenuto della entry = \"%s\")"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd parsowania (typ zawartości wejściowej = \"%s\")"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossible d'analyser le flux (type de contenu de l'entrée = \"%s\")"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Kan feed niet verwerken (contenttype inhoud = \"%s\")"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "无法解析feed (条目的内容类型 = \"%s\")"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "No se pudo parsear el feed (el tipo de contenido de la entry = \"%s\")"
        }
      ]
    },
    {
      "code" : "MSG_CANT_PARSE_ROOT",
      "display" : "Unable to parse feed (root element name = \"%s\")",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Не удалось разобрать данные (корневой элемент = \"%s\")"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossibile effettuare il parsing del feed (nome elemento root = \"%s\")"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd parsowania (nazwa elementu root = \"%s\")"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossible d'analyser le flux (nom de l'élément racine = \"%s\")"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Kan feed niet verwerken (rootelementnaam = \"%s\")"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "无法解析feed (根元素名 = \"%s\")"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "No se pudo parsear el feed (nombre del elemento raiz = \"%s\")"
        }
      ]
    },
    {
      "code" : "MSG_CREATED",
      "display" : "New resource created",
      "designation" : [
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nieuwe resource gemaakt"
        }
      ]
    },
    {
      "code" : "MSG_DATE_FORMAT",
      "display" : "The Date value %s is not in the correct format (Xml Date Format required)",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Значение Date %s в неверном формате (требуется Xml Date формат)"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Il valore %s per la data non è nel formato corretto (richiesto il Formato Data Xml)"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Niepoprawny format wartości daty %s (wymagany format XML)"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Le format de la date %s est incorrect (format Date Xml attendu)"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "De Datum-waarde %s heeft niet de juiste structuur (Xml Date vereist)"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "日期的值 %s 格式不正确 (要求是Xml Date格式)"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "El valor de la fecha %s no está en el formato correcto (se requiere un formato de fecha Xml)"
        }
      ]
    },
    {
      "code" : "MSG_DELETED",
      "display" : "This resource has been deleted",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Данный ресурс был удалён"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Questa risorsa è stata cancellata"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ten zasób został usunięty"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La ressource a été supprimée"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Deze resource is verwijderd"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "该资源已删除"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Este recurso ha sido borrado"
        }
      ]
    },
    {
      "code" : "MSG_DELETED_DONE",
      "display" : "Resource deleted",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ресурс удалён"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Risorsa cancellata"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zasób usunięto"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ressource supprimée"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Resource verwijderd"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "资源已删除"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Recurso borrado"
        }
      ]
    },
    {
      "code" : "MSG_DELETED_ID",
      "display" : "The resource \"%s\" has been deleted",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ресурс \"%s\" был удалён"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La risorsa \"%s\" è stata eliminata"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zasób \"%s\" został usunięty"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La ressource \"%s\" a été supprimée"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "De resource \"%s\" is verwijderd"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "资源 \"%s\" 已被删除"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "El recurso \"%s\" ha sido borrado"
        }
      ]
    },
    {
      "code" : "MSG_DUPLICATE_ID",
      "display" : "Duplicate Id %s for resource type %s",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Дублирующий Id %s для типа ресурса %s"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id %s duplicato per il tipo di risorsa %s"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zdublowany identyfikator %s dla zasobu typu %s"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id %s en double pour le type de ressource %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Duplicaat-id %s voor resourcetype %s"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "ID %s 重复（资源类型 %s）"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id %s duplicada para el recurso de tipo %s"
        }
      ]
    },
    {
      "code" : "MSG_ERROR_PARSING",
      "display" : "Error parsing resource Xml (%s)",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ошибка синтаксического разбора ресурса Xml (%s)"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Errore nel parsing della risorsa Xml (%s)"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd w trakcie parsowania zasobu XML (%s)"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Erreur d'analyse de la ressource Xml (%s)"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fout in verwerking resource Xml (%s)"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "解析资源Xml时出错 (%s)"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Error parseando el recurso Xml (%s)"
        }
      ]
    },
    {
      "code" : "MSG_EXTERNAL_FAIL",
      "display" : "Unable to resolve external reference to resource %s"
    },
    {
      "code" : "MSG_ID_INVALID",
      "display" : "Id \"%s\" has an invalid character \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" содержит недопустимые символы \"%s\""
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "L''Id \"%s\" ha un carattere non valido: \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identyfikator \"%s\" zawiera niepoprawny znak \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" possède un caractère invalide \"%s\""
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" heeft een ongeldig teken \"%s\""
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "ID \"%s\" 带有非法字符: \"%s\""
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "El Id \"%s\" contiene el caracter inválido \"%s\""
        }
      ]
    },
    {
      "code" : "MSG_ID_TOO_LONG",
      "display" : "Id \"%s\" too long (length limit 36)",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Недопустимая длина Id \"%s\" (ограничение 36)"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" troppo lunga (limite di lunghezza: 36)"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identyfikator \"%s\" jest zbyt długi (limit długości 36)"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" trop long (la longueur limite est 36)"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" te lang (max lengte 36)"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id \"%s\" 过长 (长度限制: 36)"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "El Id \"%s\" es demasiado largo (limite de longitud: 36)"
        }
      ]
    },
    {
      "code" : "MSG_INVALID_ID",
      "display" : "Id not accepted",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id не принято"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id non accettato"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identyfikator nie zaakceptowany"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id non accepté"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id niet geaccepteerd"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id不被接受"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id no aceptada"
        }
      ]
    },
    {
      "code" : "MSG_JSON_OBJECT",
      "display" : "Json Source for a resource should start with an object",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Json Source для ресурса должен начинаться с объекта"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Il sorgente Json di una risorsa dovrebbe iniziare con un oggetto"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Źródło json dla zasobu powinno rozpoczynać się od obiektu"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La source Json pour une ressource doit commencer par un objet"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Json Source van een resource moeten beginnen met een object"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "资源的Json源应以一个object开始"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La fuente Json para un recurso debería empezar con un objeto"
        }
      ]
    },
    {
      "code" : "MSG_LOCAL_FAIL",
      "display" : "Unable to resolve local reference to resource %s",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Невозможно определить локальную ссылку на ресурс %s"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossibile risolvere il riferimento locale alla risorsa %s"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zasób wskazywany przez loklaną referencję %s nie został odnaleziony"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossible de résourdre la référence locale à la ressource %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "De resource met lokale referentie %s is niet gevonden"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "无法解析对资源 %s 的本地引用"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Imposible resolver la referencia al recurso %s"
        }
      ]
    },
    {
      "code" : "MSG_NO_EXIST",
      "display" : "Resource Id \"%s\" does not exist",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ресурс Id \"%s\" не существует"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La risorsa con Id \"%s\" non esiste"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zasób o identyfikatorze \"%s\" nie istnieje"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "La ressource avec l'Id \"%s\" n'existe pas"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Resource-id \"%s\" bestaat niet"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "资源Id \"%s\"不存在"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "El recurso con Id \"%s\" no existe"
        }
      ]
    },
    {
      "code" : "MSG_NO_MATCH",
      "display" : "No Resource found matching the query \"%s\"",
      "designation" : [
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nessuna Risorsa soddisfa la query \"%s\""
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Geen resource gevonden met query \"%s\""
        }
      ]
    },
    {
      "code" : "MSG_NO_MODULE",
      "display" : "No module could be found to handle the request \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Модуль для обработки запроса \"%s\" не найден"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Impossibile trovare un modulo per gestire la richiesta \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nie można odnaleźć modułu, aby obsłużyć żądanie \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aucun module disponible pour traiter la requête \"%s\""
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Er kon geen module worden gevonden om verzoek \"%s\" te verwerken"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "无法找到处理请求\"%s\"的模块"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "No se encontró un modulo que gestione la petición \"%s\""
        }
      ]
    },
    {
      "code" : "MSG_NO_SUMMARY",
      "display" : "No Summary for this resource",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Отсутствует Summary для данного ресурса"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nessun riepilogo per questa risorsa"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Brak podsumowania (Summary) dla tego zasobu"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aucun résumé disponible pour cette ressource"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Geen samenvatting voor deze resource"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "该资源无summary"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "No existe un resumen para este recurso"
        }
      ]
    },
    {
      "code" : "MSG_OP_NOT_ALLOWED",
      "display" : "Operation %s not allowed for resource %s (due to local configuration)",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Операция %s недопустима для ресурса %s (по причине локальной конфигурации)"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Operazione %s non consentita per la risorsa %s (a causa di configurazioni locali)"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Niedozwolona operacja %s dla zasobu %s (ze względu na lokalną konfigurację)"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "L'opération %s n'est pas permise pour la ressource %s (à cause de la configuration locale)"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Bewerking %s niet toegestaan voor resource %s (vanwege lokale configuratie)"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "操作 %s 不允许，对于资源 %s (由于本地配置)"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Operación %s no permitida para el recurso %s (debido a la configuración local)"
        }
      ]
    },
    {
      "code" : "MSG_PARAM_CHAINED",
      "display" : "Unknown chained parameter name \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Неизвестое вложенное наименование параметра \"%s\""
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nome di parametro concatenato sconosciuto: \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nieznana nazwa parametru powiązanego \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nom du paramètre chainé inconnu : \"%s\""
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Onbekende geschakelde parameternaam \"%s\""
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "未知的链式参数名: \"%s\""
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nombre de parametro encadenado desconocido: \"%s\""
        }
      ]
    },
    {
      "code" : "MSG_PARAM_INVALID",
      "display" : "Parameter \"%s\" content is invalid",
      "designation" : [
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Il contenuto del Parametro \"%s\" non è valido"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Waarde van parameter \"%s\" is ongeldig"
        }
      ]
    },
    {
      "code" : "MSG_PARAM_MODIFIER_INVALID",
      "display" : "Parameter \"%s\" modifier is invalid",
      "designation" : [
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Modifier van parameter \"%s\" is ongeldig"
        }
      ]
    },
    {
      "code" : "MSG_PARAM_NO_REPEAT",
      "display" : "Parameter \"%s\" is not allowed to repeat",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Параметр \"%s\" не может быть повторён"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Non � consentito ripetere il parametro \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Parametr \"%s\" nie może zostać powtórzony"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Le paramètre \"%s\" ne peut pas être répété"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Parameter \"%s\" mag niet herhalen"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "参数\"%s\"不可重复"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "No se permite la repetición del parámetro \"%s\""
        }
      ]
    },
    {
      "code" : "MSG_PARAM_UNKNOWN",
      "display" : "Parameter \"%s\" not understood",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Параметр \"%s\" не понят"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Parametro \"%s\" non riconosciuto"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Niezrozumiały parametr \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Paramètre \"%s\" non reconnu"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Parameter \"%s\" onbekend"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "无法理解参数\"%s\""
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Parámetro \"%s\" no reconocido"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_EXAMPLE_PROTECTED",
      "display" : "Resources with identity \"example\" cannot be deleted (for testing/training purposes)",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ресурс с идентификатором \"example\" не может быть удалён (для случаев тестирования/обучения)"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Le Risorse aventi l'identità \"example\" non possono essere cancellate (per finalità di test/formazione)"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zasoby oznaczone jako \"example\" nie mogą zostać usunięte (dla celów testów/szkoleń)"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Les ressources ayant l'identité \"example\" ne peuvent pas être supprimées (utilisées pour les tests/formations)"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Resources met identiteit \"voorbeeld\" kunnen niet worden verwijderd (ten behoeve van testen/training)"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "以\"example\" 为ID的资源不能被删除 (用于测试/培训)"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Recursos con la identidad \"example\" no pueden ser borrados (son usados para pruebas/entrenamiento)"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_ID_FAIL",
      "display" : "unable to allocate resource id",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "невозможно выделить идентификатор ресурса"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "impossibile allocare l''id della risorsa"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "nie można nadać identyfikatora zasobu"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "impossible d'allouer l'id de la ressource"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "kan geen resource-id reserveren"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "无法分配资源ID"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "imposible encontrar el id del recurso"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_ID_MISMATCH",
      "display" : "Resource Id Mismatch",
      "designation" : [
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Problème de correspondance d'Id de la Ressource"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Resource ID's komen niet overeen"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_ID_MISSING",
      "display" : "Resource Id Missing",
      "designation" : [
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id della Risorsa mancante"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Id de la Ressource manquante"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Resource ID ontbreekt"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_NOT_ALLOWED",
      "display" : "Not allowed to submit a resource for this operation",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Для данной операции отправка ресурса недопустима"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Non è consentito sottomettere una risorsa per questa operazione"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nie można zgłosić zasobu dla tej operacji"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Non autorisé à soumettre une ressource pour cette opération"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Niet toegestaan om een resource in te dienen voor deze bewerking"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "该操作不允许提交资源"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "No se permite el envío de un recurso para esta operación"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_REQUIRED",
      "display" : "A resource is required",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Требуется ресурс"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "E'' richiesta una risorsa"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zasób jest wymagany"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Une ressource est requise"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Een resource is verplicht"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "必须提供一个资源"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Se requiere un recurso"
        }
      ]
    },
    {
      "code" : "MSG_RESOURCE_TYPE_MISMATCH",
      "display" : "Resource Type Mismatch",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Несоответствие типа ресурса"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Tipo Risorsa non corrispondente"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Niepoprawny typ zasobu"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Type de ressource incorrect"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verkeerd resourcetype"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "资源类型不匹配"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Los Tipos de los recursos no coinciden"
        }
      ]
    },
    {
      "code" : "MSG_SORT_UNKNOWN",
      "display" : "Unknown sort parameter name \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Неизвестное имя параметра сортировки \"%s\""
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nome del parametro di ordinamento \"%s\" non riconosciuto"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nieznany parametr sortowania \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nom du paramètre de tri inconnu \"%s\""
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Onbekende parameternaam \"%s\" voor sortering"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "未知的排序参数名称\"%s\""
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nombre del parámetro de ordenación \"%s\" desconocido"
        }
      ]
    },
    {
      "code" : "MSG_TRANSACTION_DUPLICATE_ID",
      "display" : "Duplicate Identifier in transaction: %s",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Дублирующий идентификатор в транзакции: %s"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zdublowany identyfikator w transakcji: %s"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identifiant en double dans la transaction : %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Dubbele identificatie in transactie: %s"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "事务中存在重复Id: %s"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identificador duplicado en la transacción: %s"
        }
      ]
    },
    {
      "code" : "MSG_TRANSACTION_MISSING_ID",
      "display" : "Missing Identifier in transaction - an entry.id must be provided",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Отсутствует идентификатор в транзакции - требуется entry.id"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Brak identyfikatora w transakcji - należy podać entry.id"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identifiant manquant dans la transaction - un élément entry.id doit être fourni"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ontbrekende identificatie in transactie - entry.id is verplicht"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "事务中缺少Id - 必须提供一个entry.id"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Identificador de la transacción no encontrado - se debe proporcionar un entry.id"
        }
      ]
    },
    {
      "code" : "MSG_UNHANDLED_NODE_TYPE",
      "display" : "Unhandled xml node type \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Не обработанный xml узел \"%s\""
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Tipo di nodo Xml non gestito \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nieobsługiwany typ węzła XML \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Type de noeud xml \"%s\" non traité"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Kan xml nodetype \"%s\" niet verwerken"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "未处理的XML节点类型\"%s\""
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Tipo de nodo Xml no soportado \"%s\""
        }
      ]
    },
    {
      "code" : "MSG_UNKNOWN_CONTENT",
      "display" : "Unknown Content (%s) at %s",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Неизвестный контент (%s) в %s"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Contenuto Sconosciuto (%s) at %s"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nieznana zawartość (%s) dla %s"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Contenu inconnu (%s) à %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Onbekende content (%s) at %s"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "未知内容 (%s) 位于 %s"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Contenido desconocido (%s) en %s"
        }
      ]
    },
    {
      "code" : "MSG_UNKNOWN_OPERATION",
      "display" : "unknown FHIR http operation",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "неизвестная операция FHIR http"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "operazione http FHIR sconosciuta"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "nieznana operacja FHIR http"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "operation http FHIR inconnue"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "onbekende FHIR http operation"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "未知的FHIR HTTP操作"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Operación http FHIR desconocida"
        }
      ]
    },
    {
      "code" : "MSG_UNKNOWN_TYPE",
      "display" : "Resource Type \"%s\" not recognised",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Тип ресурса \"%s\" не распознан"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Tipo di Risorsa \"%s\" non riconosciuto"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nie rozpoznany typ zasobu: \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Type de ressource \"%s\" non reconnu"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Resourcetype \"%s\" niet herkend"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "资源类型\"%s\"未识别"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Tipo de Recurso \"%s\" no reconocido"
        }
      ]
    },
    {
      "code" : "MSG_UPDATED",
      "display" : "existing resource updated",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "существующий ресурс обновлён"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "risorsa esistente aggiornata"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "uaktualniono istniejący zasób"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "ressource existante mise à jour"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "bestaande resource updated"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "已有资源被更新"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Recurso existente actualizado"
        }
      ]
    },
    {
      "code" : "MSG_VERSION_AWARE",
      "display" : "Version aware updates are required for this resource",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Для данного ресурса необходимы обновления с учётом версии"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Questa risorsa richiede aggiornamenti per versione"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Uaktualnienia zakładające wersjonowanie są wymagane dla tego zasobu"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Des mises à jour en relation avec la version sont requises pour cette ressource"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Versie-bewuste updates zijn vereist voor deze resource"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "该资源的更新必须针对版本"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Este recurso requiere actualizaciones en base a versiones"
        }
      ]
    },
    {
      "code" : "MSG_VERSION_AWARE_CONFLICT",
      "display" : "Update Conflict (server current version = \"%s\", client version referenced = \"%s\")",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Конфликт обновления (текущая версия сервера = \"%s\", указанная версия клиента = \"%s\")"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Conflitto nell''aggiornamento (attuale = \"%s\", quotato = \"%s\")"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Konflikt podczas uaktualnienia (obecna wersja na serwerze = \"%s\", wersja wskazana przez klienta = \"%s\")"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Conflit de mise à jour (version courante du serveur = \"%s\", version référencée du client = \"%s\")"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Updateconflict (huidige serverversie = \"%s\", opgegeven clientversie = \"%s\")"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "更新冲突 (服务器当前版本 = \"%s\", 客户端引用的版本 = \"%s\")"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Conflicto de actualizaciones (versión actual del servidor = \"%s\", versión del cliente referenciada = \"%s\")"
        }
      ]
    },
    {
      "code" : "MSG_VERSION_AWARE_URL",
      "display" : "Version specific URL not recognised",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "URL для указанной версии не распознан"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "URL specifico alla versione non riconosciuto"
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nie rozpoznany URL specyficzny dla wersji"
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "URL spécifique à une version non reconnue"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Versie-specifieke URL niet herkend"
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "未识别特定版本的URL"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "URL especifica de la versión no reconocida"
        }
      ]
    },
    {
      "code" : "MSG_WRONG_NS",
      "display" : "This does not appear to be a FHIR element or resource (wrong namespace \"%s\")",
      "designation" : [
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Dit lijkt geen FHIR element of resource te zijn (verkeerde namespace \"%s\")"
        }
      ]
    },
    {
      "code" : "SEARCH_MULTIPLE",
      "display" : "Error: Multiple matches exist for %s search parameters \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ошибка: множественные совпадения для %s с параметрами поиска \"%s\""
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Errore: Trovate corrispondenze multiple per %s parametri di ricerca \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd: Istnieją wielokrotne dopasowania dla %s parametrów wyszukiwania \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Erreur : Plusieurs correspondances existent pour ce paramètre de recherche %s"
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fout: er is meer dan één resultaat voor %s zoekparameters \"%s\""
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "错误: 对于 %s 搜索的参数 \"%s\"存在多个匹配"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Error: Multiples ocurrencias existen para %s parametros de búsqueda \"%s\""
        }
      ]
    },
    {
      "code" : "SEARCH_NONE",
      "display" : "Error: no processable search found for %s search parameters \"%s\"",
      "designation" : [
        {
          "language" : "ru",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ошибка: обрабатываемых результатов поиска для %s с параметрами поиска \"%s\" не найдено"
        },
        {
          "language" : "it",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Errore: non è stato trovato alcun parametro di ricerca processabile per %s parametri di ricerca \"%s\""
        },
        {
          "language" : "pl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Błąd: Niewykonalne wyszukiwanie dla %s parametrów wyszukiwania \"%s\""
        },
        {
          "language" : "fr",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Erreur : aucune recherche trouvée pour les paramètres %s \"%s\""
        },
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fout: geen verwerkbare zoekactie gevonden voor %s zoekparameters \"%s\""
        },
        {
          "language" : "zh",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "错误: 对%s搜索参数\"%s\"未找到可处理的搜索"
        },
        {
          "language" : "es",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Error: no se encontro una búsqueda apropiada para %s parametros de búsqueda \"%s\""
        }
      ]
    },
    {
      "code" : "UPDATE_MULTIPLE_MATCHES",
      "display" : "Error: Multiple matches exist for the conditional update",
      "designation" : [
        {
          "language" : "nl",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Fout: er is meer dan één resultaat voor de conditionele update"
        }
      ]
    }
  ]
}

```
