# AuditEventEntityRole - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AuditEventEntityRole**

## CodeSystem: AuditEventEntityRole 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/object-role | *Version*:1.1.0 | | |
| Active as of 2025-05-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AuditEventEntityRole |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1135 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Code representing the role the entity played in the audit event. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AuditEventEntityRole](ValueSet-object-role.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "object-role",
  "meta" : {
    "lastUpdated" : "2025-05-13T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sec"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/object-role",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1135"
    }
  ],
  "version" : "1.1.0",
  "name" : "AuditEventEntityRole",
  "title" : "AuditEventEntityRole",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-05-13T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code representing the role the entity played in the audit event.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/object-role",
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "Patient",
      "definition" : "This object is the patient that is the subject of care related to this event.  It is identifiable by patient ID or equivalent.  The patient may be either human or animal."
    },
    {
      "code" : "2",
      "display" : "Location",
      "definition" : "This is a location identified as related to the event.  This is usually the location where the event took place.  Note that for shipping, the usual events are arrival at a location or departure from a location."
    },
    {
      "code" : "3",
      "display" : "Report",
      "definition" : "This object is any kind of persistent document created as a result of the event.  This could be a paper report, film, electronic report, DICOM Study, etc.  Issues related to medical records life cycle management are conveyed elsewhere."
    },
    {
      "code" : "4",
      "display" : "Domain Resource",
      "definition" : "A logical object related to a health record event.  This is any healthcare  specific resource (object) not restricted to FHIR defined Resources."
    },
    {
      "code" : "5",
      "display" : "Master file",
      "definition" : "This is any configurable file used to control creation of documents.  Examples include the objects maintained by the HL7 Master File transactions, Value Sets, etc."
    },
    {
      "code" : "6",
      "display" : "User",
      "definition" : "A human participant not otherwise identified by some other category."
    },
    {
      "code" : "7",
      "display" : "List",
      "definition" : "(deprecated)."
    },
    {
      "code" : "8",
      "display" : "Doctor",
      "definition" : "Typically, a licensed person who is providing or performing care related to the event, generally a physician.   The key distinction between doctor and practitioner is with regards to their role, not the licensing.  The doctor is the human who actually performed the work.  The practitioner is the human or organization that is responsible for the work."
    },
    {
      "code" : "9",
      "display" : "Subscriber",
      "definition" : "A person or system that is being notified as part of the event.  This is relevant in situations where automated systems provide notifications to other parties when an event took place."
    },
    {
      "code" : "10",
      "display" : "Guarantor",
      "definition" : "Insurance company, or any other organization who accepts responsibility for paying for the healthcare event."
    },
    {
      "code" : "11",
      "display" : "Security User Entity",
      "definition" : "A person or active system object involved in the event with a security role."
    },
    {
      "code" : "12",
      "display" : "Security User Group",
      "definition" : "A person or system object involved in the event with the authority to modify security roles of other objects."
    },
    {
      "code" : "13",
      "display" : "Security Resource",
      "definition" : "A passive object, such as a role table, that is relevant to the event."
    },
    {
      "code" : "14",
      "display" : "Security Granularity Definition",
      "definition" : "(deprecated)  Relevant to certain RBAC security methodologies."
    },
    {
      "code" : "15",
      "display" : "Practitioner",
      "definition" : "Any person or organization responsible for providing care.  This encompasses all forms of care, licensed or otherwise, and all sorts of teams and care groups. Note the distinction between practitioner and the doctor that actually provided the care to the patient."
    },
    {
      "code" : "16",
      "display" : "Data Destination",
      "definition" : "The source or destination for data transfer, when it does not match some other role."
    },
    {
      "code" : "17",
      "display" : "Data Repository",
      "definition" : "A source or destination for data transfer that acts as an archive, database, or similar role."
    },
    {
      "code" : "18",
      "display" : "Schedule",
      "definition" : "An object that holds schedule information.  This could be an appointment book, availability information, etc."
    },
    {
      "code" : "19",
      "display" : "Customer",
      "definition" : "An organization or person that is the recipient of services.  This could be an organization that is buying services for a patient, or a person that is buying services for an animal."
    },
    {
      "code" : "20",
      "display" : "Job",
      "definition" : "An order, task, work item, procedure step, or other description of work to be performed; e.g. a particular instance of an MPPS."
    },
    {
      "code" : "21",
      "display" : "Job Stream",
      "definition" : "A list of jobs or a system that provides lists of jobs; e.g. an MWL SCP."
    },
    {
      "code" : "22",
      "display" : "Table",
      "definition" : "(Deprecated)."
    },
    {
      "code" : "23",
      "display" : "Routing Criteria",
      "definition" : "An object that specifies or controls the routing or delivery of items.  For example, a distribution list is the routing criteria for mail.  The items delivered may be documents, jobs, or other objects."
    },
    {
      "code" : "24",
      "display" : "Query",
      "definition" : "The contents of a query.  This is used to capture the contents of any kind of query.  For security surveillance purposes knowing the queries being made is very important."
    },
    {
      "code" : "25",
      "display" : "Data Source",
      "definition" : "The source or origin of data, when there is no other matching role available"
    },
    {
      "code" : "26",
      "display" : "Processing Element",
      "definition" : "A data processing element that creates, analyzes, modifies, or manipulates data as part of this event."
    }
  ]
}

```
