# MedicationAdministration Performer Function Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationAdministration Performer Function Codes**

## CodeSystem: MedicationAdministration Performer Function Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/med-admin-perform-function | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationAdministrationPerformerFunctionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1112 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
MedicationAdministration Performer Function Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationAdministrationPerformerFunctionCodes](ValueSet-med-admin-perform-function.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "med-admin-perform-function",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/med-admin-perform-function",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1112"
    }
  ],
  "version" : "1.0.1",
  "name" : "MedicationAdministrationPerformerFunctionCodes",
  "title" : "MedicationAdministration Performer Function Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationAdministration Performer Function Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/med-admin-perform-function",
  "content" : "complete",
  "concept" : [
    {
      "code" : "performer",
      "display" : "Performer",
      "definition" : "A person, non-person living subject, organization or device that who actually and principally carries out the action"
    },
    {
      "code" : "verifier",
      "display" : "Verifier",
      "definition" : "A person who verifies the correctness and appropriateness of the service (plan, order, event, etc.) and hence takes on accountability."
    },
    {
      "code" : "witness",
      "display" : "Witness",
      "definition" : "A person witnessing the action happening without doing anything. A witness is not necessarily aware, much less approves of anything stated in the service event. Example for a witness is students watching an operation or an advanced directive witness."
    }
  ]
}

```
