# MeasureDataUsage - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MeasureDataUsage**

## CodeSystem: MeasureDataUsage 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-data-usage | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasureDataUsage |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1234 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The intended usage for supplemental data elements in the measure. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureDataUsage](ValueSet-measure-data-usage.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-data-usage",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1234"
    }
  ],
  "version" : "1.0.1",
  "name" : "MeasureDataUsage",
  "title" : "MeasureDataUsage",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The intended usage for supplemental data elements in the measure.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/measure-data-usage",
  "content" : "complete",
  "concept" : [
    {
      "code" : "supplemental-data",
      "display" : "Supplemental Data",
      "definition" : "The data is intended to be provided as additional information alongside the measure results."
    },
    {
      "code" : "risk-adjustment-factor",
      "display" : "Risk Adjustment Factor",
      "definition" : "The data is intended to be used to calculate and apply a risk adjustment model for the measure."
    }
  ]
}

```
