# Measure Aggregate Method - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Measure Aggregate Method**

## CodeSystem: Measure Aggregate Method 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-aggregate-method | *Version*:2.0.0 | |
| Active as of 2023-02-08 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasureAggregateMethod |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Aggregation method for a measure (e.g. sum, average, median, minimum, maximum, count) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureAggregateMethod](ValueSet-measure-aggregate-method.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-aggregate-method",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-aggregate-method",
  "version" : "2.0.0",
  "name" : "MeasureAggregateMethod",
  "title" : "Measure Aggregate Method",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-02-08T23:21:03-06:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Aggregation method for a measure (e.g. sum, average, median, minimum, maximum,    count)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "sum",
      "display" : "Sum",
      "definition" : "The measure score is determined by adding together the observations derived from      the measure population."
    },
    {
      "code" : "average",
      "display" : "Average",
      "definition" : "The measure score is determined by taking the average of the observations derived      from the measure population."
    },
    {
      "code" : "median",
      "display" : "Median",
      "definition" : "The measure score is determined by taking the median of the observations derived      from the measure population."
    },
    {
      "code" : "minimum",
      "display" : "Minimum",
      "definition" : "The measure score is determined by taking the minimum of the observations derived      from the measure population."
    },
    {
      "code" : "maximum",
      "display" : "Maximum",
      "definition" : "The measure score is determined by taking the maximum of the observations derived      from the measure population."
    },
    {
      "code" : "count",
      "display" : "Count",
      "definition" : "The measure score is determined as the number of observations derived from the      measure population."
    }
  ]
}

```
