# Example Use Codes for List - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Use Codes for List**

## CodeSystem: Example Use Codes for List 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/list-example-use-codes | *Version*:1.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleUseCodesForList |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1105 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Example use codes for the List resource - typical kinds of use. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleUseCodesForList](ValueSet-list-example-codes.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "list-example-use-codes",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/list-example-use-codes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1105"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleUseCodesForList",
  "title" : "Example Use Codes for List",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Example use codes for the List resource - typical kinds of use.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/list-example-codes",
  "content" : "complete",
  "concept" : [
    {
      "code" : "alerts",
      "display" : "Alerts",
      "definition" : "A list of alerts for the patient."
    },
    {
      "code" : "adverserxns",
      "display" : "Adverse Reactions",
      "definition" : "A list of part adverse reactions."
    },
    {
      "code" : "allergies",
      "display" : "Allergies",
      "definition" : "A list of Allergies for the patient."
    },
    {
      "code" : "medications",
      "display" : "Medication List",
      "definition" : "A list of medication statements for the patient."
    },
    {
      "code" : "problems",
      "display" : "Problem List",
      "definition" : "A list of problems that the patient is known of have (or have had in the past)."
    },
    {
      "code" : "worklist",
      "display" : "Worklist",
      "definition" : "A list of items that constitute a set of work to be performed (typically this code would be specialized for more specific uses, such as a ward round list)."
    },
    {
      "code" : "waiting",
      "display" : "Waiting List",
      "definition" : "A list of items waiting for an event (perhaps a surgical patient waiting list)."
    },
    {
      "code" : "protocols",
      "display" : "Protocols",
      "definition" : "A set of protocols to be followed."
    },
    {
      "code" : "plans",
      "display" : "Care Plans",
      "definition" : "A set of care plans that apply in a particular context of care."
    }
  ]
}

```
