# Insurance plan type - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Insurance plan type**

## CodeSystem: Insurance plan type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/insurance-plan-type | *Version*:2.0.1 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InsurancePlanType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1261 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This example value set defines a set of codes that can be used to indicate a type of insurance plan. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [InsurancePlanType](ValueSet-insuranceplan-type.md)

Last updated: 2024-04-24 00:00:00+0000

Profile: [Shareable CodeSystem](http://hl7.org/fhir/R5/shareablecodesystem.html)

**Properties**

**This code system defines the following properties for its concepts**

**Concepts**

This case-sensitive code system `http://terminology.hl7.org/CodeSystem/insurance-plan-type` provides **a fragment** that includes following codes:

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "insurance-plan-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/insurance-plan-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1261"
    }
  ],
  "version" : "2.0.1",
  "name" : "InsurancePlanType",
  "title" : "Insurance plan type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of codes that can be used to indicate a type of insurance plan.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/insuranceplan-type",
  "content" : "fragment",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "inactive",
      "uri" : "http://hl7.org/fhir/concept-properties#inactive",
      "description" : "True if the concept is not considered active - e.g. not a valid concept any more",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "medical",
      "display" : "Medical"
    },
    {
      "code" : "dental",
      "display" : "Dental"
    },
    {
      "code" : "mental",
      "display" : "Mental Health"
    },
    {
      "code" : "subst-ab",
      "display" : "Substance Abuse"
    },
    {
      "code" : "vision",
      "display" : "Vision"
    },
    {
      "code" : "drug",
      "display" : "Drug"
    },
    {
      "code" : "short-term",
      "display" : "Short Term"
    },
    {
      "code" : "long-term",
      "display" : "Long Term Care"
    },
    {
      "code" : "hospice",
      "display" : "Hospice"
    },
    {
      "code" : "home",
      "display" : "Home Health"
    },
    {
      "code" : "Drug",
      "display" : "Drug",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "inactive",
          "valueCode" : "true"
        }
      ]
    }
  ]
}

```
