# Immunization Recommendation Status Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Recommendation Status Codes**

## CodeSystem: Immunization Recommendation Status Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/immunization-recommendation-status | *Version*:2.0.0 | | |
| Active as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImmunizationRecommendationStatusCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1104 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the status of the patient towards perceived immunity against a vaccine preventable disease. This value set is provided as a suggestive example. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ImmunizationRecommendationStatusCodes](ValueSet-immunization-recommendation-status.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "immunization-recommendation-status",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/immunization-recommendation-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1104"
    }
  ],
  "version" : "2.0.0",
  "name" : "ImmunizationRecommendationStatusCodes",
  "title" : "Immunization Recommendation Status Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the status of the patient towards perceived immunity against a vaccine preventable disease. This value set is provided as a suggestive example.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/immunization-recommendation-status",
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "due",
      "display" : "Due",
      "definition" : "The patient is due (or will be due) for their next vaccination. Details on when the administration should be given can be conveyed by  proposed dates in the recommendation."
    },
    {
      "code" : "overdue",
      "display" : "Overdue",
      "definition" : "The patient is considered overdue for their next vaccination."
    },
    {
      "code" : "immune",
      "display" : "Immune",
      "definition" : "The patient is immune to the target disease and further immunization against the disease is not likely to provide benefit."
    },
    {
      "code" : "contraindicated",
      "display" : "Contraindicated",
      "definition" : "The patient is contraindicated for futher doses."
    },
    {
      "code" : "seriescomplete",
      "display" : "Series Complete",
      "definition" : "The patient is fully protected and no further doses are recommended."
    },
    {
      "code" : "agedout",
      "display" : "Aged Out",
      "definition" : "The patient has aged out of further doses in the recommended series."
    },
    {
      "code" : "complete",
      "display" : "Complete",
      "definition" : "The patient is fully protected and no further doses are recommended.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        }
      ]
    }
  ]
}

```
