# FamilyHistoryAbsentReason - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FamilyHistoryAbsentReason**

## CodeSystem: FamilyHistoryAbsentReason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/history-absent-reason | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:FamilyHistoryAbsentReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1094 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes describing the reason why a family member's history is not available. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FamilyHistoryAbsentReason](ValueSet-history-absent-reason.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "history-absent-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/history-absent-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1094"
    }
  ],
  "version" : "1.0.1",
  "name" : "FamilyHistoryAbsentReason",
  "title" : "FamilyHistoryAbsentReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes describing the reason why a family member's history is not available.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/history-absent-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "subject-unknown",
      "display" : "Subject Unknown",
      "definition" : "Patient does not know the subject, e.g. the biological parent of an adopted patient."
    },
    {
      "code" : "withheld",
      "display" : "Information Withheld",
      "definition" : "The patient withheld or refused to share the information."
    },
    {
      "code" : "unable-to-obtain",
      "display" : "Unable To Obtain",
      "definition" : "Information cannot be obtained; e.g. unconscious patient."
    },
    {
      "code" : "deferred",
      "display" : "Deferred",
      "definition" : "Patient does not have the information now, but can provide the information at a later date."
    }
  ]
}

```
