# ExpansionProcessingRule - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExpansionProcessingRule**

## CodeSystem: ExpansionProcessingRule 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/expansion-processing-rule | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExpansionProcessingRule |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1281 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Defines how concepts are processed into the expansion when it's for UI presentation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExpansionProcessingRule](ValueSet-expansion-processing-rule.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "expansion-processing-rule",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/expansion-processing-rule",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1281"
    }
  ],
  "version" : "1.0.0",
  "name" : "ExpansionProcessingRule",
  "title" : "ExpansionProcessingRule",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Defines how concepts are processed into the expansion when it's for UI presentation.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/expansion-processing-rule",
  "content" : "complete",
  "concept" : [
    {
      "code" : "all-codes",
      "display" : "All Codes",
      "definition" : "The expansion (when in UI mode) includes all codes *and* any defined groups (in extensions)."
    },
    {
      "code" : "ungrouped",
      "display" : "Groups + Ungrouped codes",
      "definition" : "The expanion (when in UI mode) lists the groups, and then any codes that have not been included in a group."
    },
    {
      "code" : "groups-only",
      "display" : "Groups Only",
      "definition" : "The expansion (when in UI mode) only includes the defined groups."
    }
  ]
}

```
