# USCLS Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **USCLS Codes**

## CodeSystem: USCLS Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-USCLS | *Version*:1.0.0 | | |
| Draft as of 2025-11-12 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:USCLSCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1153 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value set includes a smattering of USCLS codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [USCLSCodes](ValueSet-service-uscls.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-USCLS",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-USCLS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1153"
    }
  ],
  "version" : "1.0.0",
  "name" : "USCLSCodes",
  "title" : "USCLS Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of USCLS codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/service-uscls",
  "content" : "complete",
  "concept" : [
    {
      "code" : "1101",
      "display" : "Exam, comp, primary",
      "definition" : "Exam, comp, primary"
    },
    {
      "code" : "1102",
      "display" : "Exam, comp, mixed",
      "definition" : "Exam, comp, mixed"
    },
    {
      "code" : "1103",
      "display" : "Exam, comp, permanent",
      "definition" : "Exam, comp, permanent"
    },
    {
      "code" : "1201",
      "display" : "Exam, recall",
      "definition" : "Exam, recall"
    },
    {
      "code" : "1205",
      "display" : "Exam, emergency",
      "definition" : "Exam, emergency"
    },
    {
      "code" : "2101",
      "display" : "Radiograph, series (12)",
      "definition" : "Radiograph, series (12)"
    },
    {
      "code" : "2102",
      "display" : "Radiograph, series (16)",
      "definition" : "Radiograph, series (16)"
    },
    {
      "code" : "2141",
      "display" : "Radiograph, bitewing",
      "definition" : "Radiograph, bitewing"
    },
    {
      "code" : "2601",
      "display" : "Radiograph, panoramic",
      "definition" : "Radiograph, panoramic"
    },
    {
      "code" : "11101",
      "display" : "Polishing, 1 unit",
      "definition" : "Polishing, 1 unit"
    },
    {
      "code" : "11102",
      "display" : "Polishing, 2 unit",
      "definition" : "Polishing, 2 unit"
    },
    {
      "code" : "11103",
      "display" : "Polishing, 3 unit",
      "definition" : "Polishing, 3 unit"
    },
    {
      "code" : "11104",
      "display" : "Polishing, 4 unit",
      "definition" : "Polishing, 4 unit"
    },
    {
      "code" : "21211",
      "display" : "Amalgam, 1 surface",
      "definition" : "Amalgam, 1 surface"
    },
    {
      "code" : "21212",
      "display" : "Amalgam, 2 surface",
      "definition" : "Amalgam, 2 surface"
    },
    {
      "code" : "27211",
      "display" : "Crown, PFM",
      "definition" : "Crown, PFM"
    },
    {
      "code" : "67211",
      "display" : "Maryland Bridge",
      "definition" : "Maryland Bridge"
    },
    {
      "code" : "99111",
      "display" : "Lab, commercial",
      "definition" : "Lab, commercial"
    },
    {
      "code" : "99333",
      "display" : "Lab, in office",
      "definition" : "Lab, in office"
    },
    {
      "code" : "99555",
      "display" : "Expense",
      "definition" : "Expense"
    }
  ]
}

```
