# EvidenceDirectness - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EvidenceDirectness**

## CodeSystem: EvidenceDirectness 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/directness | *Version*:2.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EvidenceDirectness |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1459 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The quality of how direct the match is. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EvidenceDirectness](ValueSet-directness.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "directness",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/directness",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1459"
    }
  ],
  "version" : "2.0.0",
  "name" : "EvidenceDirectness",
  "title" : "EvidenceDirectness",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The quality of how direct the match is.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/directness",
  "content" : "complete",
  "concept" : [
    {
      "code" : "low",
      "display" : "Low quality match between observed and intended variable",
      "definition" : "Low matching quality between observed and intended variable, so very serious concern      for indirectness in evidence interpretation."
    },
    {
      "code" : "moderate",
      "display" : "Moderate quality match between observed and intended variable",
      "definition" : "Moderate matching quality between observed and intended variable, so serious concern      for indirectness in evidence interpretation."
    },
    {
      "code" : "high",
      "display" : "High quality match between observed and intended variable",
      "definition" : "High matching quality between observed and intended variable, so little concern      for indirectness in evidence interpretation."
    },
    {
      "code" : "exact",
      "display" : "Exact match between observed and intended variable",
      "definition" : "Exact matching quality between observed and intended variable, so no concern for      indirectness in evidence interpretation."
    }
  ]
}

```
