# Device Alert Priority - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Device Alert Priority**

## CodeSystem: Device Alert Priority 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/devicealert-priority | *Version*:1.0.0 | | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DeviceAlertPriority |

 
Describes the priority of a DeviceAlert. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DeviceAlertPriorityCodes](ValueSet-devicealert-priority.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "devicealert-priority",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "dev"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/devicealert-priority",
  "version" : "1.0.0",
  "name" : "DeviceAlertPriority",
  "title" : "Device Alert Priority",
  "status" : "draft",
  "experimental" : false,
  "date" : "2023-12-10T10:01:24+11:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Describes the priority of a DeviceAlert.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/devicealert-priority",
  "content" : "complete",
  "concept" : [
    {
      "code" : "high",
      "display" : "High Priority",
      "definition" : "The alert is about a potentially life-threatening condition that should be addressed immediately."
    },
    {
      "code" : "medium",
      "display" : "Medium Priority",
      "definition" : "The alert is about a significant condition that should be addressed promptly."
    },
    {
      "code" : "low",
      "display" : "Low Priority",
      "definition" : "The alert is about a condition that should be addressed."
    },
    {
      "code" : "info",
      "display" : "Information Only",
      "definition" : "The alert is about a condition that does not need addressing."
    }
  ]
}

```
