# Coverage SelfPay Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage SelfPay Codes**

## CodeSystem: Coverage SelfPay Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/coverage-selfpay | *Version*:1.0.1 | |
| Active as of 2025-11-12 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CoverageSelfPayCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1148 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
This value set includes Coverage SelfPay codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CoverageSelfPayCodes](ValueSet-coverage-selfpay.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coverage-selfpay",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "url" : "http://terminology.hl7.org/CodeSystem/coverage-selfpay",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1148"
    }
  ],
  "version" : "1.0.1",
  "name" : "CoverageSelfPayCodes",
  "title" : "Coverage SelfPay Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes Coverage SelfPay codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/coverage-selfpay",
  "content" : "complete",
  "concept" : [
    {
      "code" : "pay",
      "display" : "Pay",
      "definition" : "An individual or organization is paying directly for goods and services."
    },
    {
      "code" : "payconc",
      "display" : "Concession",
      "definition" : "An individual or organization is paying directly a concessional fee for goods and services."
    }
  ]
}

```
