# AlternativeCodeKind - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AlternativeCodeKind**

## CodeSystem: AlternativeCodeKind 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/composition-altcode-kind | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AlternativeCodeKind |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1406 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Indicates the type of use for which the code is defined. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AlternativeCodeKind](ValueSet-composition-altcode-kind.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "composition-altcode-kind",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/composition-altcode-kind",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1406"
    }
  ],
  "version" : "1.0.0",
  "name" : "AlternativeCodeKind",
  "title" : "AlternativeCodeKind",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates the type of use for which the code is defined.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/composition-altcode-kind",
  "content" : "complete",
  "concept" : [
    {
      "code" : "alternate",
      "display" : "Alternate Code",
      "definition" : "The code is an alternative code that can be used in any of the circumstances that the primary code can be used."
    },
    {
      "code" : "deprecated",
      "display" : "Deprecated",
      "definition" : "The code should no longer be used, but was used in the past."
    },
    {
      "code" : "case-insensitive",
      "display" : "Case Insensitive",
      "definition" : "The code is an alternative to be used when a case insensitive code is required (when the primary codes are case sensitive)."
    },
    {
      "code" : "case-sensitive",
      "display" : "Case Sensitive",
      "definition" : "The code is an alternative to be used when a case sensitive code is required (when the primary codes are case insensitive)."
    },
    {
      "code" : "expression",
      "display" : "Expression",
      "definition" : "The code is an alternative for the primary code that is built using the expression grammar defined by the code system."
    }
  ]
}

```
